/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.azure.preference;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.integration.azure.constant.StringConstants;
import com.kms.katalon.composer.integration.azure.preference.composite.AzureAuthenticationComposite;
import com.kms.katalon.composer.integration.azure.preference.composite.AzureProjectSettingComposite;
import com.kms.katalon.integration.azure.exception.AzureApiException;
import com.kms.katalon.integration.azure.model.AzureCredential;
import com.kms.katalon.integration.azure.model.AzureProjectRef;
import com.kms.katalon.integration.azure.model.AzureProjectsRef;
import com.kms.katalon.integration.azure.provider.AzureIntegrationRequest;
import com.kms.katalon.integration.azure.setting.AzureSettingStore;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import jakarta.inject.Inject;
import java.util.concurrent.Executors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AzurePreferencePage
extends PreferencePageWithHelp {
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    private AzureSettingStore settingStore = AzureSettingStore.getStore();
    private Composite container;
    private Button chckEnableIntegration;
    private AzureAuthenticationComposite authenticationComposite;
    private AzureProjectSettingComposite projectSettingComposite;

    protected Control createContents(Composite parent) {
        this.container = (Composite)ComponentBuilder.gridContainer((Composite)parent).fill().build();
        this.chckEnableIntegration = (Button)ComponentBuilder.checkBox((Composite)this.container).text(StringConstants.CHK_ENABLE_INTEGRATION).fillHorizontal().build();
        this.authenticationComposite = new AzureAuthenticationComposite(this.container, this.settingStore);
        this.projectSettingComposite = new AzureProjectSettingComposite(this.container, this.settingStore, this.authenticationComposite);
        this.registerControlModifyListeners();
        this.initializeData();
        return this.container;
    }

    private void registerControlModifyListeners() {
        this.chckEnableIntegration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AzurePreferencePage.this.featureController.canUse(ProductFeature.OVERRIDE_TESTOPS_AUTHENTICATION)) {
                    AzurePreferencePage.this.productFeatureDialog.showNotAvailableFeature(ProductFeature.OVERRIDE_TESTOPS_AUTHENTICATION);
                    AzurePreferencePage.this.chckEnableIntegration.setSelection(false);
                }
                AzurePreferencePage.this.enableIntegration(AzurePreferencePage.this.chckEnableIntegration.getSelection());
            }
        });
        this.authenticationComposite.addConnectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AzureCredential credential = AzurePreferencePage.this.authenticationComposite.getEddingCredential();
                AzurePreferencePage.this.authenticationComposite.enableButtonConnect(false);
                Executors.newFixedThreadPool(1).submit(() -> {
                    UISynchronizeService.syncExec(() -> AzurePreferencePage.this.authenticationComposite.showConnectingMessage());
                    UISynchronizeService.syncExec(() -> {
                        try {
                            AzureProjectsRef fetchedProject = AzureIntegrationRequest.getProjects((AzureCredential)credential);
                            if (fetchedProject != null && fetchedProject.getCount() > 0) {
                                AzureProjectRef[] projects = fetchedProject.getValue();
                                AzurePreferencePage.this.authenticationComposite.showSuccessMessage();
                                AzurePreferencePage.this.projectSettingComposite.updateComboProjectsValue(null, projects, false, true);
                                AzurePreferencePage.this.projectSettingComposite.setEnabled(true);
                                AzurePreferencePage.this.projectSettingComposite.setIsSelectingDefaultProject();
                            } else {
                                AzurePreferencePage.this.projectSettingComposite.setEnabled(false);
                                AzurePreferencePage.this.authenticationComposite.showErrorMessage(StringConstants.MSG_NO_PROJECT);
                            }
                        }
                        catch (AzureApiException exception) {
                            AzurePreferencePage.this.projectSettingComposite.setEnabled(false);
                            AzurePreferencePage.this.authenticationComposite.showErrorMessage((Exception)((Object)exception));
                            LoggerSingleton.logError((Throwable)exception.fillInStackTrace());
                        }
                    });
                });
            }
        });
    }

    private void enableIntegration(boolean isEnabled) {
        this.authenticationComposite.setEnabled(isEnabled);
        if (this.projectSettingComposite.isEnabled()) {
            this.projectSettingComposite.setEnabled(false);
        }
    }

    private void initializeData() {
        if (!this.settingStore.isIntegrationEnabled()) {
            this.enableIntegration(false);
            return;
        }
        this.chckEnableIntegration.setSelection(this.settingStore.isIntegrationEnabled());
    }

    private boolean checkValidationBeforeSaving() {
        if (!this.chckEnableIntegration.getSelection()) {
            return true;
        }
        if (!this.authenticationComposite.checkValidationBeforeSaving()) {
            return false;
        }
        return this.projectSettingComposite.checkValidationBeforeSaving();
    }

    private void saveToSettingStore() {
        try {
            this.settingStore.setIntegration(this.chckEnableIntegration.getSelection());
            this.authenticationComposite.saveToSettingStore();
            this.projectSettingComposite.saveToSettingStore();
        }
        catch (Exception exception) {
            LoggerSingleton.logError((Throwable)exception, (String)StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS);
            MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)StringConstants.AZURE_DEVOPS_NAME, (String)(StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS + "\n" + exception.getMessage()));
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.container == null) {
            return;
        }
        this.authenticationComposite.restoreToDefault();
        this.projectSettingComposite.restoreToDefault();
        if (!this.featureController.canUse(ProductFeature.OVERRIDE_TESTOPS_AUTHENTICATION) || !this.settingStore.isIntegrationEnabled()) {
            this.chckEnableIntegration.setSelection(false);
            this.enableIntegration(false);
            return;
        }
        boolean isIntegrationEnabled = this.settingStore.isIntegrationEnabled();
        this.chckEnableIntegration.setSelection(isIntegrationEnabled);
        this.authenticationComposite.setEnabled(isIntegrationEnabled);
        if (this.projectSettingComposite.getProjects().length > 0) {
            this.projectSettingComposite.setEnabled(true);
        } else {
            this.projectSettingComposite.setEnabled(false);
        }
    }

    public boolean performOk() {
        if (this.container == null) {
            return super.performOk();
        }
        if (this.checkValidationBeforeSaving()) {
            this.saveToSettingStore();
            return super.performOk();
        }
        return false;
    }

    static /* synthetic */ AzureAuthenticationComposite access$0(AzurePreferencePage azurePreferencePage) {
        return azurePreferencePage.authenticationComposite;
    }

    static /* synthetic */ AzureProjectSettingComposite access$1(AzurePreferencePage azurePreferencePage) {
        return azurePreferencePage.projectSettingComposite;
    }
}

