/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.azure.preference.composite;

import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.integration.azure.component.AzureConnectionResult;
import com.kms.katalon.composer.integration.azure.component.AzureFetchProjectsJob;
import com.kms.katalon.composer.integration.azure.component.AzureVerifyTestPlanJob;
import com.kms.katalon.composer.integration.azure.component.AzureVerifyTestPlanResult;
import com.kms.katalon.composer.integration.azure.constant.StringConstants;
import com.kms.katalon.composer.integration.azure.preference.composite.AzureAuthenticationComposite;
import com.kms.katalon.composer.integration.azure.preference.composite.SubmissionOptionsComposite;
import com.kms.katalon.composer.integration.azure.preference.composite.TestArtifactsMappingComposite;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.integration.azure.exception.AzureApiException;
import com.kms.katalon.integration.azure.model.AzureCredential;
import com.kms.katalon.integration.azure.model.AzureProjectRef;
import com.kms.katalon.integration.azure.model.AzureProjectsRef;
import com.kms.katalon.integration.azure.model.AzureTestPlanRef;
import com.kms.katalon.integration.azure.model.AzureTestPlansRef;
import com.kms.katalon.integration.azure.provider.AzureIntegrationRequest;
import com.kms.katalon.integration.azure.setting.AzureSettingStore;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AzureProjectSettingComposite
extends Group {
    private Button btnFetchProjects;
    private Combo cbbProject;
    private CheckboxTableViewer tvTestPlans;
    private Label lblNoTestPlans;
    private StackLayout testPlansStackLayout;
    private Composite testPlansComposite;
    private AzureProjectRef[] projects;
    private AzureProjectRef selectedProject;
    private AzureTestPlanRef[] testPlans;
    private AzureTestPlanRef[] selectedTestPlans;
    private AzureSettingStore settingStore;
    private TestArtifactsMappingComposite testArtifactsMappingComposite;
    private SubmissionOptionsComposite submissionOptionsComposite;
    private AzureAuthenticationComposite authenticationComposite;
    private boolean selectedDefaultProject = true;

    public AzureProjectSettingComposite(Composite parent, AzureSettingStore settingStore, AzureAuthenticationComposite authenticationComposite) {
        super(parent, 0);
        ComponentBuilder.fromGrid((Composite)this).fillHorizontal().fillVertical().build();
        this.authenticationComposite = authenticationComposite;
        this.settingStore = settingStore;
        this.createContents((Composite)this);
        this.initializeData();
    }

    protected void checkSubclass() {
    }

    private Control createContents(Composite parent) {
        ComponentBuilder.label((Composite)parent, (int)0).text(StringConstants.LBL_PROJECT_SETTINGS_DESCRIPTION).build();
        ComponentBuilder.label((Composite)parent, (int)0).text(StringConstants.LBL_PROJECT).build();
        Composite fetchProjectsComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2, (int)0).fillHorizontal().build();
        this.cbbProject = (Combo)ComponentBuilder.comboBox((Composite)fetchProjectsComposite, (int)8).gridLayout().fillHorizontal().build();
        this.btnFetchProjects = (Button)ComponentBuilder.button((Composite)fetchProjectsComposite, (int)0).text(StringConstants.BTN_FETCH_PROJECTS).build();
        ComponentBuilder.label((Composite)parent, (int)0).text(StringConstants.LBL_TEST_PLANS).build();
        this.testPlansComposite = new Composite(parent, 0);
        GridData testPlansCompositeGridData = new GridData(4, 128, true, false);
        testPlansCompositeGridData.heightHint = 150;
        this.testPlansComposite.setLayoutData((Object)testPlansCompositeGridData);
        this.testPlansStackLayout = new StackLayout();
        this.testPlansComposite.setLayout((Layout)this.testPlansStackLayout);
        GridData tvTestPlansLayout = new GridData(4, 4, true, true);
        this.lblNoTestPlans = new Label(this.testPlansComposite, 18432);
        this.lblNoTestPlans.setText(StringConstants.MSG_WARNING_NO_TEST_PLANS);
        this.lblNoTestPlans.setLayoutData((Object)tvTestPlansLayout);
        this.tvTestPlans = CheckboxTableViewer.newCheckList((Composite)this.testPlansComposite, (int)68354);
        this.tvTestPlans.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tvTestPlansLayout.heightHint = 150;
        this.tvTestPlans.getTable().setLayoutData((Object)tvTestPlansLayout);
        this.tvTestPlans.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((AzureTestPlanRef)element).getName();
            }
        });
        this.testArtifactsMappingComposite = new TestArtifactsMappingComposite(parent, this.settingStore);
        this.submissionOptionsComposite = new SubmissionOptionsComposite(parent, this.settingStore);
        this.registerControlModifyListeners();
        return parent;
    }

    private void registerControlModifyListeners() {
        this.cbbProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (AzureProjectSettingComposite.this.projects == null || AzureProjectSettingComposite.this.cbbProject.getSelectionIndex() < 0) {
                    return;
                }
                this.expandOptionsWhenFirstTimeSelect();
                AzureProjectRef newChosenProject = AzureProjectSettingComposite.this.projects[AzureProjectSettingComposite.this.cbbProject.getSelectionIndex()];
                if (newChosenProject.getId().equals(AzureProjectSettingComposite.this.selectedProject.getId())) {
                    AzureProjectSettingComposite.this.refreshProjectOptions(AzureProjectSettingComposite.this.authenticationComposite.getEddingCredential(), AzureProjectSettingComposite.this.selectedProject.getId(), false);
                    return;
                }
                if (AzureProjectSettingComposite.this.hasOptionsEditted()) {
                    MessageDialog warningDialog = new MessageDialog(null, StringConstants.AZURE_DEVOPS_NAME, null, StringConstants.MSG_WARNING_CHANGE_PROJECT, 4, new String[]{StringConstants.BTN_PROCEED_ANYWAY, StringConstants.BTN_CANCEL}, 0);
                    if (warningDialog.open() == 0) {
                        AzureProjectSettingComposite.this.selectedProject = newChosenProject;
                        AzureProjectSettingComposite.this.resetProjectOptions(AzureProjectSettingComposite.this.authenticationComposite.getEddingCredential(), AzureProjectSettingComposite.this.selectedProject.getId(), false);
                    } else {
                        AzureProjectSettingComposite.this.cbbProject.select(AzureProjectSettingComposite.this.getProjectIndex(AzureProjectSettingComposite.this.selectedProject, true));
                    }
                } else {
                    AzureProjectSettingComposite.this.selectedProject = newChosenProject;
                    AzureProjectSettingComposite.this.resetProjectOptions(AzureProjectSettingComposite.this.authenticationComposite.getEddingCredential(), AzureProjectSettingComposite.this.selectedProject.getId(), false);
                }
            }

            private void expandOptionsWhenFirstTimeSelect() {
                if (AzureProjectSettingComposite.this.selectedDefaultProject) {
                    if (!AzureProjectSettingComposite.this.hasOptionsEditted()) {
                        AzureProjectSettingComposite.this.expandOptionsForProjectSettings();
                    }
                    AzureProjectSettingComposite.this.selectedDefaultProject = false;
                }
            }
        });
        this.btnFetchProjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AzureCredential credential = AzureProjectSettingComposite.this.authenticationComposite.getEddingCredential();
                if (StringUtils.isEmpty((CharSequence)credential.getServerUrl()) || StringUtils.isEmpty((CharSequence)credential.getToken())) {
                    MessageDialog.openError((Shell)AzureProjectSettingComposite.this.getShell(), (String)StringConstants.AZURE_DEVOPS_NAME, (String)StringConstants.MSG_ERROR_AUTHENTICATION_CANNOT_NULL);
                    return;
                }
                Shell shell = AzureProjectSettingComposite.this.getShell();
                AzureFetchProjectsJob job = new AzureFetchProjectsJob(shell, credential);
                AzureConnectionResult result = job.run();
                if (result.getError() != null) {
                    LoggerSingleton.logError((Throwable)result.getError(), (String)StringConstants.MSG_ERROR_CONNECTION);
                    MessageDialog.openError((Shell)shell, (String)StringConstants.AZURE_DEVOPS_NAME, (String)result.getError().getMessage());
                } else {
                    AzureProjectRef[] projects = result.getAzureProjects();
                    if (projects == null || projects.length <= 0) {
                        MessageDialog.openWarning(null, (String)StringConstants.AZURE_DEVOPS_NAME, (String)StringConstants.MSG_NO_PROJECT);
                    } else {
                        AzureProjectSettingComposite.this.setIsSelectingDefaultProject();
                    }
                    AzureProjectSettingComposite.this.updateComboProjectsValue(credential, projects, true, false);
                }
            }
        });
        this.tvTestPlans.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AzureProjectSettingComposite.this.selectedTestPlans = (AzureTestPlanRef[])Arrays.stream(AzureProjectSettingComposite.this.tvTestPlans.getCheckedElements()).filter(AzureTestPlanRef.class::isInstance).map(AzureTestPlanRef.class::cast).toArray(AzureTestPlanRef[]::new);
                AzureProjectSettingComposite.this.selectedTestPlansDidChange();
            }
        });
        this.submissionOptionsComposite.addVerifyBuildDefinitionIDListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    AzureProjectSettingComposite.this.submissionOptionsComposite.verifyBuildDefinitionID(AzureProjectSettingComposite.this.authenticationComposite.getEddingCredential(), AzureProjectSettingComposite.this.selectedProject);
                }
                catch (AzureApiException exception) {
                    AzureProjectSettingComposite.this.submissionOptionsComposite.showInvalidBuildDefinitionIDMessage();
                    LoggerSingleton.logError((String)exception.toString());
                }
            }
        });
        this.submissionOptionsComposite.addVerifyReleaseDefinitionIDListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    AzureProjectSettingComposite.this.submissionOptionsComposite.verifyReleaseDefinitionID(AzureProjectSettingComposite.this.authenticationComposite.getEddingCredential(), AzureProjectSettingComposite.this.selectedProject);
                }
                catch (AzureApiException exception) {
                    AzureProjectSettingComposite.this.submissionOptionsComposite.showInvalidReleaseDefinitionIDMessage();
                    LoggerSingleton.logError((String)exception.toString());
                }
            }
        });
    }

    public void setIsSelectingDefaultProject() {
        this.selectedDefaultProject = true;
    }

    public void expandOptionsForProjectSettings() {
        this.testArtifactsMappingComposite.expand();
        this.submissionOptionsComposite.expand();
    }

    private boolean hasOptionsEditted() {
        if (this.selectedTestPlans != null && this.selectedTestPlans.length > 0) {
            return true;
        }
        if (this.testArtifactsMappingComposite.hasEditted()) {
            return true;
        }
        return this.submissionOptionsComposite.hasEditted();
    }

    public void setEnabled(boolean isEnabled) {
        if (this.projects == null || this.projects.length <= 0) {
            isEnabled = false;
        }
        if (!isEnabled) {
            if (this.testArtifactsMappingComposite.isExpanded()) {
                this.testArtifactsMappingComposite.collapse();
            }
            if (this.submissionOptionsComposite.isExpanded()) {
                this.submissionOptionsComposite.collapse();
            }
        }
        ControlUtils.recursiveSetEnabled((Control)this, (boolean)isEnabled);
        this.submissionOptionsComposite.enableAttachmentsComposite(isEnabled);
    }

    public void initializeData() {
        this.selectedProject = this.settingStore.getIntegratedProject();
        if (this.selectedProject == null || StringUtils.isEmpty((CharSequence)this.selectedProject.getId())) {
            return;
        }
        this.projects = this.settingStore.getFetchedAzureProjectList();
        this.setCcbProjectItems(this.projects);
        this.cbbProject.select(this.getProjectIndex(this.selectedProject, true));
        this.selectedTestPlans = this.settingStore.getAzureTestPlans();
        this.testPlans = this.settingStore.getFetchedAzureTestPlanList();
        this.updateTestPlansTableViewer(this.testPlans);
    }

    private int getProjectIndex(AzureProjectRef selectedProject, boolean isSilent) {
        if (this.projects == null) {
            return -1;
        }
        if (selectedProject == null) {
            this.expandOptionsForProjectSettings();
            return 0;
        }
        int i = 0;
        while (i < this.projects.length) {
            if (this.projects[i].getId().equals(selectedProject.getId())) {
                return i;
            }
            ++i;
        }
        if (!isSilent) {
            MessageDialog.openWarning(null, (String)StringConstants.AZURE_DEVOPS_NAME, (String)StringConstants.MSG_WARNING_INVALID_SELECTED_PROJECT);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateComboProjectsValue(AzureCredential credential, AzureProjectRef[] projects, boolean shouldDropProjectsDown, boolean isSilent) {
        if (projects == null || projects.length <= 0) {
            if (this.hasOptionsEditted()) {
                MessageDialog warningDialog = new MessageDialog(null, StringConstants.AZURE_DEVOPS_NAME, null, StringConstants.MSG_WARNING_CHANGE_PROJECT, 4, new String[]{StringConstants.BTN_PROCEED_ANYWAY, StringConstants.BTN_CANCEL}, 0);
                if (warningDialog.open() != 0) {
                    return;
                }
                this.resetProjectOptions(this.authenticationComposite.getEddingCredential(), null, true);
            }
            this.projects = projects;
            this.cbbProject.setItems(new String[0]);
            this.selectedProject = null;
            return;
        }
        AzureProjectRef[] oldProjects = this.projects;
        this.projects = projects;
        this.selectedDefaultProject = true;
        this.setCcbProjectItems(projects);
        int selectedIndex = this.getProjectIndex(this.selectedProject, isSilent);
        if (selectedIndex >= 0 && selectedIndex < this.projects.length) {
            AzureProjectRef newChosenProject = this.projects[selectedIndex];
            if (this.selectedProject != null && newChosenProject.getId().equals(this.selectedProject.getId())) {
                this.cbbProject.select(selectedIndex);
                this.refreshProjectOptions(this.authenticationComposite.getEddingCredential(), this.selectedProject.getId(), false);
                if (shouldDropProjectsDown) {
                    this.dropProjectComboBoxDown();
                }
                return;
            }
            if (this.hasOptionsEditted()) {
                MessageDialog warningDialog = new MessageDialog(null, StringConstants.AZURE_DEVOPS_NAME, null, StringConstants.MSG_WARNING_CHANGE_PROJECT, 4, new String[]{StringConstants.BTN_PROCEED_ANYWAY, StringConstants.BTN_CANCEL}, 0);
                if (warningDialog.open() != 0) {
                    this.projects = oldProjects;
                    this.setCcbProjectItems(oldProjects);
                    this.cbbProject.select(this.getProjectIndex(this.selectedProject, true));
                    return;
                }
                this.selectedProject = newChosenProject;
                this.cbbProject.select(selectedIndex);
                this.resetProjectOptions(this.authenticationComposite.getEddingCredential(), this.selectedProject.getId(), false);
            } else {
                this.selectedProject = newChosenProject;
                this.cbbProject.select(selectedIndex);
                this.resetProjectOptions(this.authenticationComposite.getEddingCredential(), this.selectedProject.getId(), false);
            }
            this.expandOptionsForProjectSettings();
        }
    }

    private void setCcbProjectItems(AzureProjectRef[] projects) {
        String[] projectNames = (String[])Arrays.asList(projects).stream().map(project -> project.getName()).toArray(String[]::new);
        this.cbbProject.setItems(projectNames);
    }

    private void refreshProjectOptions(AzureCredential credential, String projectId, boolean isSilent) {
        this.testArtifactsMappingComposite.updateTestConfigurationSuggestions(credential, projectId);
        AzureTestPlanRef[] newTestPlans = this.fetchTestPlans(credential, projectId);
        this.updateTestPlansTableViewer(newTestPlans);
    }

    public void refreshProjectOptions(AzureCredential credential, boolean isSilent) {
        String projectId = "";
        if (this.selectedProject != null && StringUtils.isNotEmpty((CharSequence)this.selectedProject.getId())) {
            projectId = this.selectedProject.getId();
        }
        this.refreshProjectOptions(credential, projectId, isSilent);
    }

    private void resetProjectOptions(AzureCredential credential, String projectId, boolean isSilent) {
        this.testArtifactsMappingComposite.reset(credential, projectId);
        this.submissionOptionsComposite.reset(credential, projectId, isSilent);
        AzureTestPlanRef[] newTestPlans = this.fetchTestPlans(credential, projectId);
        this.updateTestPlansTableViewer(newTestPlans);
    }

    public boolean checkValidationBeforeSaving() {
        if (this.cbbProject.getSelectionIndex() == -1) {
            MessageDialog.openError((Shell)this.getShell(), (String)StringConstants.AZURE_DEVOPS_NAME, (String)(StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS + StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS_PROJECT_IS_NULL));
            return false;
        }
        AzureCredential credential = this.authenticationComposite.getEddingCredential();
        try {
            AzureProjectsRef fetchedProjects = AzureIntegrationRequest.getProjects((AzureCredential)credential);
            boolean isValidProject = false;
            if (fetchedProjects != null && fetchedProjects.getCount() > 0) {
                AzureProjectRef[] azureProjectRefArray = fetchedProjects.getValue();
                int n = azureProjectRefArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AzureProjectRef project = azureProjectRefArray[n2];
                    if (project.getId().equals(this.selectedProject.getId())) {
                        isValidProject = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!isValidProject) {
                MessageDialog.openError((Shell)this.getShell(), (String)StringConstants.AZURE_DEVOPS_NAME, (String)(StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS + StringConstants.MSG_ERROR_INVALID_SELECTED_PROJECT));
                return false;
            }
        }
        catch (AzureApiException e) {
            LoggerSingleton.logError((Throwable)e.fillInStackTrace());
            return false;
        }
        if (!this.validateTestPlansBeforeSaving(credential, this.selectedProject.getId(), this.selectedTestPlans)) {
            return false;
        }
        if (!this.testArtifactsMappingComposite.checkValidationBeforeSaving()) {
            return false;
        }
        return this.submissionOptionsComposite.checkValidationBeforeSaving(credential, this.selectedProject);
    }

    public AzureProjectRef[] getProjects() {
        return this.projects;
    }

    public void saveToSettingStore() throws IOException {
        this.selectedProject = this.cbbProject.getSelectionIndex() == -1 ? null : this.projects[this.cbbProject.getSelectionIndex()];
        this.settingStore.setAzureProjectRef(this.selectedProject);
        this.settingStore.setFetchedAzureProjectList(this.projects);
        this.settingStore.setAzureTestPlanRefs(this.selectedTestPlans);
        this.settingStore.setFetchedAzureTestPlanList(this.testPlans);
        this.testArtifactsMappingComposite.saveToSettingStore();
        this.submissionOptionsComposite.saveToSettingStore();
    }

    public void dropProjectComboBoxDown() {
        if (OSUtil.isWindows()) {
            this.cbbProject.setListVisible(true);
        }
    }

    public void restoreToDefault() {
        this.initializeData();
        this.testArtifactsMappingComposite.initializeData();
        this.submissionOptionsComposite.initializeData();
    }

    private AzureTestPlanRef[] fetchTestPlans(AzureCredential credential, String projectId) {
        if (projectId == null) {
            return null;
        }
        Shell shell = this.getShell();
        AzureVerifyTestPlanJob job = new AzureVerifyTestPlanJob(shell, credential, projectId);
        AzureVerifyTestPlanResult result = job.run();
        if (result.getError() != null) {
            LoggerSingleton.logError((Throwable)result.getError(), (String)StringConstants.MSG_ERROR_FETCH_TEST_PLANS);
            MessageDialog.openError((Shell)shell, (String)StringConstants.AZURE_DEVOPS_NAME, (String)result.getError().getMessage());
            return null;
        }
        AzureTestPlansRef testPlans = result.getTestPlans();
        if (testPlans == null) {
            return null;
        }
        return testPlans.getValue();
    }

    private void updateTestPlansTableViewer(AzureTestPlanRef[] newTestPlans) {
        this.testPlans = newTestPlans != null ? newTestPlans : new AzureTestPlanRef[]{};
        this.tvTestPlans.setInput((Object)this.testPlans);
        this.tvTestPlans.refresh();
        boolean hasTestPlans = this.testPlans.length > 0;
        this.testPlansStackLayout.topControl = hasTestPlans ? this.tvTestPlans.getTable() : this.lblNoTestPlans;
        this.testPlansComposite.layout();
        Set validTestPlanIds = Arrays.asList(this.testPlans).stream().map(p -> p.getId()).collect(Collectors.toSet());
        this.selectedTestPlans = (AzureTestPlanRef[])Arrays.asList(this.selectedTestPlans != null ? this.selectedTestPlans : new AzureTestPlanRef[]{}).stream().filter(plan -> validTestPlanIds.contains(plan.getId())).toArray(AzureTestPlanRef[]::new);
        this.tvTestPlans.setCheckedElements((Object[])this.selectedTestPlans);
        this.selectedTestPlansDidChange();
    }

    private void selectedTestPlansDidChange() {
        boolean shouldEnableSubComposites = this.selectedTestPlans.length > 0;
        this.testArtifactsMappingComposite.setEnabled(shouldEnableSubComposites);
        this.submissionOptionsComposite.setEnabled(shouldEnableSubComposites);
    }

    private boolean validateTestPlansBeforeSaving(AzureCredential credential, String projectId, AzureTestPlanRef[] selectedTestPlans) {
        AzureTestPlansRef allTestPlans;
        if (ArrayUtils.isEmpty((Object[])selectedTestPlans)) {
            MessageDialog.openError(null, (String)StringConstants.AZURE_DEVOPS_NAME, (String)(StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS + StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS_TEST_PLAN_IS_NULL));
            return false;
        }
        try {
            allTestPlans = AzureIntegrationRequest.getAllTestPlans((AzureCredential)credential, (String)projectId);
        }
        catch (AzureApiException e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        Set validTestPlanIds = allTestPlans == null ? Collections.emptySet() : Arrays.asList(allTestPlans.getValue()).stream().map(p -> p.getId()).collect(Collectors.toSet());
        boolean containsAtLeastOneInvalidTestPlan = Arrays.asList(selectedTestPlans).stream().anyMatch(selectedPlan -> !validTestPlanIds.contains(selectedPlan.getId()));
        if (containsAtLeastOneInvalidTestPlan) {
            MessageDialog.openError(null, (String)StringConstants.AZURE_DEVOPS_NAME, (String)(StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS + StringConstants.MSG_ERROR_INVALID_SELECTED_TEST_PLAN));
            return false;
        }
        return true;
    }
}

