/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.core.configuration.RunConfiguration;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public final class CucumberProperties {
    private static final Logger log = LoggerFactory.getLogger(CucumberProperties.class);

    private CucumberProperties() {
    }

    public static Map<String, String> create() {
        CucumberPropertiesMap fromBundle = new CucumberPropertiesMap(CucumberProperties.fromPropertiesFile());
        CucumberPropertiesMap fromEnvironmentProperties = new CucumberPropertiesMap(fromBundle, CucumberProperties.fromEnvironment());
        return new CucumberPropertiesMap(fromEnvironmentProperties, CucumberProperties.fromSystemProperties());
    }

    public static Map<String, String> fromPropertiesFile() {
        String cucumberPropFilePath = Paths.get(RunConfiguration.getProjectDir(), GlobalMessageConstants.ROOT_FOLDER_NAME_INCLUDE, GlobalMessageConstants.ROOT_FOLDER_NAME_CONFIG, "cucumber.properties").toString();
        File cucumberPropertiesFile = new File(cucumberPropFilePath);
        FileInputStream resourceAsStream = null;
        if (cucumberPropertiesFile.exists()) {
            try {
                resourceAsStream = new FileInputStream(cucumberPropertiesFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.debug(() -> "cucumber.properties file did not exist");
                return Collections.emptyMap();
            }
        }
        if (resourceAsStream == null) {
            log.debug(() -> "cucumber.properties file did not exist");
            return Collections.emptyMap();
        }
        try {
            Properties properties = new Properties();
            properties.load(resourceAsStream);
            return CucumberPropertiesMap.create(properties);
        }
        catch (IOException e) {
            log.error((Throwable)e, () -> "cucumber.properties could not be loaded");
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> fromEnvironment() {
        Map<String, String> p = System.getenv();
        return new CucumberPropertiesMap(p);
    }

    public static Map<String, String> fromSystemProperties() {
        Properties p = System.getProperties();
        return CucumberPropertiesMap.create(p);
    }

    static class CucumberPropertiesMap
    extends AbstractMap<String, String> {
        private final CucumberPropertiesMap parent;
        private final Map<String, String> delegate;

        CucumberPropertiesMap(CucumberPropertiesMap parent, Map<String, String> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
            this.parent = parent;
        }

        CucumberPropertiesMap(Map<String, String> delegate) {
            this(null, delegate);
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.delegate.entrySet();
        }

        private static CucumberPropertiesMap create(Properties p) {
            HashMap<String, String> copy = new HashMap<String, String>();
            p.stringPropertyNames().forEach((? super T s) -> {
                String string = copy.put((String)s, p.getProperty((String)s));
            });
            return new CucumberPropertiesMap(copy);
        }

        @Override
        public String get(Object key) {
            String exactMatch = (String)super.get(key);
            if (exactMatch != null) {
                return exactMatch;
            }
            if (!(key instanceof String)) {
                return null;
            }
            String keyString = (String)key;
            String uppercase = keyString.replace(".", "_").replace("-", "_").toUpperCase(Locale.ENGLISH);
            String upperCaseMatch = (String)super.get(uppercase);
            if (upperCaseMatch != null) {
                return upperCaseMatch;
            }
            String lowercase = keyString.replace(".", "_").replace("-", "_").toLowerCase(Locale.ENGLISH);
            String lowerValue = (String)super.get(lowercase);
            if (lowerValue != null) {
                return lowerValue;
            }
            if (this.parent == null) {
                return null;
            }
            return this.parent.get(key);
        }
    }
}

