/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.fill.JRFillCellContents;
import net.sf.jasperreports.engine.fill.JRFillFrame;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.ObjectUtils;

public class JRTemplateFrame
extends JRTemplateElement
implements JRBoxContainer {
    private static final long serialVersionUID = 10200L;
    protected JRLineBox lineBox;

    public JRTemplateFrame(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider, JRFillCellContents cell) {
        super(origin, defaultStyleProvider);
        this.parentStyle = cell.getStyle();
        this.setBackcolor(cell.getBackcolor());
        this.setMode(cell.getModeValue());
        this.copyBox(cell.getLineBox());
    }

    public JRTemplateFrame(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider, JRFillFrame frame) {
        super(origin, defaultStyleProvider);
        this.setElement(frame);
        this.copyBox(frame.getLineBox());
    }

    public JRTemplateFrame(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider) {
        super(origin, defaultStyleProvider);
        this.lineBox = new JRBaseLineBox(this);
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public void copyBox(JRLineBox lineBox) {
        this.lineBox = lineBox.clone(this);
    }

    @Override
    public ModeEnum getModeValue() {
        return this.getStyleResolver().getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public int getHashCode() {
        ObjectUtils.HashCode hash = ObjectUtils.hash();
        this.addTemplateHash(hash);
        hash.addIdentical(this.lineBox);
        return hash.getHashCode();
    }

    @Override
    public boolean isIdentical(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JRTemplateFrame)) {
            return false;
        }
        JRTemplateFrame template = (JRTemplateFrame)object;
        return this.templateIdentical(template) && ObjectUtils.identical(this.lineBox, template.lineBox);
    }

    @Override
    public void populateStyle() {
        super.populateStyle();
        if (this.lineBox != null) {
            this.lineBox.populateStyle();
        }
    }
}

