/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import net.sf.jasperreports.engine.fill.VirtualizerStore;

public class StoreVirtualizer
extends JRAbstractLRUVirtualizer {
    private final VirtualizerStore store;

    public StoreVirtualizer(int maxSize, VirtualizerStore store) {
        super(maxSize);
        this.store = store;
    }

    @Override
    protected void pageOut(JRVirtualizable o) throws IOException {
        boolean stored = this.store.store(o, this.serializer);
        if (!stored && !this.isReadOnly(o)) {
            throw new IllegalStateException("Cannot virtualize data because the data for object UID \"" + o.getUID() + "\" already exists.");
        }
    }

    @Override
    protected void pageIn(JRVirtualizable o) throws IOException {
        this.store.retrieve(o, !this.isReadOnly(o), this.serializer);
    }

    @Override
    protected void dispose(String id) {
        this.store.remove(id);
    }

    @Override
    public void cleanup() {
        this.store.dispose();
    }
}

