/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.handler;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.handler.AbstractQTestHandler;
import com.kms.katalon.composer.integration.qtest.job.DisintegrateTestCaseJob;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.QTestSyncStatusUtil;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;

public class QTestDisintegrateTestCaseHandler
extends AbstractQTestHandler {
    @Inject
    private ESelectionService selectionService;

    @CanExecute
    public boolean canExecute() {
        Object selectedEntity;
        ProjectEntity projectEntity;
        block5: {
            projectEntity = ProjectController.getInstance().getCurrentProject();
            selectedEntity = this.getFirstSelectedObject(this.selectionService);
            if (selectedEntity != null) break block5;
            return false;
        }
        try {
            FolderEntity folder;
            if (selectedEntity instanceof TestCaseEntity) {
                return QTestIntegrationUtil.canBeDownloadedOrDisintegrated((IntegratedFileEntity)((IntegratedFileEntity)selectedEntity), (ProjectEntity)projectEntity);
            }
            if (selectedEntity instanceof FolderEntity && (folder = (FolderEntity)selectedEntity).getFolderType() == FolderEntity.FolderType.TESTCASE) {
                return QTestIntegrationUtil.canBeDownloadedOrDisintegrated((IntegratedFileEntity)folder, (ProjectEntity)projectEntity);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return false;
    }

    private List<IntegratedFileEntity> getIntegratedChildren(IntegratedFileEntity entity) {
        ArrayList<IntegratedFileEntity> integratedEntities = new ArrayList<IntegratedFileEntity>();
        integratedEntities.add(entity);
        return integratedEntities;
    }

    private void disintegrateTestCases(List<IntegratedFileEntity> integratedTestCases) {
        DisintegrateTestCaseJob job = new DisintegrateTestCaseJob(true);
        job.setFileEntities(integratedTestCases);
        job.doTask();
    }

    @Execute
    public void execute() {
        try {
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            ITreeEntity treeEntity = (ITreeEntity)selectedObjects[0];
            Object selectedObject = treeEntity.getObject();
            if (selectedObject instanceof TestCaseEntity) {
                if (MessageDialog.openConfirm(null, (String)StringConstants.CONFIRMATION, (String)StringConstants.DIA_CONFIRM_DISINTEGRATE_TEST_CASE)) {
                    TestCaseEntity testCase = (TestCaseEntity)selectedObject;
                    QTestSyncStatusUtil.recursivelyUnmarkAllStatuses((IntegratedFileEntity)testCase, (ProjectEntity)testCase.getProject());
                    this.disintegrateTestCases(this.getIntegratedChildren((IntegratedFileEntity)testCase));
                }
            } else if (selectedObject instanceof FolderEntity && MessageDialog.openConfirm(null, (String)StringConstants.CONFIRMATION, (String)StringConstants.DIA_CONFIRM_DISINTEGRATE_TEST_CASE_FOLDER)) {
                FolderEntity folder = (FolderEntity)selectedObject;
                switch (folder.getFolderType()) {
                    case TESTCASE: {
                        this.disintegrateTestCases(this.getIntegratedChildren((IntegratedFileEntity)folder));
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

