/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.handler;

import com.katalon.platform.api.Plugin;
import com.katalon.platform.api.service.ApplicationManager;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class QTestIntegrationToolbarHandler
implements EventHandler {
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    MApplication application;

    @PostConstruct
    public void registerEventListener() {
        this.eventBroker.subscribe("WORKSPACE/PLUGIN_LOADED", (EventHandler)this);
        this.eventBroker.subscribe("PROJECT/CLOSED", (EventHandler)this);
    }

    public void handleEvent(Event event) {
        MToolBar composerToolbar = (MToolBar)this.modelService.find("com.kms.katalon.composer.toolbar", (MUIElement)this.application);
        MHandledToolItem qTestToolItem = (MHandledToolItem)this.modelService.find("com.kms.katalon.composer.integration.qtest.handledtoolitem", (MUIElement)composerToolbar);
        if (qTestToolItem != null) {
            boolean shouldShowToolItem = true;
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            if (project == null || !this.isQTestPluginInstalled()) {
                shouldShowToolItem = false;
            }
            qTestToolItem.setVisible(shouldShowToolItem);
            qTestToolItem.setToBeRendered(shouldShowToolItem);
        }
    }

    private boolean isQTestPluginInstalled() {
        Plugin plugin = ApplicationManager.getInstance().getPluginManager().getPlugin("com.katalon.katalon-studio-qtest");
        return plugin != null;
    }
}

