/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.preference;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.dialog.TestCaseRepoDialog;
import com.kms.katalon.composer.integration.qtest.job.DisintegrateTestCaseJob;
import com.kms.katalon.composer.integration.qtest.preference.AbstractQTestIntegrationPage;
import com.kms.katalon.composer.integration.qtest.preference.provider.TestCaseRepoTableLabelProvider;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationFolderManager;
import com.kms.katalon.integration.qtest.QTestIntegrationProjectManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.entity.QTestModule;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.model.TestCaseRepo;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class TestCaseRepoPreferencePage
extends AbstractQTestIntegrationPage {
    @Inject
    private UISynchronize sync;
    private Composite container;
    private Table table;
    private ToolItem btnAdd;
    private ToolItem btnEdit;
    private ToolItem btnRemove;
    private TableViewer tableViewer;
    private List<QTestProject> qTestProjects;
    private List<TestCaseRepo> testCaseRepositories;

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        Composite compositeToolbar = new Composite(this.container, 0);
        compositeToolbar.setLayout((Layout)new FillLayout(256));
        compositeToolbar.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ToolBar toolbar = new ToolBar(compositeToolbar, 0x820000);
        toolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.btnAdd = new ToolItem(toolbar, 0);
        this.btnAdd.setText(StringConstants.ADD);
        this.btnAdd.setImage(ImageConstants.IMG_16_ADD);
        this.btnEdit = new ToolItem(toolbar, 0);
        this.btnEdit.setText(StringConstants.EDIT);
        this.btnEdit.setEnabled(false);
        this.btnEdit.setImage(ImageConstants.IMG_16_EDIT);
        this.btnRemove = new ToolItem(toolbar, 0);
        this.btnRemove.setText(StringConstants.REMOVE);
        this.btnRemove.setImage(ImageConstants.IMG_16_REMOVE);
        this.btnRemove.setEnabled(false);
        Composite compositeTable = new Composite(this.container, 0);
        compositeTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer = new TableViewer(compositeTable, 67584);
        this.table = this.tableViewer.getTable();
        this.table.setLinesVisible(ControlUtils.shouldLineVisble((Display)this.table.getDisplay()));
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewerColumn tableViewerColumnQTestProject = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnQTestProject = tableViewerColumnQTestProject.getColumn();
        tblclmnQTestProject.setText(StringConstants.DIA_TITLE_QTEST_PROJECT);
        TableViewerColumn tableViewerColumnQTestModule = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnQTestModule = tableViewerColumnQTestModule.getColumn();
        tblclmnQTestModule.setText(StringConstants.DIA_TITLE_QTEST_MODULE);
        TableViewerColumn tableViewerColumnKatalonFolder = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnKatalonFolder = tableViewerColumnKatalonFolder.getColumn();
        tblclmnKatalonFolder.setText(StringConstants.DIA_TITLE_TEST_CASE_FOLDER);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TestCaseRepoTableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)tblclmnQTestProject, (ColumnLayoutData)new ColumnWeightData(0, 100));
        tableLayout.setColumnData((Widget)tblclmnQTestModule, (ColumnLayoutData)new ColumnWeightData(40, 100));
        tableLayout.setColumnData((Widget)tblclmnKatalonFolder, (ColumnLayoutData)new ColumnWeightData(40, 100));
        compositeTable.setLayout((Layout)tableLayout);
        this.addControlModifySelectionListeners();
        this.initialize();
        return this.container;
    }

    @Override
    protected void initialize() {
        if (this.container == null || this.container.isDisposed()) {
            return;
        }
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        IntegratedEntity integratedProjectEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)projectEntity);
        try {
            this.qTestProjects = integratedProjectEntity != null ? QTestIntegrationProjectManager.getQTestProjectsByIntegratedEntity((IntegratedEntity)integratedProjectEntity) : new ArrayList<QTestProject>();
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
            MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)StringConstants.DIA_MSG_UNABLE_GET_PROJECT_INFO, (String)ex.getMessage());
        }
        this.testCaseRepositories = QTestIntegrationUtil.getTestCaseRepositories((ProjectEntity)projectEntity, this.qTestProjects);
        this.tableViewer.setInput(this.testCaseRepositories);
    }

    private void addControlModifySelectionListeners() {
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseRepoPreferencePage.this.addNewTestCaseRepo();
            }
        });
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseRepoPreferencePage.this.editTestCaseRepo();
            }
        });
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCaseRepoPreferencePage.this.removeTestCaseRepo();
            }
        });
        this.tableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TestCaseRepoPreferencePage.this.tableViewer.getSelection();
                if (selection == null || selection.isEmpty()) {
                    TestCaseRepoPreferencePage.this.btnEdit.setEnabled(false);
                    TestCaseRepoPreferencePage.this.btnRemove.setEnabled(false);
                } else {
                    TestCaseRepoPreferencePage.this.btnEdit.setEnabled(true);
                    TestCaseRepoPreferencePage.this.btnRemove.setEnabled(true);
                }
            }
        });
    }

    private void addNewTestCaseRepo() {
        List<String> currentFolderIds = this.getRegisteredFolderIds();
        TestCaseRepoDialog dialog = new TestCaseRepoDialog(this.btnAdd.getDisplay().getActiveShell(), this.qTestProjects, currentFolderIds, null);
        if (dialog.open() == 0) {
            TestCaseRepo repo = dialog.getTestCaseRepo();
            this.testCaseRepositories.add(repo);
            this.qTestProjects.clear();
            for (QTestProject qTestProject : dialog.getQTestProjectsMap().values()) {
                if (qTestProject.equals((Object)repo.getQTestProject())) {
                    qTestProject.getTestCaseFolderIds().add(repo.getFolderId());
                }
                this.qTestProjects.add(qTestProject);
            }
            this.tableViewer.refresh();
        }
    }

    private List<String> getRegisteredFolderIds() {
        ArrayList<String> currentFolderIds = new ArrayList<String>();
        for (TestCaseRepo testCaseRepo : this.testCaseRepositories) {
            currentFolderIds.add(testCaseRepo.getFolderId());
        }
        return currentFolderIds;
    }

    private void editTestCaseRepo() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        TestCaseRepo repo = (TestCaseRepo)selection.getFirstElement();
        List<String> currentFolderIds = this.getRegisteredFolderIds();
        currentFolderIds.remove(repo.getFolderId());
        TestCaseRepoDialog dialog = new TestCaseRepoDialog(this.btnAdd.getDisplay().getActiveShell(), this.qTestProjects, currentFolderIds, repo);
        if (dialog.open() == 0) {
            TestCaseRepo newRepo = dialog.getTestCaseRepo();
            if (repo.equals((Object)newRepo)) {
                return;
            }
            int index = this.testCaseRepositories.indexOf(repo);
            String folderId = repo.getFolderId();
            ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
            try {
                FolderEntity folderEntity = FolderController.getInstance().getFolderByDisplayId(projectEntity, folderId);
                if (folderEntity == null) {
                    this.insertNewRepoToTable(index, newRepo);
                    return;
                }
                IntegratedEntity folderIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)folderEntity);
                if (folderIntegratedEntity == null) {
                    this.insertNewRepoToTable(index, newRepo);
                }
                if (this.confirmRemoveRepo()) {
                    this.performInsertTestCaseRepo(folderEntity, newRepo, index);
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.DIA_MSG_UNABLE_MOFIDY_TEST_CASE_REPO, (String)e.getClass().getSimpleName());
            }
        }
    }

    private void removeRepoFromTable(TestCaseRepo repo) {
        if (this.testCaseRepositories.contains(repo)) {
            this.testCaseRepositories.remove(repo);
        }
        this.tableViewer.refresh();
    }

    private void insertNewRepoToTable(int index, TestCaseRepo newRepo) {
        this.testCaseRepositories.remove(index);
        if (index >= this.testCaseRepositories.size()) {
            this.testCaseRepositories.add(newRepo);
        } else {
            this.testCaseRepositories.add(index, newRepo);
        }
        this.tableViewer.refresh();
    }

    private boolean confirmRemoveRepo() {
        return MessageDialog.openConfirm(null, (String)StringConstants.CONFIRMATION, (String)StringConstants.DIA_CONFIRM_DISINTEGRATE_TEST_CASE_FOLDER);
    }

    private void removeTestCaseRepo() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        TestCaseRepo repo = (TestCaseRepo)selection.getFirstElement();
        String folderId = repo.getFolderId();
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        try {
            FolderEntity folderEntity = FolderController.getInstance().getFolderByDisplayId(projectEntity, folderId);
            if (folderEntity == null) {
                this.removeRepoFromTable(repo);
                return;
            }
            IntegratedEntity folderIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)folderEntity);
            if (folderIntegratedEntity == null) {
                this.removeRepoFromTable(repo);
            }
            if (this.confirmRemoveRepo()) {
                this.performRemoveTestCaseRepo(folderEntity, repo);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.DIA_MSG_UNABLE_REMOVE_TEST_CASE_REPO, (String)e.getClass().getSimpleName());
        }
    }

    private void performRemoveTestCaseRepo(FolderEntity folderEntity, final TestCaseRepo repo) {
        DisintegrateTestCaseJob job = new DisintegrateTestCaseJob(true);
        job.setFileEntities(Arrays.asList(folderEntity));
        job.doTask();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                TestCaseRepoPreferencePage.this.sync.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        TestCaseRepoPreferencePage.this.removeRepoFromTable(repo);
                    }
                });
            }
        });
    }

    private void performInsertTestCaseRepo(FolderEntity folderEntity, final TestCaseRepo newRepo, final int index) {
        DisintegrateTestCaseJob job = new DisintegrateTestCaseJob(true);
        job.setFileEntities(Arrays.asList(folderEntity));
        job.doTask();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                TestCaseRepoPreferencePage.this.sync.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        TestCaseRepoPreferencePage.this.insertNewRepoToTable(index, newRepo);
                    }
                });
            }
        });
    }

    public boolean performOk() {
        if (this.container == null) {
            return true;
        }
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        LinkedHashSet<QTestProject> currentProjects = new LinkedHashSet<QTestProject>();
        IntegratedEntity projectIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)projectEntity);
        if (projectIntegratedEntity != null) {
            currentProjects.addAll(QTestIntegrationProjectManager.getQTestProjectsByIntegratedEntity((IntegratedEntity)projectIntegratedEntity));
        }
        currentProjects.addAll(this.qTestProjects);
        for (QTestProject qTestProject : currentProjects) {
            qTestProject.getTestCaseFolderIds().clear();
        }
        for (TestCaseRepo repo : this.testCaseRepositories) {
            for (QTestProject qTestProject : currentProjects) {
                if (!repo.getQTestProject().equals((Object)qTestProject)) continue;
                qTestProject.getTestCaseFolderIds().add(repo.getFolderId());
                break;
            }
            try {
                FolderEntity folderEntity = FolderController.getInstance().getFolderByDisplayId(projectEntity, repo.getFolderId());
                if (folderEntity == null) continue;
                this.saveFolder(folderEntity, repo.getQTestModule());
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        this.qTestProjects.clear();
        this.qTestProjects.addAll(currentProjects);
        this.saveProject(projectEntity);
        return true;
    }

    private void saveFolder(FolderEntity folderEntity, QTestModule qTestModule) {
        IntegratedEntity folderNewIntegratedEntity = QTestIntegrationFolderManager.getFolderIntegratedEntityByQTestModule((QTestModule)qTestModule);
        folderEntity = (FolderEntity)QTestIntegrationUtil.updateFileIntegratedEntity((IntegratedFileEntity)folderEntity, (IntegratedEntity)folderNewIntegratedEntity);
        try {
            FolderController.getInstance().saveFolder(folderEntity);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void saveProject(ProjectEntity projectEntity) {
        IntegratedEntity projectNewIntegratedEntity = QTestIntegrationProjectManager.getIntegratedEntityByQTestProjects(this.qTestProjects);
        ProjectEntity currentProject = (ProjectEntity)QTestIntegrationUtil.updateFileIntegratedEntity((IntegratedFileEntity)projectEntity, (IntegratedEntity)projectNewIntegratedEntity);
        try {
            ProjectController.getInstance().updateProject(currentProject);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void performDefaults() {
        this.initialize();
    }
}

