/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.view.report;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.handler.QTestDisintegrateReportHandler;
import com.kms.katalon.composer.integration.qtest.handler.QTestUploadReportHandler;
import com.kms.katalon.composer.report.parts.integration.TestCaseLogDetailsIntegrationView;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationReportManager;
import com.kms.katalon.integration.qtest.QTestIntegrationTestSuiteManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.entity.QTestLog;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.entity.QTestReport;
import com.kms.katalon.integration.qtest.entity.QTestRun;
import com.kms.katalon.integration.qtest.entity.QTestSuite;
import com.kms.katalon.integration.qtest.entity.QTestTestCase;
import com.kms.katalon.integration.qtest.model.ReportTestCaseLogPair;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class QTestIntegrationReportTestCaseView
extends TestCaseLogDetailsIntegrationView {
    private StyledText txtTestLogId;
    private StyledText txtTestCaseRunAlias;
    private StyledText txtAttachment;
    private TestSuiteLogRecord testSuiteLogRecord;
    private QTestTestCase qTestCase;
    private QTestSuite qTestSuite;
    private QTestRun qTestRun;
    private TestCaseLogRecord testCaseLogRecord;
    private QTestLog qTestCaseLog;

    public QTestIntegrationReportTestCaseView(ReportEntity reportEntity, TestSuiteLogRecord testSuiteLogRecord) {
        super(reportEntity, testSuiteLogRecord);
        this.testSuiteLogRecord = testSuiteLogRecord;
    }

    public Composite createContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout(1, false);
        glContainer.marginWidth = 0;
        glContainer.marginHeight = 0;
        container.setLayout((Layout)glContainer);
        Composite compositeInfo = new Composite(container, 0);
        GridLayout glCompositeInfo = new GridLayout(2, false);
        glCompositeInfo.verticalSpacing = 10;
        glCompositeInfo.horizontalSpacing = 25;
        compositeInfo.setLayout((Layout)glCompositeInfo);
        compositeInfo.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblTestRunAlias = new Label(compositeInfo, 0);
        lblTestRunAlias.setText(StringConstants.VIEW_TITLE_TEST_RUN_ALIAS);
        this.txtTestCaseRunAlias = new StyledText(compositeInfo, 8);
        this.txtTestCaseRunAlias.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblTestLogId = new Label(compositeInfo, 0);
        lblTestLogId.setText(StringConstants.VIEW_TITLE_TEST_LOG_ID);
        this.txtTestLogId = new StyledText(compositeInfo, 8);
        this.txtTestLogId.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblAttachment = new Label(compositeInfo, 0);
        lblAttachment.setText(StringConstants.ATTACHMENT);
        this.txtAttachment = new StyledText(compositeInfo, 0);
        this.txtAttachment.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.intialize();
        return container;
    }

    private void intialize() {
        try {
            this.qTestSuite = QTestIntegrationUtil.getSelectedQTestSuite((TestSuiteLogRecord)this.testSuiteLogRecord);
            this.reloadView();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void reloadView() {
        try {
            this.txtTestLogId.setText("");
            this.txtAttachment.setText("");
            this.txtTestCaseRunAlias.setText("");
            this.clearMouseDownListener(this.txtTestLogId);
            if (this.qTestCase == null || this.qTestSuite == null) {
                return;
            }
            this.qTestRun = QTestIntegrationTestSuiteManager.getTestRunByTestSuiteAndTestCaseId((QTestSuite)this.qTestSuite, (long)this.qTestCase.getId());
            if (this.qTestRun == null) {
                return;
            }
            QTestReport qTestReport = QTestIntegrationReportManager.getQTestReportByIntegratedEntity((IntegratedEntity)QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)this.reportEntity));
            if (qTestReport != null && this.testCaseLogRecord != null) {
                this.qTestCaseLog = (QTestLog)qTestReport.getTestLogMap().get(QTestIntegrationUtil.getTestCaseLogIndexByIndexInReport((TestCaseLogRecord)this.testCaseLogRecord, (ReportEntity)this.reportEntity));
                if (this.qTestCaseLog != null) {
                    this.txtTestLogId.setText(Long.toString(this.qTestCaseLog.getId()));
                    this.registerTxtQTestIdClickListener();
                    this.txtTestCaseRunAlias.setText(this.qTestRun.getPid());
                    String attachmentString = this.qTestCaseLog.isAttachmentIncluded() ? StringConstants.CM_YES : StringConstants.CM_NO;
                    this.txtAttachment.setText(attachmentString);
                    return;
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void clearMouseDownListener(StyledText styleText) {
        while (styleText.getListeners(3).length > 1) {
            styleText.removeListener(3, styleText.getListeners(3)[styleText.getListeners(3).length - 1]);
        }
    }

    private void registerTxtQTestIdClickListener() {
        StyleRange range = new StyleRange();
        range.start = 0;
        range.length = this.txtTestLogId.getText().length();
        range.underline = true;
        range.data = this.txtTestLogId.getText();
        range.foreground = ColorUtil.getHyperlinkTextColor();
        range.underlineStyle = 4;
        this.txtTestLogId.setStyleRanges(new StyleRange[]{range});
        this.txtTestLogId.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                try {
                    int offset = QTestIntegrationReportTestCaseView.this.txtTestLogId.getOffsetAtLocation(new Point(event.x, event.y));
                    StyleRange style = QTestIntegrationReportTestCaseView.this.txtTestLogId.getStyleRangeAtOffset(offset);
                    if (style != null && style.underline && style.underlineStyle == 4) {
                        QTestIntegrationReportTestCaseView.this.navigateToTestCaseLog();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        });
    }

    private void navigateToTestCaseLog() {
        try {
            ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
            String projectDir = projectEntity.getFolderLocation();
            QTestProject qTestProject = QTestIntegrationUtil.getTestSuiteRepo((IntegratedFileEntity)QTestIntegrationUtil.getTestSuiteEntity((TestSuiteLogRecord)this.testSuiteLogRecord), (ProjectEntity)projectEntity).getQTestProject();
            URL url = QTestIntegrationReportManager.getTestLogURL((String)projectDir, (QTestProject)qTestProject, (QTestRun)this.qTestRun, (QTestLog)this.qTestCaseLog);
            Program.launch((String)url.toString());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void changeTestCase(TestCaseLogRecord testCaseLogRecord) {
        if (testCaseLogRecord == null) {
            return;
        }
        this.testCaseLogRecord = testCaseLogRecord;
        this.qTestCase = QTestIntegrationUtil.getQTestCase((TestCaseLogRecord)testCaseLogRecord);
        this.reloadView();
    }

    public void createTableContextMenu(Menu parentMenu, ISelection selection) {
        if (selection == null) {
            return;
        }
        ArrayList<TestCaseLogRecord> testCaseCanBeUploaded = new ArrayList<TestCaseLogRecord>();
        ArrayList<TestCaseLogRecord> testCaseCanBeDisintegrated = new ArrayList<TestCaseLogRecord>();
        QTestSuite qTestSuite = QTestIntegrationUtil.getSelectedQTestSuite((TestSuiteLogRecord)this.testSuiteLogRecord);
        if (qTestSuite == null) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object[] objectArray = structuredSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedTestCaseLogObject = objectArray[n2];
            TestCaseLogRecord testCaseLogRecord = (TestCaseLogRecord)selectedTestCaseLogObject;
            switch (QTestIntegrationUtil.evaluateTestCaseLog((TestCaseLogRecord)testCaseLogRecord, (QTestSuite)qTestSuite, (ReportEntity)this.reportEntity)) {
                case CAN_INTEGRATE: {
                    testCaseCanBeUploaded.add(testCaseLogRecord);
                    break;
                }
                case INTEGRATED: {
                    testCaseCanBeDisintegrated.add(testCaseLogRecord);
                    break;
                }
            }
            ++n2;
        }
        if (testCaseCanBeUploaded.isEmpty() && testCaseCanBeDisintegrated.isEmpty()) {
            return;
        }
        MenuItem qTestMenuItem = new MenuItem(parentMenu, 64);
        qTestMenuItem.setText("qTest");
        Menu qTestMenu = new Menu(parentMenu);
        qTestMenuItem.setMenu(qTestMenu);
        if (testCaseCanBeUploaded.size() > 0) {
            MenuItem uploadMenuItem = new MenuItem(qTestMenu, 0);
            uploadMenuItem.setText(StringConstants.CM_UPLOAD);
            uploadMenuItem.setData(testCaseCanBeUploaded);
            uploadMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem = (MenuItem)e.getSource();
                    QTestIntegrationReportTestCaseView.this.performUploadTestCaseLogs(menuItem, (List)menuItem.getData());
                }
            });
        }
        if (testCaseCanBeDisintegrated.size() > 0) {
            MenuItem disintegrateMenuItem = new MenuItem(qTestMenu, 0);
            disintegrateMenuItem.setText(StringConstants.CM_DISINTEGRATE);
            disintegrateMenuItem.setData(testCaseCanBeDisintegrated);
            disintegrateMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem = (MenuItem)e.getSource();
                    QTestIntegrationReportTestCaseView.this.performDisintegrateTestCaseLogs(menuItem, (List)menuItem.getData());
                }
            });
        }
    }

    private void performDisintegrateTestCaseLogs(MenuItem menuItem, List<TestCaseLogRecord> testCasesCanBeDisintegrated) {
        ArrayList<ReportTestCaseLogPair> testCaseLogPairs = new ArrayList<ReportTestCaseLogPair>();
        ReportTestCaseLogPair pair = new ReportTestCaseLogPair(this.reportEntity, testCasesCanBeDisintegrated);
        testCaseLogPairs.add(pair);
        QTestDisintegrateReportHandler.performDisintegrateTestCaseLogs(testCaseLogPairs);
    }

    private void performUploadTestCaseLogs(MenuItem menuItem, List<TestCaseLogRecord> testCasesCanBeUploaded) {
        ArrayList<ReportTestCaseLogPair> testCaseLogPairs = new ArrayList<ReportTestCaseLogPair>();
        ReportTestCaseLogPair pair = new ReportTestCaseLogPair(this.reportEntity, testCasesCanBeUploaded);
        testCaseLogPairs.add(pair);
        QTestUploadReportHandler.performUploadTestCaseLogs(testCaseLogPairs, menuItem.getDisplay().getActiveShell());
    }
}

