/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.wizard;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.wizard.IWizardPage;
import com.kms.katalon.composer.components.impl.wizard.SimpleWizardDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.job.DisintegrateTestCaseJob;
import com.kms.katalon.composer.integration.qtest.wizard.page.AuthenticationWizardPage;
import com.kms.katalon.composer.integration.qtest.wizard.page.FinishPage;
import com.kms.katalon.composer.integration.qtest.wizard.page.OptionalSettingWizardPage;
import com.kms.katalon.composer.integration.qtest.wizard.page.ProjectChoosingWizardPage;
import com.kms.katalon.composer.integration.qtest.wizard.page.QTestModuleSelectionWizardPage;
import com.kms.katalon.composer.integration.qtest.wizard.page.QTestWizardPage;
import com.kms.katalon.composer.integration.qtest.wizard.page.TestCaseFolderSelectionWizardPage;
import com.kms.katalon.composer.integration.qtest.wizard.page.TestStuctureMappingPage;
import com.kms.katalon.composer.integration.qtest.wizard.page.TestSuiteFolderSelectionWizardPage;
import com.kms.katalon.composer.integration.qtest.wizard.provider.WizardTableLabelProvider;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationFolderManager;
import com.kms.katalon.integration.qtest.QTestIntegrationProjectManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.credential.IQTestToken;
import com.kms.katalon.integration.qtest.entity.QTestModule;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.model.TestCaseRepo;
import com.kms.katalon.integration.qtest.model.TestSuiteRepo;
import com.kms.katalon.integration.qtest.setting.QTestSettingStore;
import com.kms.katalon.integration.qtest.setting.QTestVersion;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class SetupWizardDialog
extends SimpleWizardDialog {
    private int lastTreeWidth = 220;
    private Composite stepArea;
    private CTableViewer tableViewer;
    private Label lblStepHeader;
    private TableViewerColumn pageViewerColumn;

    public SetupWizardDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        SetupWizardDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.dialogArea = this.createDialogArea(composite);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = (Composite)super.oldDialogArea(parent);
        GridLayout glDialogComposite = (GridLayout)dialogComposite.getLayout();
        glDialogComposite.numColumns = 4;
        glDialogComposite.marginHeight = 0;
        glDialogComposite.marginWidth = 0;
        glDialogComposite.verticalSpacing = 0;
        glDialogComposite.horizontalSpacing = 0;
        Composite stepTreeComposite = this.createStepTableComposite(dialogComposite);
        this.layoutTreeAreaControl((Control)stepTreeComposite);
        this.createSash(dialogComposite, (Control)stepTreeComposite);
        Label label = new Label(dialogComposite, 2);
        label.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        this.createWizardArea(dialogComposite);
        return dialogComposite;
    }

    private Composite createStepTableComposite(Composite dialogComposite) {
        Composite stepTreeComposite = new Composite(dialogComposite, 0);
        stepTreeComposite.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        stepTreeComposite.setLayout((Layout)new GridLayout(1, false));
        stepTreeComposite.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.tableViewer = new CTableViewer(stepTreeComposite, 65536);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.pageViewerColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        this.pageViewerColumn.getColumn().setWidth(200);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        return stepTreeComposite;
    }

    protected Composite createStepAreaComposite(Composite dialogComposite) {
        this.stepArea = new Composite(dialogComposite, 0);
        GridLayout glStepArea = new GridLayout(1, false);
        glStepArea.horizontalSpacing = 0;
        glStepArea.verticalSpacing = 0;
        glStepArea.marginWidth = 0;
        glStepArea.marginHeight = 0;
        this.stepArea.setLayout((Layout)glStepArea);
        this.stepArea.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite stepHeaderComposite = new Composite(this.stepArea, 0);
        stepHeaderComposite.setLayout((Layout)new GridLayout(1, false));
        stepHeaderComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        stepHeaderComposite.setBackground(ColorUtil.getWhiteBackgroundColor());
        stepHeaderComposite.setBackgroundMode(2);
        this.lblStepHeader = new Label(stepHeaderComposite, 0);
        this.lblStepHeader.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        FontData[] fD = this.lblStepHeader.getFont().getFontData();
        fD[0].setHeight(14);
        fD[0].setStyle(1);
        this.lblStepHeader.setFont(new Font((Device)Display.getCurrent(), fD[0]));
        Label separator = new Label(this.stepArea, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.stepDetailsComposite = new Composite(this.stepArea, 0);
        this.stepDetailsComposite.setLayout((Layout)new FillLayout(256));
        this.stepDetailsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        return this.stepArea;
    }

    protected void layoutTreeAreaControl(Control control) {
        GridData gd = new GridData(1040);
        gd.horizontalAlignment = 4;
        gd.widthHint = this.getLastRightWidth();
        gd.verticalSpan = 1;
        control.setLayoutData((Object)gd);
    }

    protected int getLastRightWidth() {
        return this.lastTreeWidth;
    }

    protected Sash createSash(final Composite composite, final Control rightControl) {
        final Sash sash = new Sash(composite, 512);
        sash.setLayoutData((Object)new GridData(1040));
        sash.setBackground(composite.getDisplay().getSystemColor(25));
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Point currentSize;
                if (event.detail == 1) {
                    return;
                }
                int shift = event.x - sash.getBounds().x;
                GridData data = (GridData)rightControl.getLayoutData();
                int newWidthHint = data.widthHint + shift;
                if (newWidthHint < 20) {
                    return;
                }
                Point computedSize = SetupWizardDialog.this.getShell().computeSize(-1, -1);
                boolean customSize = !computedSize.equals((Object)(currentSize = SetupWizardDialog.this.getShell().getSize()));
                data.widthHint = newWidthHint;
                SetupWizardDialog.this.setLastTreeWidth(newWidthHint);
                composite.layout(true);
                computedSize = SetupWizardDialog.this.getShell().computeSize(-1, -1);
                if (customSize) {
                    computedSize.x = Math.max(computedSize.x, currentSize.x);
                }
                computedSize.y = Math.max(computedSize.y, currentSize.y);
                if (computedSize.equals((Object)currentSize)) {
                    return;
                }
                SetupWizardDialog.this.setShellSize(computedSize.x, computedSize.y);
            }
        });
        return sash;
    }

    protected void setLastTreeWidth(int newWidthHint) {
        this.lastTreeWidth = newWidthHint;
    }

    private void setShellSize(int width, int height) {
        Rectangle preferred = this.getShell().getBounds();
        preferred.width = width;
        preferred.height = height;
        this.getShell().setBounds(this.getConstrainedShellBounds(preferred));
    }

    protected void setShellStyle(int arg) {
        super.setShellStyle(arg | 0x10);
    }

    protected void registerControlModifyListeners() {
        super.registerControlModifyListeners();
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    SetupWizardDialog.this.tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        });
        this.tableViewer.getTable().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFFD;
                event.detail &= 0xFFFFFFDF;
            }
        });
        this.tableViewer.getTable().addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 32;
            }
        });
    }

    protected Collection<IWizardPage> getWizardPages() {
        return Arrays.asList(new AuthenticationWizardPage(), new ProjectChoosingWizardPage(), new TestStuctureMappingPage(), new QTestModuleSelectionWizardPage(), new TestCaseFolderSelectionWizardPage(), new TestSuiteFolderSelectionWizardPage(), new OptionalSettingWizardPage(), new FinishPage());
    }

    protected void setInput() {
        super.setInput();
        this.pageViewerColumn.setLabelProvider((CellLabelProvider)new WizardTableLabelProvider(this.wizardManager));
        this.tableViewer.setInput((Object)this.wizardManager.getWizardPages());
    }

    protected void showPage(IWizardPage page) {
        super.showPage(page);
        this.tableViewer.refresh(true);
        List wizardPages = this.wizardManager.getWizardPages();
        String indexOfLastPage = ((QTestWizardPage)wizardPages.get(wizardPages.size() - 1)).getStepIndexAsString();
        String indexOfCurrentPage = ((QTestWizardPage)page).getStepIndexAsString();
        this.lblStepHeader.setText(MessageFormat.format(StringConstants.WZ_SETUP_STEP_TITLE, indexOfCurrentPage, indexOfLastPage, page.getTitle()));
    }

    protected Point getInitialSize() {
        return new Point(800, 500);
    }

    protected String getDialogTitle() {
        return StringConstants.WZ_SETUP_TITLE;
    }

    protected void finishPressed() {
        this.updateQTestSetting();
        this.updateProject();
        super.okPressed();
    }

    private void updateQTestSetting() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        String projectDir = currentProject.getFolderLocation();
        try {
            QTestSettingStore.saveEnableIntegration((boolean)true, (String)projectDir);
            QTestSettingStore.saveUserProfile((IQTestCredential)SetupWizardDialog.getCredential(this.sharedData), (String)projectDir);
            QTestSettingStore.saveAutoSubmit((boolean)((Boolean)this.sharedData.get("autoSubmitResult")), (String)projectDir);
            QTestSettingStore.saveSubmitToLatestVersion((boolean)((Boolean)this.sharedData.get("submitResultToLatestVersion")), (String)projectDir);
            QTestSettingStore.saveAttachmentSendingType((List)((List)this.sharedData.get("sendAttachments")), (String)projectDir);
            QTestSettingStore.saveFormatReportTypes((List)((List)this.sharedData.get("reportFormat")), (String)projectDir);
        }
        catch (IOException | GeneralSecurityException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void disintegrateAllTestCaseRepos() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        IntegratedEntity projectIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)currentProject);
        if (projectIntegratedEntity == null) {
            return;
        }
        try {
            List testCaseRepos = QTestIntegrationUtil.getTestCaseRepositories((ProjectEntity)currentProject, (List)QTestIntegrationProjectManager.getQTestProjectsByIntegratedEntity((IntegratedEntity)projectIntegratedEntity));
            ArrayList<IntegratedFileEntity> integratedTestCaseFolder = new ArrayList<IntegratedFileEntity>();
            for (TestCaseRepo testCaseRepo : testCaseRepos) {
                try {
                    FolderEntity folderEntity = FolderController.getInstance().getFolderByDisplayId(currentProject, testCaseRepo.getFolderId());
                    if (folderEntity == null) continue;
                    integratedTestCaseFolder.add((IntegratedFileEntity)folderEntity);
                }
                catch (Exception ex) {
                    LoggerSingleton.logError((Throwable)ex);
                }
            }
            DisintegrateTestCaseJob job = new DisintegrateTestCaseJob(false);
            job.setFileEntities(integratedTestCaseFolder);
            job.doTask();
            job.join();
        }
        catch (InterruptedException ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    private void disintegrateAllTestSuiteRepos() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        IntegratedEntity projectIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)currentProject);
        if (projectIntegratedEntity == null) {
            return;
        }
        List testSuiteRepos = QTestIntegrationUtil.getTestSuiteRepositories((ProjectEntity)currentProject, (List)QTestIntegrationProjectManager.getQTestProjectsByIntegratedEntity((IntegratedEntity)projectIntegratedEntity));
        for (TestSuiteRepo testSuiteRepo : testSuiteRepos) {
            String testSuiteFolderId = testSuiteRepo.getFolderId();
            try {
                FolderEntity testSuiteFolderEntity = FolderController.getInstance().getFolderByDisplayId(currentProject, testSuiteFolderId);
                FolderController.getInstance().getAllDescentdantEntities(testSuiteFolderEntity);
                for (Object childObject : FolderController.getInstance().getAllDescentdantEntities(testSuiteFolderEntity)) {
                    TestSuiteEntity testSuiteEntity;
                    if (!(childObject instanceof TestSuiteEntity) || QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)(testSuiteEntity = (TestSuiteEntity)childObject)) == null) continue;
                    this.disintegrateAllReport(testSuiteEntity, currentProject);
                    testSuiteEntity = (TestSuiteEntity)QTestIntegrationUtil.removeQTestIntegratedEntity((IntegratedFileEntity)testSuiteEntity);
                    TestSuiteController.getInstance().updateTestSuite(testSuiteEntity);
                    EventBrokerSingleton.getInstance().getEventBroker().post("TESTSUITE/UPDATED", (Object)new Object[]{testSuiteEntity.getId(), testSuiteEntity});
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    private void disintegrateAllReport(TestSuiteEntity testSuiteEntity, ProjectEntity projectEntity) {
        try {
            for (ReportEntity reportEntity : ReportController.getInstance().listReportEntities(testSuiteEntity, projectEntity)) {
                reportEntity = (ReportEntity)QTestIntegrationUtil.removeQTestIntegratedEntity((IntegratedFileEntity)reportEntity);
                ReportController.getInstance().updateReport(reportEntity);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void updateProject() {
        try {
            this.disintegrateAllTestCaseRepos();
            this.disintegrateAllTestSuiteRepos();
            QTestProject defaultQTestPrject = (QTestProject)this.sharedData.get("qTestProject");
            QTestModule selectedModule = (QTestModule)this.sharedData.get("qTestModule");
            FolderTreeEntity selectedTestCaseFolderTree = (FolderTreeEntity)this.sharedData.get("testCaseFolder");
            FolderTreeEntity selectedTestSuiteFolderTree = (FolderTreeEntity)this.sharedData.get("testSuiteFolder");
            FolderEntity testCaseFolderEntity = selectedTestCaseFolderTree.getObject();
            FolderEntity testSuiteFolderEntity = selectedTestSuiteFolderTree.getObject();
            String testCaseFolderId = testCaseFolderEntity.getIdForDisplay();
            String testSuiteFolderId = testSuiteFolderEntity.getIdForDisplay();
            defaultQTestPrject.getTestCaseFolderIds().add(testCaseFolderId);
            defaultQTestPrject.getTestSuiteFolderIds().add(testSuiteFolderId);
            IntegratedEntity testCaseFolderIntegratedEntity = QTestIntegrationFolderManager.getFolderIntegratedEntityByQTestModule((QTestModule)selectedModule);
            testCaseFolderEntity = (FolderEntity)QTestIntegrationUtil.updateFileIntegratedEntity((IntegratedFileEntity)testCaseFolderEntity, (IntegratedEntity)testCaseFolderIntegratedEntity);
            FolderController.getInstance().saveFolder(testCaseFolderEntity);
            IntegratedEntity projectIntegratedEntity = QTestIntegrationProjectManager.getIntegratedEntityByQTestProjects((List)((List)this.sharedData.get("qTestProjects")));
            ProjectEntity currentProject = (ProjectEntity)QTestIntegrationUtil.updateFileIntegratedEntity((IntegratedFileEntity)ProjectController.getInstance().getCurrentProject(), (IntegratedEntity)projectIntegratedEntity);
            ProjectController.getInstance().updateProject(currentProject);
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    public static IQTestCredential getCredential(final Map<String, Object> sharedData) {
        return new IQTestCredential(){

            public String getServerUrl() {
                if (sharedData == null || !(sharedData.get("serverUrl") instanceof String)) {
                    return "";
                }
                String serverUrl = (String)sharedData.get("serverUrl");
                if (StringUtils.isBlank((String)serverUrl)) {
                    return "";
                }
                serverUrl = serverUrl.trim();
                while (!serverUrl.isEmpty() && serverUrl.endsWith("/")) {
                    serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
                }
                return serverUrl;
            }

            public String getUsername() {
                return (String)sharedData.get("username");
            }

            public String getPassword() {
                return (String)sharedData.get("password");
            }

            public IQTestToken getToken() {
                return (IQTestToken)sharedData.get("token");
            }

            public QTestVersion getVersion() {
                return (QTestVersion)sharedData.get("version");
            }

            public boolean isEncryptionEnabled() {
                return (Boolean)sharedData.get("enableAuthenticationEncryption");
            }
        };
    }

    public String getStepIndexAsString() {
        return null;
    }

    public boolean isChild() {
        return false;
    }
}

