/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.common;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.webservice.common.Input;
import com.kms.katalon.core.webservice.helper.WebServiceCommonHelper;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class ResourceResolver
implements LSResourceResolver {
    private WebServiceCommonHelper.LocalFileProvider localFileProvider;
    private WebServiceCommonHelper.RemoteFileProvider remoteFileProvider;
    private KeywordLogger logger = KeywordLogger.getInstance(ResourceResolver.class);

    public ResourceResolver(WebServiceCommonHelper.LocalFileProvider localFileProvider, WebServiceCommonHelper.RemoteFileProvider remoteFileProvider) {
        this.localFileProvider = localFileProvider;
        this.remoteFileProvider = remoteFileProvider;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        try {
            String resource;
            String string = resource = this.localFileProvider != null ? this.localFileProvider.read(systemId) : null;
            if (StringUtils.isBlank((CharSequence)resource)) {
                resource = this.remoteFileProvider != null ? this.remoteFileProvider.fetch(systemId) : null;
            }
            InputStream resourceAsStream = IOUtils.toInputStream((String)resource, (Charset)StandardCharsets.UTF_8);
            Objects.requireNonNull(resourceAsStream, String.format("Could not find the specified xsd file: %s", systemId));
            return new Input(publicId, systemId, resourceAsStream);
        }
        catch (Exception error) {
            this.logger.logError(error.getMessage());
            return null;
        }
    }
}

