/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.transfer;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;

public abstract class EntityTransfer
extends ByteArrayTransfer {
    protected static final Class<?> getTypeClass() {
        return ITreeEntity.class;
    }

    protected static final String getTypeName() {
        return EntityTransfer.getTypeClass().getName();
    }

    protected static final int getTypeID() {
        return EntityTransfer.registerType((String)EntityTransfer.getTypeName());
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkType(object) || !this.isSupportedType(transferData)) {
            DND.error((int)2003);
        }
        ITreeEntity[] treeEntites = (ITreeEntity[])object;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream writeOut = new DataOutputStream(out);
            int i = 0;
            int length = treeEntites.length;
            while (i < length) {
                byte[] buffer = this.objectToBytes(treeEntites[i]);
                writeOut.writeInt(buffer.length);
                writeOut.write(buffer);
                ++i;
            }
            byte[] buffer = out.toByteArray();
            writeOut.close();
            super.javaToNative((Object)buffer, transferData);
        }
        catch (Exception e) {
            LoggerSingleton.getInstance().getLogger().error((Throwable)e);
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            ITreeEntity[] myData = new ITreeEntity[]{};
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                DataInputStream readIn = new DataInputStream(in);
                while (readIn.available() > 20) {
                    int size = readIn.readInt();
                    byte[] payload = new byte[size];
                    readIn.read(payload);
                    Object obj = this.bytesToObject(payload);
                    ITreeEntity datum = (ITreeEntity)obj;
                    ITreeEntity[] newMyData = new ITreeEntity[myData.length + 1];
                    System.arraycopy(myData, 0, newMyData, 0, myData.length);
                    newMyData[myData.length] = datum;
                    myData = newMyData;
                }
                readIn.close();
            }
            catch (Exception ex) {
                LoggerSingleton.getInstance().getLogger().error((Throwable)ex);
                return null;
            }
            return myData;
        }
        return null;
    }

    protected String[] getTypeNames() {
        return new String[]{EntityTransfer.getTypeName()};
    }

    protected int[] getTypeIds() {
        return new int[]{EntityTransfer.getTypeID()};
    }

    protected boolean checkType(Object object) {
        if (object == null || !(object instanceof ITreeEntity[]) || ((ITreeEntity[])object).length == 0) {
            return false;
        }
        ITreeEntity[] elementArray = (ITreeEntity[])object;
        int i = 0;
        while (i < elementArray.length) {
            if (elementArray[i] == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkType(object);
    }

    protected abstract byte[] objectToBytes(Object var1) throws Exception;

    protected abstract Object bytesToObject(byte[] var1) throws Exception;
}

