/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.codeassist.proposal;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;

public class SequenceFinder {
    private static final int[] EMPTY_SEQUENCE = new int[0];
    private List<int[]> curSequences = new LinkedList<int[]>();
    private List<int[]> nextSequences = new LinkedList<int[]>();
    private int pCompletion;
    private int pToken;
    private String completion;
    private String token;
    private boolean searched = false;

    public SequenceFinder(String completion, String token) {
        this.completion = completion;
        this.reset(token);
    }

    public void changeToken(String token) {
        if (ObjectUtils.equals((Object)this.token, (Object)token)) {
            return;
        }
        this.reset(token);
    }

    private void reset(String token) {
        this.token = token;
        this.nextSequences = new LinkedList<int[]>();
        this.curSequences = new LinkedList<int[]>();
        this.searched = false;
    }

    public List<int[]> findSequences() {
        try {
            if (this.searched) {
                List<int[]> list = this.curSequences;
                return list;
            }
            if (this.isConstantName(this.completion)) {
                this.rewriteCompletion();
            }
            int[] start = EMPTY_SEQUENCE;
            this.curSequences.add(start);
            this.pToken = 0;
            while (this.pToken < this.token.length()) {
                char t = this.token.charAt(this.pToken);
                for (int[] activeSequence : this.curSequences) {
                    int startIndex;
                    this.pCompletion = startIndex = activeSequence.length == 0 ? 0 : activeSequence[activeSequence.length - 1] + 1;
                    while (this.pCompletion < this.completion.length()) {
                        char c = this.completion.charAt(this.pCompletion);
                        if (this.isSameIgnoreCase(c, t)) {
                            this.addNewSubsequenceForNext(activeSequence);
                        }
                        ++this.pCompletion;
                    }
                }
                this.curSequences = this.nextSequences;
                this.nextSequences = new LinkedList<int[]>();
                ++this.pToken;
            }
            Iterator<int[]> it = this.curSequences.iterator();
            while (it.hasNext()) {
                int[] candidate = it.next();
                if (candidate.length >= this.token.length()) continue;
                it.remove();
            }
            List<int[]> list = this.curSequences;
            return list;
        }
        finally {
            this.searched = true;
        }
    }

    private void addNewSubsequenceForNext(int[] activeSequence) {
        int[] copy = Arrays.copyOf(activeSequence, activeSequence.length + 1);
        copy[this.pToken] = this.pCompletion;
        this.nextSequences.add(copy);
    }

    private void rewriteCompletion() {
        StringBuilder sb = new StringBuilder();
        boolean toUpperCase = false;
        char[] cArray = this.completion.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isLetterOrDigit(c)) {
                sb.append(toUpperCase ? Character.toUpperCase(c) : Character.toLowerCase(c));
                toUpperCase = false;
            } else {
                sb.append(c);
                toUpperCase = true;
            }
            ++n2;
        }
        this.completion = sb.toString();
    }

    private boolean isConstantName(String completion) {
        char[] cArray = completion.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isLetter(c) && Character.isLowerCase(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isSameIgnoreCase(char c1, char c2) {
        return Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    public static String getToken(String replacedString) {
        if (replacedString == null || replacedString.isEmpty()) {
            return "";
        }
        String newString = replacedString;
        if (replacedString.startsWith("'") || replacedString.startsWith("\"")) {
            newString = newString.length() == 1 ? "" : newString.substring(1, newString.length());
        }
        if (newString.endsWith("'") || newString.endsWith("\"")) {
            newString = newString.length() == 1 ? "" : newString.substring(0, newString.length() - 1);
        }
        return newString;
    }
}

