/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.global.dialog;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.providers.TypeCheckStyleCellTableLabelProvider;
import com.kms.katalon.composer.components.impl.support.TypeCheckedEditingSupport;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.global.constants.StringConstants;
import com.kms.katalon.composer.testcase.ast.editors.StringConstantCellEditor;
import com.kms.katalon.composer.testcase.constants.ImageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueTypeColumnSupport;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeOptionsProvider;
import com.kms.katalon.composer.testcase.util.AstValueUtil;
import com.kms.katalon.entity.global.GlobalVariableEntity;
import com.kms.katalon.entity.global.enums.VariableValueType;
import com.kms.katalon.groovy.constant.GroovyConstants;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class GlobalVariableBuilderDialog
extends AbstractDialog {
    private static final InputValueType[] defaultInputValueTypes = AstInputValueTypeOptionsProvider.getInputValueTypeOptions((InputValueType)InputValueType.GlobalVariable);
    private String dialogTitle;
    private GlobalVariableEntity fVariableEntity;
    private Point location;
    private TableViewer tableViewer;
    private List<String> globalVariableNames = new ArrayList<String>();
    private CellEditor cellEditor;

    public GlobalVariableBuilderDialog(Shell parentShell, GlobalVariableEntity variableEntity, Point location, List<String> globalVariableNames) {
        this(parentShell, variableEntity, DialogType.EDIT, location, globalVariableNames);
    }

    public GlobalVariableBuilderDialog(Shell parentShell, GlobalVariableEntity variableEntity, DialogType type, Point location, List<String> globalVariableNames) {
        super(parentShell);
        this.fVariableEntity = variableEntity.clone();
        this.location = location;
        switch (type) {
            case EDIT: {
                this.dialogTitle = StringConstants.DIA_TITLE_EDIT_VAR;
                globalVariableNames.remove(variableEntity.getName());
                break;
            }
            case NEW: {
                this.dialogTitle = StringConstants.DIA_TITLE_NEW_VAR;
            }
        }
        this.globalVariableNames = globalVariableNames;
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout(1, false);
        glContainer.horizontalSpacing = 10;
        glContainer.verticalSpacing = 10;
        container.setLayout((Layout)glContainer);
        Composite compositeTable = new Composite(container, 0);
        compositeTable.setLayout((Layout)new FillLayout(256));
        compositeTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer = new TableViewer(compositeTable, 67584);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        TableViewerEditor.create((TableViewer)this.tableViewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer), (int)48);
        ControlDecoration controlDecoration = new ControlDecoration((Control)this.tableViewer.getTable(), 16512);
        controlDecoration.setDescriptionText("Variable names are case-sensitive.\nA variable's name can be any letters, digits, the dollar sign \"$\", or the underscore charater \"_\".\nHowever, it cannot start with a digit.");
        controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        TableViewerColumn tableViewerColumnName = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnName.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected CellEditor getCellEditor(Object element) {
                return new CustomTextCellEditor((Composite)GlobalVariableBuilderDialog.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                if (element != null && element instanceof GlobalVariableEntity) {
                    return ((GlobalVariableEntity)element).getName();
                }
                return "";
            }

            protected void setValue(Object element, Object value) {
                GlobalVariableEntity param;
                String newParamName;
                if (element != null && element instanceof GlobalVariableEntity && value != null && value instanceof String && !(newParamName = (String)value).equals((param = (GlobalVariableEntity)element).getName())) {
                    param.setName(newParamName);
                    this.getViewer().update(element, null);
                    GlobalVariableBuilderDialog.this.refresh();
                }
            }
        });
        tableViewerColumnName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof GlobalVariableEntity) {
                    return ((GlobalVariableEntity)element).getName();
                }
                return "";
            }
        });
        TableColumn tblclmnName = tableViewerColumnName.getColumn();
        tblclmnName.setWidth(100);
        tblclmnName.setText(StringConstants.PA_COL_NAME);
        TableViewerColumn tableViewerColumnDefaultValueType = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnDefaultValueType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof GlobalVariableEntity)) {
                    return "";
                }
                GlobalVariableEntity globalVariable = (GlobalVariableEntity)element;
                InputValueType valueType = AstValueUtil.getTypeValue((Object)GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression((String)globalVariable.getInitValue()));
                if (valueType != null) {
                    if (valueType.equals((Object)InputValueType.Number)) {
                        globalVariable.setValueType(VariableValueType.NUMBER);
                    } else if (valueType.equals((Object)InputValueType.String)) {
                        globalVariable.setValueType(VariableValueType.STRING);
                    } else {
                        globalVariable.setValueType(null);
                    }
                    return TreeEntityUtil.getReadableKeywordName((String)valueType.getName());
                }
                return "";
            }
        });
        tableViewerColumnDefaultValueType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.tableViewer, defaultInputValueTypes){
            private ExpressionWrapper expression;
            private Object oldValueTypeIndex;

            protected CellEditor getCellEditor(Object element) {
                return new CustomComboBoxCellEditor((Composite)GlobalVariableBuilderDialog.this.tableViewer.getTable(), this.readableValueTypeNames);
            }

            protected boolean canEdit(Object element) {
                return element instanceof GlobalVariableEntity && !((GlobalVariableEntity)element).isProtected();
            }

            protected Object getValue(Object element) {
                this.oldValueTypeIndex = super.getValue((Object)GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression((String)((GlobalVariableEntity)element).getInitValue()));
                return this.oldValueTypeIndex;
            }

            protected void setValue(Object element, Object value) {
                if (!(value instanceof Integer) || (Integer)value < 0 || (Integer)value >= this.inputValueTypes.length) {
                    return;
                }
                InputValueType newValueType = this.inputValueTypes[(Integer)value];
                if (newValueType == this.inputValueTypes[(Integer)this.oldValueTypeIndex]) {
                    return;
                }
                this.oldValueTypeIndex = value;
                ASTNodeWrapper newAstNode = (ASTNodeWrapper)newValueType.getNewValue(this.expression != null ? this.expression.getParent() : null);
                if (newAstNode == null) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                GroovyWrapperParser groovyParser = new GroovyWrapperParser(stringBuilder);
                groovyParser.parse((Object)newAstNode);
                GlobalVariableEntity globalVariable = (GlobalVariableEntity)element;
                if (newValueType.equals((Object)InputValueType.Number)) {
                    globalVariable.setValueType(VariableValueType.NUMBER);
                } else if (newValueType.equals((Object)InputValueType.String)) {
                    globalVariable.setValueType(VariableValueType.STRING);
                } else {
                    globalVariable.setValueType(null);
                }
                globalVariable.setInitValue(stringBuilder.toString());
                this.getViewer().update(element, null);
                GlobalVariableBuilderDialog.this.refresh();
            }
        });
        TableColumn tblclmnDefaultValueType = tableViewerColumnDefaultValueType.getColumn();
        tblclmnDefaultValueType.setWidth(100);
        tblclmnDefaultValueType.setText(StringConstants.PA_COL_DEFAULT_VALUE_TYPE);
        TableViewerColumn tableViewerColumnDefaultValue = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnDefaultValue.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){
            private ExpressionWrapper expression;

            protected CellEditor getCellEditor(Object element) {
                GlobalVariableBuilderDialog.this.cellEditor = null;
                this.expression = GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression((String)((GlobalVariableEntity)element).getValue());
                if (this.expression == null) {
                    return null;
                }
                InputValueType inputValueType = AstValueUtil.getTypeValue((Object)this.expression);
                if (inputValueType != null && !inputValueType.equals((Object)InputValueType.String)) {
                    GlobalVariableBuilderDialog.this.cellEditor = inputValueType.getCellEditorForValue((Composite)GlobalVariableBuilderDialog.this.tableViewer.getTable(), (Object)this.expression);
                    return GlobalVariableBuilderDialog.this.cellEditor;
                }
                if (inputValueType.equals((Object)InputValueType.String) && inputValueType != null) {
                    return new MultilineTextCellEditor((Composite)GlobalVariableBuilderDialog.this.tableViewer.getTable());
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof GlobalVariableEntity;
            }

            protected Object getValue(Object element) {
                InputValueType inputValueType = AstValueUtil.getTypeValue((Object)this.expression);
                if (inputValueType != null) {
                    return inputValueType.getValueToEdit((Object)this.expression);
                }
                return null;
            }

            protected void setValue(Object element, Object value) {
                if (value == null) {
                    return;
                }
                InputValueType inputValueType = AstValueUtil.getTypeValue((Object)this.expression);
                if (inputValueType == null) {
                    return;
                }
                Object object = inputValueType.changeValue((Object)this.expression, value);
                if (!(object instanceof ASTNodeWrapper)) {
                    return;
                }
                ASTNodeWrapper newAstNode = (ASTNodeWrapper)object;
                StringBuilder stringBuilder = new StringBuilder();
                GroovyWrapperParser groovyParser = new GroovyWrapperParser(stringBuilder);
                groovyParser.parse((Object)newAstNode);
                ((GlobalVariableEntity)element).setInitValue(stringBuilder.toString());
                this.getViewer().update(element, null);
                GlobalVariableBuilderDialog.this.refresh();
            }
        });
        TableColumn tblclmnDefaultValue = tableViewerColumnDefaultValue.getColumn();
        tblclmnDefaultValue.setWidth(180);
        tblclmnDefaultValue.setText(StringConstants.PA_COL_DEFAULT_VALUE);
        tableViewerColumnDefaultValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof GlobalVariableEntity) || ((GlobalVariableEntity)element).getValue() == null) {
                    return "";
                }
                if (((GlobalVariableEntity)element).isProtected()) {
                    return "\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022";
                }
                ExpressionWrapper expression = GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression((String)((GlobalVariableEntity)element).getInitValue());
                if (expression == null) {
                    return "";
                }
                return expression.getText();
            }
        });
        TableViewerColumn tableViewerColumnDescription = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnDescription.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected CellEditor getCellEditor(Object element) {
                return new CustomTextCellEditor((Composite)GlobalVariableBuilderDialog.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return element instanceof GlobalVariableEntity;
            }

            protected Object getValue(Object element) {
                if (element instanceof GlobalVariableEntity) {
                    return ((GlobalVariableEntity)element).getDescription();
                }
                return StringConstants.EMPTY;
            }

            protected void setValue(Object element, Object value) {
                GlobalVariableEntity param;
                String newParamDesc;
                if (element instanceof GlobalVariableEntity && value instanceof String && !(newParamDesc = (String)value).equals((param = (GlobalVariableEntity)element).getDescription())) {
                    param.setDescription(newParamDesc);
                    this.getViewer().update(element, null);
                    GlobalVariableBuilderDialog.this.refresh();
                }
            }
        });
        tableViewerColumnDescription.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof GlobalVariableEntity) {
                    return ((GlobalVariableEntity)element).getDescription();
                }
                return StringConstants.EMPTY;
            }
        });
        TableColumn tblColumnDescription = tableViewerColumnDescription.getColumn();
        tblColumnDescription.setWidth(160);
        tblColumnDescription.setText(StringConstants.PA_COL_DESCRIPTION);
        TableViewerColumn tableViewerColumnProtected = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblColumnProtected = tableViewerColumnProtected.getColumn();
        tblColumnProtected.setWidth(100);
        tblColumnProtected.setText(StringConstants.PA_COL_PROTECTED);
        tableViewerColumnProtected.setLabelProvider((CellLabelProvider)new TypeCheckStyleCellTableLabelProvider<GlobalVariableEntity>(5){

            protected Image getImage(GlobalVariableEntity element) {
                return element.isProtected() ? ImageConstants.IMG_16_CHECKBOX_CHECKED : ImageConstants.IMG_16_CHECKBOX_UNCHECKED;
            }

            protected String getText(GlobalVariableEntity element) {
                return "";
            }

            protected Class<GlobalVariableEntity> getElementType() {
                return GlobalVariableEntity.class;
            }
        });
        tableViewerColumnProtected.setEditingSupport((EditingSupport)new TypeCheckedEditingSupport<GlobalVariableEntity>((ColumnViewer)this.tableViewer){

            protected Class<GlobalVariableEntity> getElementType() {
                return GlobalVariableEntity.class;
            }

            protected CellEditor getCellEditorByElement(GlobalVariableEntity element) {
                return new CheckboxCellEditor(this.getComposite());
            }

            protected boolean canEditElement(GlobalVariableEntity element) {
                if (element != null && element instanceof GlobalVariableEntity) {
                    GlobalVariableEntity entity = element;
                    return entity.getValueType().equals((Object)VariableValueType.STRING) || entity.getValueType().equals((Object)VariableValueType.NUMBER);
                }
                return false;
            }

            protected Object getElementValue(GlobalVariableEntity element) {
                return element.isProtected();
            }

            protected void setElementValue(GlobalVariableEntity element, Object value) {
                if (!(value instanceof Boolean)) {
                    return;
                }
                boolean isProtected = (Boolean)value;
                if (element.isProtected() == isProtected) {
                    return;
                }
                element.setProtected(isProtected);
                this.getViewer().update((Object)element, null);
                GlobalVariableBuilderDialog.this.refresh();
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        return container;
    }

    protected Point getInitialSize() {
        return new Point(650, 250);
    }

    private void refresh() {
        this.tableViewer.setInput((Object)new Object[]{this.fVariableEntity});
        this.getButton(0).setEnabled(this.validate());
    }

    private boolean validate() {
        String newVariableName = this.fVariableEntity.getName();
        if (!GroovyConstants.VARIABLE_NAME_REGEX.matcher(newVariableName).find()) {
            return false;
        }
        if (this.globalVariableNames.contains(newVariableName)) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getDialogTitle(), (String)StringConstants.PA_MSG_VARIABLE_NAME_EXIST);
            return false;
        }
        return true;
    }

    public String getDialogTitle() {
        return this.dialogTitle != null ? this.dialogTitle : StringConstants.EMPTY;
    }

    protected final void setInput() {
        this.refresh();
        this.tableViewer.editElement(this.tableViewer.getElementAt(0), 0);
    }

    public GlobalVariableEntity getVariableEntity() {
        return this.fVariableEntity;
    }

    public Point getInitialLocation(Point initialSize) {
        if (this.location != null) {
            return new Point(this.location.x - initialSize.x - 10, this.location.y);
        }
        return super.getInitialLocation(initialSize);
    }

    protected void registerControlModifyListeners() {
    }

    protected void okPressed() {
        if (this.cellEditor != null) {
            AstValueUtil.applyEditingValue((CellEditor)this.cellEditor);
        }
        super.okPressed();
    }

    private class CustomComboBoxCellEditor
    extends ComboBoxCellEditor {
        public CustomComboBoxCellEditor(Composite parent, String[] items) {
            super(parent, items);
        }

        public CellEditor.LayoutData getLayoutData() {
            CellEditor.LayoutData result = super.getLayoutData();
            result.minimumHeight = GlobalVariableBuilderDialog.this.tableViewer.getTable().getItemHeight();
            return result;
        }
    }

    private class CustomTextCellEditor
    extends TextCellEditor {
        public CustomTextCellEditor(Composite parent) {
            super(parent);
        }

        public CellEditor.LayoutData getLayoutData() {
            CellEditor.LayoutData result = super.getLayoutData();
            result.minimumHeight = 10;
            return result;
        }
    }

    public static enum DialogType {
        NEW,
        EDIT;

    }

    private class MultilineTextCellEditor
    extends StringConstantCellEditor {
        public MultilineTextCellEditor(Composite parent) {
            super(parent, 2626);
        }

        public CellEditor.LayoutData getLayoutData() {
            CellEditor.LayoutData data = new CellEditor.LayoutData();
            data.minimumHeight = 100;
            data.verticalAlignment = 128;
            return data;
        }
    }
}

