/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.element;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HTMLRawElement {
    private String tag;
    private NamedNodeMap attributes;
    private HTMLRawElement parentElement;
    private List<HTMLRawElement> childElements;
    private String xpath;
    private String absoluteXpath;
    private Element domElement;
    private int index;

    public HTMLRawElement(Element domElement, int index, HTMLRawElement parentElement, String xpath, List<HTMLRawElement> childElements) {
        this.tag = domElement.getTagName();
        this.xpath = xpath;
        this.attributes = domElement.getAttributes();
        this.childElements = childElements;
        this.domElement = domElement;
        this.index = index;
        this.parentElement = parentElement;
        this.buildAbsoluteXPath();
    }

    private void buildAbsoluteXPath() {
        this.absoluteXpath = (this.parentElement != null ? this.parentElement.getAbsoluteXpath() : "") + "/" + this.tag + "[" + this.index + "]";
    }

    public String getTag() {
        return this.tag;
    }

    public NamedNodeMap getAttributes() {
        return this.attributes;
    }

    public HTMLRawElement getParentElement() {
        return this.parentElement;
    }

    public List<HTMLRawElement> getChildElements() {
        return this.childElements;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("<");
        stringBuilder.append(this.tag);
        int i = 0;
        while (i < this.attributes.getLength()) {
            Node attribute = this.attributes.item(i);
            stringBuilder.append(" ");
            stringBuilder.append(attribute.getNodeName());
            stringBuilder.append("='");
            stringBuilder.append(attribute.getNodeValue());
            stringBuilder.append("'");
            ++i;
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    public String getXpath() {
        return this.xpath;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof HTMLRawElement) && !(object instanceof String)) {
            return false;
        }
        String xpath = null;
        xpath = object instanceof HTMLRawElement ? ((HTMLRawElement)object).getAbsoluteXpath() : String.valueOf(object);
        return StringUtils.equals((String)xpath, (String)this.getAbsoluteXpath());
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 31).append((Object)this.absoluteXpath).toHashCode();
    }

    public String getAbsoluteXpath() {
        return this.absoluteXpath;
    }

    public Element getDomElement() {
        return this.domElement;
    }

    public void setDomElement(Element domElement) {
        this.domElement = domElement;
    }
}

