/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.editor;

import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.editor.HttpBodyEditor;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.webservice.ParameterizedBodyContent;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class AbstractNameValueBodyEditor<P>
extends HttpBodyEditor {
    protected ToolItem btnAdd;
    protected ToolItem btnRemove;
    protected ParameterTable tvParams;
    protected ParameterizedBodyContent<P> bodyContent;

    public AbstractNameValueBodyEditor(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.createToolbar(this);
        this.createParameterTable(this);
    }

    private void createToolbar(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 8519744);
        toolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        toolbar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnAdd = new ToolItem(toolbar, 0x800000);
        this.btnAdd.setText(StringConstants.ADD);
        this.btnAdd.setImage(ImageManager.getImage((String)"add_16.png"));
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractNameValueBodyEditor.this.tvParams.addEmptyRow();
            }
        });
        this.btnRemove = new ToolItem(toolbar, 0x800000);
        this.btnRemove.setText(StringConstants.REMOVE);
        this.btnRemove.setImage(ImageManager.getImage((String)"delete_16.png"));
        this.btnRemove.setDisabledImage(ImageManager.getImage((String)"delete_disabled_16.png"));
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractNameValueBodyEditor.this.tvParams.removeSelectedRows();
            }
        });
        this.btnRemove.setEnabled(false);
    }

    private void createParameterTable(Composite parent) {
        this.tvParams = this.doCreateParameterTable(parent);
        Table tParams = this.tvParams.getTable();
        tParams.setHeaderVisible(true);
        tParams.setLinesVisible(ControlUtils.shouldLineVisble((Display)tParams.getDisplay()));
        tParams.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                AbstractNameValueBodyEditor.this.tvParams.addEmptyRow();
            }
        });
        tParams.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                AbstractNameValueBodyEditor.this.tvParams.showContextMenu();
            }
        });
    }

    protected abstract ParameterTable doCreateParameterTable(Composite var1);

    protected abstract P createEmptyParameter();

    protected abstract boolean isEmptyParameter(P var1);

    @Override
    public String getContentType() {
        return this.getViewModel().getContentType();
    }

    @Override
    public String getContentData() {
        this.tvParams.removeEmptyRows();
        this.updateViewModel();
        return this.getViewModel().getContentData();
    }

    private void updateButtonRemoveState() {
        if (this.bodyContent.getParameters().isEmpty()) {
            this.btnRemove.setEnabled(false);
        } else {
            this.btnRemove.setEnabled(true);
        }
    }

    protected void updateViewModel() {
        this.getViewModel().setContentType(this.bodyContent.getContentType());
        this.getViewModel().setContentData(JsonUtil.toJson(this.bodyContent));
    }

    protected class ParameterTable
    extends TableViewer {
        public ParameterTable(Composite parent, int style) {
            super(parent, style);
        }

        private void showContextMenu() {
            final Table table = this.getTable();
            Menu menu = table.getMenu();
            if (menu != null) {
                menu.dispose();
            }
            menu = new Menu((Control)table);
            MenuItem menuItemAdd = new MenuItem(menu, 8);
            menuItemAdd.setText(StringConstants.PARAM_TABLE_MENU_ITEM_ADD);
            menuItemAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableItem[] items = table.getSelection();
                    if (items.length > 0) {
                        ParameterTable.this.addEmptyRowAt(table.indexOf(items[0]));
                    } else {
                        ParameterTable.this.addEmptyRow();
                    }
                }
            });
            if (table.getItemCount() > 0) {
                MenuItem menuItemRemove = new MenuItem(menu, 8);
                menuItemRemove.setText(StringConstants.PARAM_TABLE_MENU_ITEM_REMOVE);
                menuItemRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ParameterTable.this.removeSelectedRows();
                    }
                });
            }
            table.setMenu(menu);
        }

        public void addEmptyRow() {
            Object lastParam;
            List params = AbstractNameValueBodyEditor.this.bodyContent.getParameters();
            if (params.size() > 0 && AbstractNameValueBodyEditor.this.isEmptyParameter(lastParam = params.get(params.size() - 1))) {
                AbstractNameValueBodyEditor.this.tvParams.editElement(lastParam, 0);
            } else {
                Object param = AbstractNameValueBodyEditor.this.createEmptyParameter();
                AbstractNameValueBodyEditor.this.bodyContent.addParameter(param);
                AbstractNameValueBodyEditor.this.tvParams.add(param);
                AbstractNameValueBodyEditor.this.tvParams.editElement(param, 0);
            }
            AbstractNameValueBodyEditor.this.updateButtonRemoveState();
            AbstractNameValueBodyEditor.this.fireModifyEvent();
        }

        public void addEmptyRowAt(int selectedRowIndex) {
            Object param = AbstractNameValueBodyEditor.this.createEmptyParameter();
            AbstractNameValueBodyEditor.this.bodyContent.addParameter(selectedRowIndex, param);
            AbstractNameValueBodyEditor.this.tvParams.insert(param, selectedRowIndex);
            AbstractNameValueBodyEditor.this.tvParams.editElement(param, 0);
            AbstractNameValueBodyEditor.this.updateButtonRemoveState();
            AbstractNameValueBodyEditor.this.fireModifyEvent();
        }

        public void removeSelectedRows() {
            Object[] selections;
            Object[] objectArray = selections = AbstractNameValueBodyEditor.this.tvParams.getStructuredSelection().toArray();
            int n = selections.length;
            int n2 = 0;
            while (n2 < n) {
                Object selection = objectArray[n2];
                AbstractNameValueBodyEditor.this.bodyContent.removeParameter(selection);
                ++n2;
            }
            AbstractNameValueBodyEditor.this.tvParams.remove(selections);
            AbstractNameValueBodyEditor.this.updateButtonRemoveState();
            AbstractNameValueBodyEditor.this.fireModifyEvent();
        }

        public void removeEmptyRows() {
            List emptyParams = AbstractNameValueBodyEditor.this.bodyContent.getParameters().stream().filter(p -> AbstractNameValueBodyEditor.this.isEmptyParameter(p)).collect(Collectors.toList());
            emptyParams.stream().forEach(p -> AbstractNameValueBodyEditor.this.bodyContent.removeParameter(p));
            AbstractNameValueBodyEditor.this.updateButtonRemoveState();
            AbstractNameValueBodyEditor.this.tvParams.refresh();
        }
    }
}

