/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.editor;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.composer.components.impl.editors.SingleFileSelectionDialogCellEditor;
import com.kms.katalon.composer.components.impl.editors.StringComboBoxCellEditor;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.MediaTypes;
import com.kms.katalon.composer.webservice.editor.AbstractNameValueBodyEditor;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.entity.webservice.FormDataBodyParameter;
import com.kms.katalon.entity.webservice.ParameterizedBodyContent;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FormDataBodyEditor
extends AbstractNameValueBodyEditor<FormDataBodyParameter> {
    private static final String DEFAULT_CONTENT_TYPE = "multipart/form-data";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private boolean initialized = false;
    private TableColumn cName;
    private TableColumn cValue;
    private TableColumn cType;
    private TableColumn cContentType;

    public FormDataBodyEditor(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected AbstractNameValueBodyEditor.ParameterTable doCreateParameterTable(Composite parent) {
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        Composite tableComposite = new Composite(parent, 0);
        GridData gdData = new GridData(4, 4, true, true, 1, 1);
        gdData.heightHint = 150;
        tableComposite.setLayoutData((Object)gdData);
        tableComposite.setLayout((Layout)tableColumnLayout);
        final AbstractNameValueBodyEditor.ParameterTable tvParams = new AbstractNameValueBodyEditor.ParameterTable(this, tableComposite, 68354);
        tvParams.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        final Table tParams = tvParams.getTable();
        tParams.setHeaderVisible(true);
        tParams.setLinesVisible(ControlUtils.shouldLineVisble((Display)tParams.getDisplay()));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tvParams, (int)2);
        TableViewerColumn cvName = new TableViewerColumn((TableViewer)tvParams, 16384);
        this.cName = cvName.getColumn();
        this.cName.setText(ComposerWebserviceMessageConstants.FormDataBodyEditor_COL_NAME);
        cvName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((FormDataBodyParameter)element).getName();
            }
        });
        cvName.setEditingSupport(new EditingSupport(cvName.getViewer()){

            protected void setValue(Object element, Object value) {
                ((FormDataBodyParameter)element).setName(String.valueOf(value));
                tvParams.update(element, null);
                FormDataBodyEditor.this.fireModifyEvent();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)tParams);
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return ((FormDataBodyParameter)element).getName();
            }
        });
        TableViewerColumn cvType = new TableViewerColumn((TableViewer)tvParams, 16384);
        this.cType = cvType.getColumn();
        this.cType.setText(ComposerWebserviceMessageConstants.FormDataBodyEditor_COL_TYPE);
        cvType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((FormDataBodyParameter)element).getType();
            }
        });
        cvType.setEditingSupport(new EditingSupport(cvType.getViewer()){

            protected void setValue(Object element, Object value) {
                FormDataBodyParameter param = (FormDataBodyParameter)element;
                if (!param.getType().equals((String)value)) {
                    param.setValue("");
                }
                param.setType(String.valueOf(value));
                tvParams.update(element, null);
                FormDataBodyEditor.this.fireModifyEvent();
            }

            protected CellEditor getCellEditor(Object element) {
                return new StringComboBoxCellEditor((Composite)tParams, new String[]{"Text", "File"});
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return ((FormDataBodyParameter)element).getType();
            }
        });
        TableViewerColumn cvContentType = new TableViewerColumn((TableViewer)tvParams, 16384);
        this.cContentType = cvContentType.getColumn();
        this.cContentType.setText(ComposerWebserviceMessageConstants.FormDataBodyEditor_COL_CONTENT_TYPE);
        cvContentType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String contentType = ((FormDataBodyParameter)element).getContentType();
                if (StringUtils.isEmpty((CharSequence)contentType)) {
                    return ComposerWebserviceMessageConstants.FormDataBodyEditor_CONTENT_TYPE_AUTO;
                }
                return contentType;
            }

            public Color getForeground(Object element) {
                String contentType = ((FormDataBodyParameter)element).getContentType();
                if (StringUtils.isEmpty((CharSequence)contentType)) {
                    return Display.getCurrent().getSystemColor(15);
                }
                return super.getForeground(element);
            }
        });
        cvContentType.setEditingSupport(new EditingSupport(cvContentType.getViewer()){

            protected CellEditor getCellEditor(Object element) {
                return new ContentTypeValueCellEditor(FormDataBodyEditor.this, (Composite)tParams){

                    @Override
                    protected String getMessage() {
                        return ComposerWebserviceMessageConstants.FormDataBodyEditor_CONTENT_TYPE_AUTO;
                    }
                };
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return ((FormDataBodyParameter)element).getContentType();
            }

            protected void setValue(Object element, Object value) {
                String contentType = (String)value;
                ((FormDataBodyParameter)element).setContentType(contentType);
                tvParams.update(element, null);
                FormDataBodyEditor.this.fireModifyEvent();
            }
        });
        TableViewerColumn cvValue = new TableViewerColumn((TableViewer)tvParams, 16384);
        this.cValue = cvValue.getColumn();
        this.cValue.setText(ComposerWebserviceMessageConstants.FormDataBodyEditor_COL_VALUE);
        cvValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((FormDataBodyParameter)element).getValue();
            }
        });
        cvValue.setEditingSupport(new EditingSupport(cvValue.getViewer()){

            protected void setValue(Object element, Object value) {
                String filePath = (String)value;
                filePath = FormDataBodyEditor.this.convertToRelativePathIfPossible(filePath);
                ((FormDataBodyParameter)element).setValue(String.valueOf(filePath));
                tvParams.update(element, null);
                FormDataBodyEditor.this.fireModifyEvent();
            }

            protected CellEditor getCellEditor(Object element) {
                FormDataBodyParameter param = (FormDataBodyParameter)element;
                if (param.getType().equals("Text")) {
                    return new TextCellEditor((Composite)tParams);
                }
                return new SingleFileSelectionDialogCellEditor((Composite)tParams);
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return ((FormDataBodyParameter)element).getValue();
            }
        });
        tableColumnLayout.setColumnData((Widget)this.cName, (ColumnLayoutData)new ColumnWeightData(30, 100));
        tableColumnLayout.setColumnData((Widget)this.cValue, (ColumnLayoutData)new ColumnWeightData(30, 100));
        tableColumnLayout.setColumnData((Widget)this.cType, (ColumnLayoutData)new ColumnWeightData(20, 100));
        tableColumnLayout.setColumnData((Widget)this.cContentType, (ColumnLayoutData)new ColumnWeightData(20, 100));
        return tvParams;
    }

    private String convertToRelativePathIfPossible(String filePath) {
        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        File file = new File(filePath);
        if (file.isAbsolute() && file.getAbsolutePath().startsWith(projectDir)) {
            return PathUtil.absoluteToRelativePath((String)filePath, (String)projectDir);
        }
        return filePath;
    }

    @Override
    protected FormDataBodyParameter createEmptyParameter() {
        FormDataBodyParameter param = new FormDataBodyParameter();
        param.setName("");
        param.setType("Text");
        param.setContentType("");
        param.setValue("");
        return param;
    }

    @Override
    protected boolean isEmptyParameter(FormDataBodyParameter parameter) {
        return StringUtils.isBlank((CharSequence)parameter.getName()) && StringUtils.isBlank((CharSequence)parameter.getValue());
    }

    @Override
    public void setInput(String httpBodyContent) {
        if (StringUtils.isEmpty((CharSequence)httpBodyContent)) {
            this.bodyContent = new ParameterizedBodyContent();
            this.bodyContent.setContentType(DEFAULT_CONTENT_TYPE);
            this.bodyContent.setCharset(DEFAULT_CHARSET);
        } else {
            this.bodyContent = (ParameterizedBodyContent)JsonUtil.fromJson((String)httpBodyContent, (Type)new TypeToken<ParameterizedBodyContent<FormDataBodyParameter>>(){}.getType());
        }
        this.tvParams.setInput(this.bodyContent.getParameters());
        if (!this.bodyContent.getParameters().isEmpty()) {
            this.btnRemove.setEnabled(true);
        }
        this.updateViewModel();
    }

    @Override
    public void onBodyTypeChanged() {
        if (this.bodyContent == null) {
            this.bodyContent = new ParameterizedBodyContent();
            this.bodyContent.setContentType(DEFAULT_CONTENT_TYPE);
            this.bodyContent.setCharset(DEFAULT_CHARSET);
        }
        if (!this.initialized) {
            this.tvParams.setInput(this.bodyContent.getParameters());
            if (!this.bodyContent.getParameters().isEmpty()) {
                this.btnRemove.setEnabled(true);
            }
            this.initialized = true;
        }
        this.updateViewModel();
        this.setContentTypeUpdated(true);
    }

    private class ContentTypeValueCellEditor
    extends StringComboBoxCellEditor {
        public ContentTypeValueCellEditor(Composite parent) {
            super(parent, MediaTypes.PREDEFINED_MEDIA_TYPES);
            this.setMessage(this.getMessage());
        }

        private void setMessage(String message) {
            CCombo combo = (CCombo)this.getControl();
            try {
                Field textField = combo.getClass().getDeclaredField("text");
                textField.setAccessible(true);
                if (textField != null) {
                    Text text = (Text)textField.get(combo);
                    text.setMessage(message);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }

        protected String getMessage() {
            return "";
        }
    }
}

