/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.importing.model;

import com.kms.katalon.composer.webservice.importing.model.RestParameterImportResult;
import com.kms.katalon.composer.webservice.importing.model.WebServiceImportNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class RestResourceImportNode
extends WebServiceImportNode {
    protected List<RestParameterImportResult> parameters = new ArrayList<RestParameterImportResult>();

    public RestParameterImportResult addNewParameter(String name) {
        RestParameterImportResult parameter = new RestParameterImportResult();
        parameter.setName(name);
        this.parameters.add(parameter);
        return parameter;
    }

    public boolean hasParameter(String name) {
        return this.getParameterIndex(name) != -1;
    }

    public RestParameterImportResult getParameter(String name) {
        int idx = this.getParameterIndex(name);
        if (idx != -1) {
            return this.parameters.get(idx);
        }
        return null;
    }

    public List<RestParameterImportResult> getQueryParameters() {
        return this.getParametersWithStyle(RestParameterImportResult.Style.QUERY);
    }

    public List<RestParameterImportResult> getHeaderParameters() {
        return this.getParametersWithStyle(RestParameterImportResult.Style.HEADER);
    }

    public List<RestParameterImportResult> getTemplateParameters() {
        return this.getParametersWithStyle(RestParameterImportResult.Style.TEMPLATE);
    }

    public List<RestParameterImportResult> getParametersWithStyle(RestParameterImportResult.Style style) {
        List parameterList = this.parameters.stream().filter(p -> p.getStyle() == style).collect(Collectors.toList());
        return Collections.unmodifiableList(parameterList);
    }

    public List<RestParameterImportResult> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    private int getParameterIndex(String name) {
        int idx = 0;
        while (idx < this.parameters.size()) {
            if (name.equals(this.parameters.get(idx).getName())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }
}

