/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.parser;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiSpecParser {
    private static final Logger logger = LoggerFactory.getLogger(OpenApiSpecParser.class);

    public List<String> parseApiPaths(String openApiSpecFilePath) {
        ArrayList<String> paths = new ArrayList<String>();
        try {
            OpenAPIV3Parser parser = new OpenAPIV3Parser();
            ParseOptions options = new ParseOptions();
            options.setResolveFully(true);
            options.setResolve(true);
            SwaggerParseResult result = parser.readLocation(openApiSpecFilePath, null, options);
            OpenAPI openAPI = result.getOpenAPI();
            if (openAPI != null && openAPI.getPaths() != null) {
                Paths pathsObj = openAPI.getPaths();
                for (String pathKey : pathsObj.keySet()) {
                    paths.add(pathKey);
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to parse OpenAPI specification for paths", (Throwable)e);
        }
        return paths;
    }

    public List<String> parseHttpMethods(String openApiSpecFilePath) {
        HashSet<String> methods = new HashSet<String>();
        try {
            OpenAPI openAPI = this.parseOpenApiSpec(openApiSpecFilePath);
            if (openAPI != null && openAPI.getPaths() != null) {
                this.extractHttpMethodsFromPaths(openAPI.getPaths(), methods);
            } else if (openAPI != null) {
                logger.warn("No paths found in OpenAPI specification: {}", (Object)openApiSpecFilePath);
            }
        }
        catch (Exception e) {
            logger.error("Failed to parse OpenAPI specification for HTTP methods", (Throwable)e);
        }
        return this.getSortedMethodsList(methods);
    }

    public String parseServerUrl(String openApiSpecFilePath) {
        try {
            OpenAPI openAPI = this.parseOpenApiSpec(openApiSpecFilePath);
            return this.extractServerUrl(openAPI);
        }
        catch (Exception e) {
            logger.error("Failed to parse OpenAPI specification for server URL", (Throwable)e);
            return null;
        }
    }

    private String extractServerUrl(OpenAPI openAPI) {
        if (openAPI == null || openAPI.getServers() == null || openAPI.getServers().isEmpty()) {
            return null;
        }
        Server server = (Server)openAPI.getServers().get(0);
        String url = server.getUrl();
        return this.replaceServerVariables(url, server.getVariables());
    }

    private String replaceServerVariables(String url, ServerVariables serverVariables) {
        if (serverVariables == null || url == null) {
            return url;
        }
        String result = url;
        for (Map.Entry entry : serverVariables.entrySet()) {
            result = this.replaceVariable(result, (String)entry.getKey(), (ServerVariable)entry.getValue());
        }
        return result;
    }

    private String replaceVariable(String url, String variable, ServerVariable variableObj) {
        if (variableObj == null) {
            return url;
        }
        String defaultValue = variableObj.getDefault();
        if (defaultValue == null) {
            return url;
        }
        String variableTemplate = "{" + variable + "}";
        if (url.contains(variableTemplate)) {
            return url.replace(variableTemplate, defaultValue);
        }
        return url;
    }

    public OpenAPI parseOpenApiSpec(String openApiSpecFilePath) {
        SwaggerParseResult result;
        block4: {
            try {
                OpenAPIV3Parser parser = new OpenAPIV3Parser();
                ParseOptions options = new ParseOptions();
                options.setResolveFully(true);
                options.setResolve(true);
                result = parser.readLocation(openApiSpecFilePath, null, options);
                if (result != null) break block4;
                logger.warn("Failed to parse OpenAPI spec - result is null: {}", (Object)openApiSpecFilePath);
                return null;
            }
            catch (Exception e) {
                logger.error("Error parsing OpenAPI specification: " + openApiSpecFilePath, (Throwable)e);
                return null;
            }
        }
        OpenAPI openAPI = result.getOpenAPI();
        if (openAPI == null) {
            logger.warn("Failed to parse OpenAPI spec - OpenAPI object is null: {}", (Object)openApiSpecFilePath);
        }
        return openAPI;
    }

    public String parseTitle(String openApiSpecFilePath) {
        try {
            OpenAPI openAPI = this.parseOpenApiSpec(openApiSpecFilePath);
            if (openAPI != null && openAPI.getInfo() != null) {
                return openAPI.getInfo().getTitle();
            }
        }
        catch (Exception e) {
            logger.error("Failed to parse OpenAPI specification title: " + openApiSpecFilePath, (Throwable)e);
        }
        return null;
    }

    public void extractHttpMethodsFromPaths(Paths pathsObj, Set<String> methods) {
        if (pathsObj == null) {
            logger.debug("Paths object is null, skipping HTTP method extraction");
            return;
        }
        for (PathItem pathItem : pathsObj.values()) {
            if (pathItem == null) continue;
            this.extractMethodsFromPathItem(pathItem, methods);
        }
    }

    public void extractMethodsFromPathItem(PathItem pathItem, Set<String> methods) {
        Map<String, Supplier<Operation>> operations = Map.of("GET", () -> ((PathItem)pathItem).getGet(), "POST", () -> ((PathItem)pathItem).getPost(), "PUT", () -> ((PathItem)pathItem).getPut(), "DELETE", () -> ((PathItem)pathItem).getDelete(), "PATCH", () -> ((PathItem)pathItem).getPatch(), "HEAD", () -> ((PathItem)pathItem).getHead(), "OPTIONS", () -> ((PathItem)pathItem).getOptions(), "TRACE", () -> ((PathItem)pathItem).getTrace());
        operations.forEach((method, opSupplier) -> {
            if (opSupplier.get() != null) {
                methods.add((String)method);
            }
        });
    }

    public List<String> getSortedMethodsList(Set<String> methods) {
        ArrayList<String> sortedMethods = new ArrayList<String>(methods);
        Collections.sort(sortedMethods);
        return sortedMethods;
    }
}

