/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.parts;

import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.webservice.preferences.AiTestingPreferencesManager;
import com.kms.katalon.composer.webservice.report.ApiAiTestReportGenerator;
import com.kms.katalon.composer.webservice.report.TestResultStatisticsCalculator;
import com.kms.katalon.composer.webservice.view.ApiCollectionGenerateTestUI;
import com.kms.katalon.composer.webservice.viewmodel.AiTestingPreferences;
import com.kms.katalon.composer.webservice.viewmodel.ApiCollectionExecutionSummary;
import com.kms.katalon.composer.webservice.viewmodel.TestResultRun;
import com.kms.katalon.composer.webservice.viewmodel.TestResultStatistics;
import com.kms.katalon.core.testobject.authorization.BasicRequestAuthorization;
import com.kms.katalon.entity.folder.ApiCollectionEntity;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.validator.routines.UrlValidator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiCollectionGenerateTestPart {
    private static final Logger logger = LoggerFactory.getLogger(ApiCollectionGenerateTestPart.class);
    private static final int EXIT_CODE_INVALID_INPUT_ERROR = 191;
    private static final int EXIT_CODE_UNEXPECTED_EXECUTION_ERROR = 192;
    private static final int EXIT_CODE_GENERAL_ERROR = 1;
    private static final String DEFAULT_CONFIG_ID = "config-1";
    private static final String DEFAULT_CONFIG_NAME = "AI Testing Preferences";
    private static final String DIALOG_TITLE_INVALID_SERVER_URL = "Invalid Server URL";
    private static final String MESSAGE_SERVER_URL_INVALID = "Provided server url is invalid";
    private final ApiCollectionGenerateTestUI ui;
    private final ApiCollectionEntity apiCollectionEntity;
    private final String openApiSpecFilePath;
    private final AiTestingPreferencesManager preferencesManager;
    private final TestResultStatisticsCalculator statisticsCalculator;
    private static final UrlValidator URL_VALIDATOR = new UrlValidator(new String[]{"http", "https"}, 8L);
    private static final Pattern COMMAND_INJECTION_PATTERN = Pattern.compile("[;&|`$\\x00-\\x1F\\x7F()<>\\[\\]{}\\\\*?!#'\"]");

    public ApiCollectionGenerateTestPart(ApiCollectionGenerateTestUI ui, ApiCollectionEntity apiCollectionEntity, String openApiSpecFilePath) {
        this.ui = Objects.requireNonNull(ui, "UI cannot be null");
        this.apiCollectionEntity = Objects.requireNonNull(apiCollectionEntity, "API collection entity cannot be null");
        this.openApiSpecFilePath = openApiSpecFilePath;
        this.preferencesManager = new AiTestingPreferencesManager();
        this.statisticsCalculator = new TestResultStatisticsCalculator();
    }

    public void registerButtonListener() {
        Button btnGenerateTest = this.ui.getBtnGenerateTest();
        if (btnGenerateTest != null) {
            btnGenerateTest.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ApiCollectionGenerateTestPart.this.runAiTestCases();
                }
            });
        }
    }

    public BasicRequestAuthorization getAuthorization() {
        return this.apiCollectionEntity.getAuthorization();
    }

    private void runAiTestCases() {
        try {
            List<String> selectedTestTypes = this.ui.getSelectedTestTypes();
            List<String> selectedApiPaths = this.ui.getSelectedApiPaths();
            List<String> selectedHttpMethods = this.ui.getSelectedHttpMethods();
            String serverUrl = this.ui.getServerUrl();
            if (!this.validateServerUrl(serverUrl)) {
                return;
            }
            this.savePreferences();
            ApiAiTestReportGenerator reportGenerator = new ApiAiTestReportGenerator(this.apiCollectionEntity, this.openApiSpecFilePath);
            ProgressMonitorDialogWithThread progress = this.createProgressDialog();
            progress.setOpenOnRun(true);
            this.runProgress(progress, reportGenerator, serverUrl, selectedTestTypes, selectedApiPaths, selectedHttpMethods);
        }
        catch (InvocationTargetException e) {
            logger.error("Failed to run AI tests", (Throwable)e);
            String errorMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("Failed to run AI tests: " + errorMessage));
        }
        catch (InterruptedException interruptedException) {
            logger.info("Test execution was cancelled by user");
            Thread.currentThread().interrupt();
        }
    }

    private boolean validateServerUrl(String serverUrl) {
        if (serverUrl == null || serverUrl.isBlank()) {
            this.showErrorDialog("Please provide a server URL");
            return false;
        }
        if (!URL_VALIDATOR.isValid(serverUrl)) {
            this.showErrorDialog("Invalid server URL format");
            return false;
        }
        if (COMMAND_INJECTION_PATTERN.matcher(serverUrl).find()) {
            this.showErrorDialog("URL contains invalid characters");
            return false;
        }
        return true;
    }

    private void showErrorDialog(String message) {
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)DIALOG_TITLE_INVALID_SERVER_URL, (String)message);
    }

    private ProgressMonitorDialogWithThread createProgressDialog() {
        return new ProgressMonitorDialogWithThread(Display.getCurrent().getActiveShell()){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText("Generating Test");
            }
        };
    }

    private void runProgress(ProgressMonitorDialogWithThread progress, final ApiAiTestReportGenerator reportGenerator, final String serverUrl, final List<String> selectedTestTypes, final List<String> selectedApiPaths, final List<String> selectedHttpMethods) throws InvocationTargetException, InterruptedException {
        progress.run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    monitor.beginTask("Generating AI test cases...", -1);
                    if (monitor.isCanceled()) {
                        return;
                    }
                    try {
                        BasicRequestAuthorization auth = ApiCollectionGenerateTestPart.this.getAuthorization();
                        Map<String, Button> httpMethodCheckboxes = ApiCollectionGenerateTestPart.this.ui.getHttpMethodCheckboxes();
                        Map<String, String> allHttpMethodsMap = httpMethodCheckboxes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)entry.getKey()));
                        int exitCode = reportGenerator.executeAiTests(monitor, serverUrl, selectedTestTypes, selectedApiPaths, selectedHttpMethods, auth, allHttpMethodsMap);
                        if (ApiCollectionGenerateTestPart.this.isErrorExitCode(exitCode)) {
                            ApiCollectionGenerateTestPart.this.handleTestGenerationFailure(exitCode);
                        } else {
                            ApiCollectionGenerateTestPart.this.handleTestGenerationSuccess(reportGenerator);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error during test execution", (Throwable)e);
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    private boolean isErrorExitCode(int exitCode) {
        return exitCode == 191 || exitCode == 192 || exitCode == 1;
    }

    private void handleTestGenerationFailure(int exitCode) {
        String errorMessage = exitCode == 1 ? "Test generation cancelled by user" : "Test generation failed. Please check the configuration and try again.";
        logger.error("AI test generation failed with exit code: {}", (Object)exitCode);
        Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Test Generation Failed", (String)errorMessage));
    }

    private void handleTestGenerationSuccess(ApiAiTestReportGenerator reportGenerator) {
        this.parseAndUpdateTestResults(reportGenerator);
        Display.getDefault().asyncExec(() -> {
            Button btnGenerateTest = this.ui.getBtnGenerateTest();
            if (btnGenerateTest != null && !btnGenerateTest.isDisposed()) {
                this.ui.scrollToOpenReportButton();
            }
        });
    }

    private void parseAndUpdateTestResults(ApiAiTestReportGenerator reportGenerator) {
        try {
            ApiCollectionExecutionSummary executionSummary = reportGenerator.parseExecutionSummaryWithReportGeneration();
            if (executionSummary == null) {
                logger.warn("Failed to parse execution summary");
                return;
            }
            TestResultStatistics statistics = this.statisticsCalculator.calculateStatistics(executionSummary);
            if (statistics == null) {
                logger.warn("Failed to calculate test statistics");
                return;
            }
            String reportFolder = reportGenerator.getCatsReportFolderPath();
            String htmlReportPath = reportFolder != null ? reportFolder + File.separator + "ai_test_report.html" : null;
            this.preferencesManager.saveTestResults(this.apiCollectionEntity, executionSummary, statistics, htmlReportPath);
            this.updateStatisticsInUI(statistics);
        }
        catch (Exception e) {
            logger.error("Failed to parse AI summary report JSON", (Throwable)e);
        }
    }

    private void updateStatisticsInUI(TestResultStatistics statistics) {
        Display.getDefault().asyncExec(() -> this.ui.updateTestResultLabels(statistics.totalTests(), statistics.passedTests(), statistics.failedTests(), statistics.warningsTests(), statistics.passedPositive(), statistics.passedNegative(), statistics.passedSecurity(), statistics.passedEdgeCase(), statistics.failedPositive(), statistics.failedNegative(), statistics.failedSecurity(), statistics.failedEdgeCase(), statistics.warningsPositive(), statistics.warningsNegative(), statistics.warningsSecurity(), statistics.warningsEdgeCase()));
    }

    public void savePreferences() {
        AiTestingPreferences preferences = new AiTestingPreferences(DEFAULT_CONFIG_ID, DEFAULT_CONFIG_NAME, this.ui.getServerUrl(), this.ui.getSelectedTestTypes(), this.ui.getSelectedApiPaths(), this.ui.getSelectedHttpMethods());
        this.preferencesManager.savePreferences(this.apiCollectionEntity, preferences);
    }

    public void loadPreferences() {
        AiTestingPreferences preferences = this.preferencesManager.loadPreferences(this.apiCollectionEntity);
        if (preferences != null) {
            this.ui.applyPreferences(preferences);
        }
    }

    public void loadAndDisplayTestResults() {
        TestResultRun latestResult = this.preferencesManager.loadLatestTestResult(this.apiCollectionEntity);
        if (latestResult == null) {
            logger.info("No test results available to display");
            return;
        }
        TestResultStatistics statistics = latestResult.statistics();
        this.updateStatisticsInUI(statistics);
        logger.info("Loaded and displayed test results from run: {}", (Object)latestResult.runId());
    }
}

