/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.parts;

import com.kms.katalon.composer.components.controls.HelpToolBarForMPart;
import com.kms.katalon.composer.components.impl.control.CTreeViewer;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.webservice.constants.ImageConstants;
import com.kms.katalon.composer.webservice.handlers.IRequestHistoryListener;
import com.kms.katalon.composer.webservice.handlers.OpenWebServiceRequestObjectHandler;
import com.kms.katalon.composer.webservice.handlers.RequestHistoryHandler;
import com.kms.katalon.composer.webservice.handlers.SaveDraftRequestHandler;
import com.kms.katalon.composer.webservice.parts.tree.IRequestHistoryItem;
import com.kms.katalon.composer.webservice.parts.tree.RequestDateTreeItem;
import com.kms.katalon.composer.webservice.parts.tree.RequestHistoryStyleCellProvider;
import com.kms.katalon.composer.webservice.parts.tree.RequestHistoryTreeItem;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.entity.webservice.RequestHistoryEntity;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.DateTimes;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class RequestHistoryPart
implements IRequestHistoryListener {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    IEclipseContext context;
    private CTreeViewer treeViewer;
    private HistoryRequestContentProvider contentProvider;
    private RequestHistoryHandler requestHistoryHandler;
    private ToolItem imgBtnSave;
    private ToolItem imgBtnDelete;

    @PostConstruct
    public void createPart(MPart mpart, Composite parent) {
        this.requestHistoryHandler = (RequestHistoryHandler)this.context.get(RequestHistoryHandler.class);
        this.createControl(parent);
        this.registerEventBroker();
        new HelpToolBarForMPart(mpart, DocumentationMessageConstants.REQUEST_HISTORY);
    }

    private void registerEventBroker() {
        this.requestHistoryHandler.setListener(this);
    }

    private void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout glContainer = new GridLayout();
        glContainer.marginWidth = 0;
        glContainer.marginHeight = 0;
        container.setLayout((Layout)glContainer);
        container.setBackground(ColorUtil.getWhiteBackgroundColor());
        Composite headerComposite = new Composite(container, 0);
        headerComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        headerComposite.setLayout((Layout)new GridLayout(2, false));
        Label lblRequestHistoryTitle = new Label(headerComposite, 0);
        lblRequestHistoryTitle.setText("History");
        lblRequestHistoryTitle.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ControlUtils.setFontToBeBold((Control)lblRequestHistoryTitle);
        ToolBar buttonsComposite = new ToolBar(headerComposite, 0x800040);
        buttonsComposite.setForeground(ColorUtil.getToolBarForegroundColor());
        buttonsComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        buttonsComposite.setLayout((Layout)new GridLayout(2, false));
        this.imgBtnSave = new ToolItem(buttonsComposite, 8);
        this.imgBtnSave.setImage(ImageConstants.IMG_16_SAVE);
        this.imgBtnSave.setText("Save");
        this.imgBtnSave.setEnabled(false);
        this.imgBtnDelete = new ToolItem(buttonsComposite, 8);
        this.imgBtnDelete.setImage(ImageConstants.IMG_16_DELETE);
        this.imgBtnDelete.setText("Remove");
        this.imgBtnDelete.setEnabled(false);
        Label lblHorizontalSeparator = new Label(container, 258);
        lblHorizontalSeparator.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite treeComposite = new Composite(container, 0);
        treeComposite.setLayoutData((Object)new GridData(1808));
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        treeComposite.setLayout((Layout)treeLayout);
        this.treeViewer = new CTreeViewer(treeComposite, 2);
        TreeViewerColumn tvcItem = new TreeViewerColumn((TreeViewer)this.treeViewer, 0);
        tvcItem.setLabelProvider((CellLabelProvider)new RequestHistoryStyleCellProvider());
        treeLayout.setColumnData((Widget)tvcItem.getColumn(), (ColumnLayoutData)new ColumnWeightData(98, 150));
        this.contentProvider = new HistoryRequestContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.enableTooltipSupport();
        this.reloadTreeData();
        this.treeViewer.expandAll();
        this.registerEventListeners();
    }

    private void reloadTreeData() {
        this.treeViewer.getTree().setRedraw(false);
        Object[] expandedElements = this.treeViewer.getExpandedElements();
        this.treeViewer.setInput(this.requestHistoryHandler.getRequestHistoryEntities(ProjectController.getInstance().getCurrentProject()));
        ArrayList<RequestDateTreeItem> expandedDateItems = new ArrayList<RequestDateTreeItem>();
        Object[] objectArray = expandedElements;
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            RequestDateTreeItem dateItem;
            RequestDateTreeItem newDateItem;
            Object e = objectArray[n2];
            if (e instanceof RequestDateTreeItem && (newDateItem = this.contentProvider.findElementByDate((dateItem = (RequestDateTreeItem)e).getDate())) != null) {
                expandedDateItems.add(newDateItem);
            }
            ++n2;
        }
        if (expandedDateItems.size() > 0) {
            this.treeViewer.setExpandedElements(expandedDateItems.toArray());
        }
        this.treeViewer.getTree().setRedraw(true);
    }

    private void registerEventListeners() {
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IRequestHistoryItem selectedItem = (IRequestHistoryItem)RequestHistoryPart.this.treeViewer.getStructuredSelection().getFirstElement();
                if (selectedItem instanceof RequestDateTreeItem) {
                    RequestHistoryPart.this.treeViewer.setExpandedState((Object)selectedItem, !RequestHistoryPart.this.treeViewer.getExpandedState((Object)selectedItem));
                } else if (selectedItem instanceof RequestHistoryTreeItem) {
                    RequestHistoryTreeItem treeItem = (RequestHistoryTreeItem)selectedItem;
                    ((OpenWebServiceRequestObjectHandler)RequestHistoryPart.this.context.get(OpenWebServiceRequestObjectHandler.class)).openRequestHistoryObject(treeItem.getRequestHistoryEntity());
                }
            }
        });
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITreeSelection structuredSelection = RequestHistoryPart.this.treeViewer.getStructuredSelection();
                if (structuredSelection == null || structuredSelection.isEmpty()) {
                    RequestHistoryPart.this.imgBtnSave.setEnabled(false);
                    RequestHistoryPart.this.imgBtnDelete.setEnabled(false);
                    return;
                }
                RequestHistoryPart.this.imgBtnDelete.setEnabled(true);
                RequestHistoryPart.this.imgBtnSave.setEnabled(structuredSelection.size() == 1 && structuredSelection.getFirstElement() instanceof RequestHistoryTreeItem);
            }
        });
        this.imgBtnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITreeSelection structuredSelection = RequestHistoryPart.this.treeViewer.getStructuredSelection();
                if (structuredSelection == null || structuredSelection.isEmpty() || structuredSelection.size() != 1 || !(structuredSelection.getFirstElement() instanceof RequestHistoryTreeItem)) {
                    return;
                }
                RequestHistoryTreeItem selectedTreeItem = (RequestHistoryTreeItem)structuredSelection.getFirstElement();
                SaveDraftRequestHandler.saveDraftRequest(RequestHistoryPart.this.imgBtnSave.getDisplay().getActiveShell(), selectedTreeItem.getRequestHistoryEntity().getRequest());
            }
        });
        this.imgBtnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trackings.trackClickDeletingDraftRequest();
                ITreeSelection structuredSelection = RequestHistoryPart.this.treeViewer.getStructuredSelection();
                if (structuredSelection == null || structuredSelection.isEmpty()) {
                    return;
                }
                HashSet<RequestHistoryEntity> removedEntities = new HashSet<RequestHistoryEntity>();
                Object[] objectArray = structuredSelection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RequestHistoryTreeItem) {
                        RequestHistoryTreeItem requestHistoryTreeItem = (RequestHistoryTreeItem)obj;
                        removedEntities.add(requestHistoryTreeItem.getRequestHistoryEntity());
                    } else if (obj instanceof RequestDateTreeItem) {
                        for (RequestHistoryTreeItem item : ((RequestDateTreeItem)obj).getItems()) {
                            removedEntities.add(item.getRequestHistoryEntity());
                        }
                    }
                    ++n2;
                }
                if (removedEntities.isEmpty()) {
                    return;
                }
                try {
                    RequestHistoryPart.this.imgBtnSave.setEnabled(false);
                    RequestHistoryPart.this.imgBtnDelete.setEnabled(false);
                    RequestHistoryPart.this.requestHistoryHandler.removeRequestHistories(new ArrayList<RequestHistoryEntity>(removedEntities), ProjectController.getInstance().getCurrentProject());
                    Trackings.trackDeleteDraftRequest((int)removedEntities.size());
                }
                catch (IOException ex) {
                    MultiStatusErrorDialog.showErrorDialog((String)"Unable to remove selected items", (String)ex.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)ex));
                    LoggerSingleton.logError((Throwable)ex);
                }
            }
        });
    }

    @Override
    public void addHistoryRequest(RequestHistoryEntity addedRequest) {
        if (this.treeViewer == null || this.treeViewer.getTree() == null || this.treeViewer.getTree().isDisposed()) {
            return;
        }
        this.reloadTreeData();
        RequestDateTreeItem dateItem = this.contentProvider.findElementByDate(addedRequest.getReceivedResponseTime());
        RequestHistoryTreeItem historyItem = new RequestHistoryTreeItem(addedRequest, dateItem);
        this.treeViewer.refresh((Object)dateItem);
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)historyItem));
        Event event = new Event();
        this.treeViewer.getTree().notifyListeners(13, event);
    }

    @Override
    public void removeHistoryRequests(List<RequestHistoryEntity> removedEntities) {
        this.reloadTreeData();
    }

    @Override
    public void resetInput() {
        if (this.treeViewer.getTree().isDisposed()) {
            return;
        }
        this.reloadTreeData();
    }

    private class HistoryRequestContentProvider
    implements ITreeContentProvider {
        private List<RequestDateTreeItem> elements;

        private HistoryRequestContentProvider() {
        }

        private RequestDateTreeItem findElementByDate(Date date) {
            long firstTimeOfDate = DateTimes.toFirstDate((Date)date).getTime();
            for (RequestDateTreeItem e : this.elements) {
                RequestDateTreeItem dateItem = e;
                if (!dateItem.getDate().equals(new Date(firstTimeOfDate))) continue;
                return dateItem;
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List requestHistoryEntity = (List)inputElement;
                HashMap requestHistoryPerDate = new HashMap();
                requestHistoryEntity.stream().forEach(req -> {
                    long firstTimeOfDate = DateTimes.toFirstDate((Date)req.getReceivedResponseTime()).getTime();
                    ArrayList<RequestHistoryEntity> requestInADay = new ArrayList<RequestHistoryEntity>();
                    if (requestHistoryPerDate.containsKey(firstTimeOfDate)) {
                        requestInADay.addAll((Collection)requestHistoryPerDate.get(firstTimeOfDate));
                    }
                    requestInADay.add((RequestHistoryEntity)req);
                    requestHistoryPerDate.put(firstTimeOfDate, requestInADay);
                });
                List items = requestHistoryPerDate.entrySet().stream().map(e -> {
                    RequestDateTreeItem dateTreeItem = new RequestDateTreeItem(new Date((Long)e.getKey()));
                    List<RequestHistoryTreeItem> chilren = ((List)e.getValue()).stream().map(historyEntity -> new RequestHistoryTreeItem((RequestHistoryEntity)historyEntity, dateTreeItem)).sorted(new Comparator<RequestHistoryTreeItem>(){

                        @Override
                        public int compare(RequestHistoryTreeItem dateItem, RequestHistoryTreeItem dateItem2) {
                            return dateItem.getRequestHistoryEntity().getReceivedResponseTime().before(dateItem2.getRequestHistoryEntity().getReceivedResponseTime()) ? 1 : -1;
                        }
                    }).collect(Collectors.toList());
                    dateTreeItem.setItems(chilren);
                    return dateTreeItem;
                }).sorted(new Comparator<RequestDateTreeItem>(){

                    @Override
                    public int compare(RequestDateTreeItem dateItem, RequestDateTreeItem dateItem2) {
                        return dateItem.getDate().before(dateItem2.getDate()) ? 1 : -1;
                    }
                }).collect(Collectors.toList());
                this.elements = items;
                return this.elements.toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IRequestHistoryItem) {
                IRequestHistoryItem requestDate = (IRequestHistoryItem)parentElement;
                return requestDate.getChildren().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IRequestHistoryItem) {
                return ((IRequestHistoryItem)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IRequestHistoryItem) {
                return ((IRequestHistoryItem)element).hasChildren();
            }
            return false;
        }
    }
}

