/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.postman;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.kms.katalon.composer.webservice.postman.Auth;
import com.kms.katalon.composer.webservice.postman.AuthParameter;
import com.kms.katalon.core.testobject.authorization.BasicRequestAuthorization;
import com.kms.katalon.core.testobject.authorization.DigestAlgorithmDirective;
import com.kms.katalon.core.testobject.authorization.DigestAuthorization;
import com.kms.katalon.core.testobject.authorization.DigestQualityOfProtectionDirective;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DigestAuth
extends Auth {
    private static final String OPAQUE = "opaque";
    private static final String REALM = "realm";
    private static final String NONCE = "nonce";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String ALGORITHM = "algorithm";
    private static final String QOP = "qop";
    private static final String NONCE_COUNT = "nonceCount";
    private static final String CLIENT_NONCE = "clientNonce";
    @JsonProperty(value="digest")
    List<AuthParameter> digest = new ArrayList<AuthParameter>();

    public List<AuthParameter> getDigest() {
        return this.digest;
    }

    public void setDigest(List<AuthParameter> digest) {
        this.digest = digest;
    }

    public DigestAuth() {
        super("digest");
    }

    @Override
    public BasicRequestAuthorization toRequestAuthorization() throws UnsupportedEncodingException, GeneralSecurityException {
        List<AuthParameter> digestItems = this.getDigest();
        HashMap authorizationInfo = new HashMap();
        digestItems.forEach(item -> {
            if (item.getKey() != null && item.getValue() != null) {
                authorizationInfo.put(item.getKey(), item.getValueAsString());
            }
        });
        String username = authorizationInfo.getOrDefault(USERNAME, "");
        String password = authorizationInfo.getOrDefault(PASSWORD, "");
        String realm = authorizationInfo.getOrDefault(REALM, "");
        String nonce = authorizationInfo.getOrDefault(NONCE, "");
        String opaque = authorizationInfo.getOrDefault(OPAQUE, "");
        String algorithm = authorizationInfo.getOrDefault(ALGORITHM, "");
        String qop = authorizationInfo.getOrDefault(QOP, "");
        String nonceCount = authorizationInfo.getOrDefault(NONCE_COUNT, "");
        String clientNonce = authorizationInfo.getOrDefault(CLIENT_NONCE, "");
        try {
            return new DigestAuthorization(username, password, realm, nonce, DigestAlgorithmDirective.fromString((String)algorithm), DigestQualityOfProtectionDirective.fromString((String)qop), nonceCount, clientNonce, opaque);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("Invalid Digest Authorization parameters", (Throwable)e);
            throw new UnsupportedOperationException("Invalid Digest Authorization parameters", e);
        }
        catch (Exception e) {
            this.logger.error("Error creating Digest Authorization", (Throwable)e);
            throw new UnsupportedOperationException("Error creating Digest Authorization", e);
        }
    }
}

