/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.postman;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.kms.katalon.composer.webservice.postman.Auth;
import com.kms.katalon.composer.webservice.postman.AuthParameter;
import com.kms.katalon.core.testobject.authorization.BasicRequestAuthorization;
import com.kms.katalon.core.testobject.authorization.NTLMAuthorization;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NTLMAuth
extends Auth {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String DOMAIN = "domain";
    private static final String WORKSTATION = "workstation";
    @JsonProperty(value="ntlm")
    List<AuthParameter> ntlm = new ArrayList<AuthParameter>();

    public List<AuthParameter> getNtlm() {
        return this.ntlm;
    }

    public void setNtlm(List<AuthParameter> ntlm) {
        this.ntlm = ntlm;
    }

    public NTLMAuth() {
        super("ntlm");
    }

    @Override
    public BasicRequestAuthorization toRequestAuthorization() throws UnsupportedEncodingException, GeneralSecurityException {
        List<AuthParameter> ntlmItems = this.getNtlm();
        HashMap authorizationInfo = new HashMap();
        ntlmItems.forEach(item -> {
            if (item.getKey() != null && item.getValue() != null) {
                authorizationInfo.put(item.getKey(), item.getValueAsString());
            }
        });
        String username = authorizationInfo.getOrDefault(USERNAME, "");
        String password = authorizationInfo.getOrDefault(PASSWORD, "");
        String domain = authorizationInfo.getOrDefault(DOMAIN, "");
        String workstation = authorizationInfo.getOrDefault(WORKSTATION, "");
        try {
            return new NTLMAuthorization(username, password, domain, workstation);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("Invalid NTLM Authorization parameters", (Throwable)e);
            throw new UnsupportedOperationException("Invalid NTLM Authorization parameters", e);
        }
        catch (Exception e) {
            this.logger.error("Error creating NTLM Authorization", (Throwable)e);
            throw new UnsupportedOperationException("Error creating NTLM Authorization", e);
        }
    }
}

