/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.preferences;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.report.CatsReportParser;
import com.kms.katalon.composer.webservice.viewmodel.AiTestingPreferences;
import com.kms.katalon.composer.webservice.viewmodel.ApiCollectionExecutionSummary;
import com.kms.katalon.composer.webservice.viewmodel.TestResultRun;
import com.kms.katalon.composer.webservice.viewmodel.TestResultStatistics;
import com.kms.katalon.composer.webservice.viewmodel.TestResultsData;
import com.kms.katalon.entity.folder.ApiCollectionEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiTestingPreferencesManager {
    private static final Logger logger = LoggerFactory.getLogger(AiTestingPreferencesManager.class);
    private final CatsReportParser catsReportParser;
    private final ObjectMapper objectMapper = this.createObjectMapper();
    private static final String AI_TESTING_PREFERENCES_FILE_NAME = "ai_testing_preferences.json";
    private static final String RESULT_FILE_NAME = "statistics_result.json";
    private static final String FIELD_PATH = "path";
    private static final String FIELD_LAST_USED_CONFIG_ID = "lastUsedConfigId";
    private static final String FIELD_CONFIGURATIONS = "configurations";
    private static final String FIELD_ID = "id";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_SERVER_URL = "serverUrl";
    private static final String FIELD_TEST_TYPES = "testTypes";
    private static final String FIELD_API_PATHS = "apiPaths";
    private static final String FIELD_HTTP_METHODS = "httpMethods";
    private static final String FIELD_LATEST_RUN_ID = "latestRunId";
    private static final String FIELD_RUNS = "runs";
    private static final String FIELD_RUN_ID = "runId";
    private static final String FIELD_TIMESTAMP = "timestamp";
    private static final String FIELD_EXECUTION_TIME = "executionTime";
    private static final String FIELD_CONFIGURATION = "configuration";
    private static final String FIELD_STATISTICS = "statistics";
    private static final String FIELD_REPORT_PATHS = "reportPaths";
    private static final String FIELD_TOTAL_TESTS = "totalTests";
    private static final String FIELD_PASSED_TESTS = "passedTests";
    private static final String FIELD_FAILED_TESTS = "failedTests";
    private static final String FIELD_WARNINGS_TESTS = "warningsTests";
    private static final String FIELD_POSITIVE = "positive";
    private static final String FIELD_NEGATIVE = "negative";
    private static final String FIELD_SECURITY = "security";
    private static final String FIELD_EDGE_CASE = "edgeCase";
    private static final String FIELD_TOTAL = "total";
    private static final String FIELD_PASSED = "passed";
    private static final String FIELD_FAILED = "failed";
    private static final String FIELD_WARNINGS = "warnings";
    private static final String FIELD_HTML_REPORT = "htmlReport";
    private static final String LOG_RUN_NODE_MISSING_FIELD = "Run node missing '{}' field";

    public AiTestingPreferencesManager() {
        this.catsReportParser = new CatsReportParser();
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        return mapper;
    }

    public void savePreferences(ApiCollectionEntity apiCollectionEntity, AiTestingPreferences preferences) {
        if (apiCollectionEntity == null || apiCollectionEntity.getId() == null) {
            return;
        }
        if (preferences == null || preferences.id() == null || preferences.id().isEmpty()) {
            logger.warn("Cannot save preferences without a valid configuration ID");
            return;
        }
        String preferencesFilePath = this.getPreferencesFilePath(apiCollectionEntity);
        if (preferencesFilePath == null) {
            return;
        }
        try {
            File preferencesFile = new File(preferencesFilePath);
            this.ensureParentDirectoryExists(preferencesFile);
            ObjectNode rootNode = this.loadOrCreateRootNode(preferencesFile, apiCollectionEntity);
            ArrayNode configurationsArray = this.getOrCreateConfigurationsArray(rootNode);
            this.updateOrAddConfiguration(configurationsArray, preferences);
            rootNode.put(FIELD_LAST_USED_CONFIG_ID, preferences.id());
            this.objectMapper.writerWithDefaultPrettyPrinter().writeValue(preferencesFile, (Object)rootNode);
        }
        catch (Exception e) {
            logger.error("Failed to save AI testing preferences", (Throwable)e);
        }
    }

    private void ensureParentDirectoryExists(File preferencesFile) {
        File parentDir = preferencesFile.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
    }

    private ObjectNode loadOrCreateRootNode(File preferencesFile, ApiCollectionEntity apiCollectionEntity) {
        if (!preferencesFile.exists()) {
            ObjectNode newNode = this.objectMapper.createObjectNode();
            newNode.put(FIELD_PATH, this.getCollectionPath(apiCollectionEntity));
            return newNode;
        }
        try {
            JsonNode existingNode = this.objectMapper.readTree(preferencesFile);
            if (existingNode.isObject()) {
                ObjectNode rootNode = (ObjectNode)existingNode;
                if (!rootNode.has(FIELD_PATH)) {
                    rootNode.put(FIELD_PATH, this.getCollectionPath(apiCollectionEntity));
                }
                return rootNode;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to read existing preferences: {}", (Object)e.getMessage());
        }
        ObjectNode newNode = this.objectMapper.createObjectNode();
        newNode.put(FIELD_PATH, this.getCollectionPath(apiCollectionEntity));
        return newNode;
    }

    private ArrayNode getOrCreateConfigurationsArray(ObjectNode rootNode) {
        if (rootNode.has(FIELD_CONFIGURATIONS) && rootNode.get(FIELD_CONFIGURATIONS).isArray()) {
            return (ArrayNode)rootNode.get(FIELD_CONFIGURATIONS);
        }
        ArrayNode configurationsArray = this.objectMapper.createArrayNode();
        rootNode.set(FIELD_CONFIGURATIONS, (JsonNode)configurationsArray);
        return configurationsArray;
    }

    private void updateOrAddConfiguration(ArrayNode configurationsArray, AiTestingPreferences preferences) {
        int existingIndex = -1;
        int i = 0;
        while (i < configurationsArray.size()) {
            JsonNode config = configurationsArray.get(i);
            if (config.has(FIELD_ID) && preferences.id().equals(config.get(FIELD_ID).asText())) {
                existingIndex = i;
                break;
            }
            ++i;
        }
        ObjectNode configNode = this.createConfigurationNode(preferences);
        if (existingIndex >= 0) {
            configurationsArray.set(existingIndex, (JsonNode)configNode);
        } else {
            configurationsArray.add((JsonNode)configNode);
        }
    }

    private String getCollectionPath(ApiCollectionEntity apiCollectionEntity) {
        String baseDirectory = this.getAiTestingBaseDirectory(apiCollectionEntity);
        return baseDirectory != null ? baseDirectory : "";
    }

    private ObjectNode createConfigurationNode(AiTestingPreferences preferences) {
        ObjectNode configNode = this.objectMapper.createObjectNode();
        this.addStringFieldIfNotEmpty(configNode, FIELD_ID, preferences.id());
        this.addStringFieldIfNotEmpty(configNode, FIELD_NAME, preferences.name());
        this.addStringFieldIfNotEmpty(configNode, FIELD_SERVER_URL, preferences.serverUrl());
        this.addListFieldIfNotEmpty(configNode, FIELD_TEST_TYPES, preferences.testTypes());
        this.addListFieldIfNotEmpty(configNode, FIELD_API_PATHS, preferences.apiPaths());
        this.addListFieldIfNotEmpty(configNode, FIELD_HTTP_METHODS, preferences.httpMethods());
        return configNode;
    }

    private void addStringFieldIfNotEmpty(ObjectNode node, String fieldName, String value) {
        if (value != null && !value.isEmpty()) {
            node.put(fieldName, value);
        }
    }

    private void addListFieldIfNotEmpty(ObjectNode node, String fieldName, List<String> value) {
        if (value != null && !value.isEmpty()) {
            node.putPOJO(fieldName, value);
        }
    }

    public AiTestingPreferences loadPreferences(ApiCollectionEntity apiCollectionEntity) {
        JsonNode configNode;
        block13: {
            String lastUsedConfigId;
            JsonNode rootNode;
            block12: {
                block11: {
                    File preferencesFile;
                    block10: {
                        if (apiCollectionEntity == null || apiCollectionEntity.getId() == null) {
                            return null;
                        }
                        String preferencesFilePath = this.getPreferencesFilePath(apiCollectionEntity);
                        if (preferencesFilePath == null) {
                            return null;
                        }
                        try {
                            preferencesFile = new File(preferencesFilePath);
                            if (preferencesFile.exists()) break block10;
                            return null;
                        }
                        catch (Exception e) {
                            logger.error("Failed to load AI testing preferences", (Throwable)e);
                            return null;
                        }
                    }
                    rootNode = this.objectMapper.readTree(preferencesFile);
                    if (rootNode.isObject()) break block11;
                    return null;
                }
                lastUsedConfigId = null;
                if (rootNode.has(FIELD_LAST_USED_CONFIG_ID)) {
                    lastUsedConfigId = rootNode.get(FIELD_LAST_USED_CONFIG_ID).asText();
                }
                if (rootNode.has(FIELD_CONFIGURATIONS) && rootNode.get(FIELD_CONFIGURATIONS).isArray()) break block12;
                return null;
            }
            ArrayNode configurationsArray = (ArrayNode)rootNode.get(FIELD_CONFIGURATIONS);
            configNode = this.findConfigurationById(configurationsArray, lastUsedConfigId);
            if (configNode == null && configurationsArray.size() > 0) {
                configNode = configurationsArray.get(0);
            }
            if (configNode != null) break block13;
            return null;
        }
        return this.buildAiTestingPreferences(configNode);
    }

    private JsonNode findConfigurationById(ArrayNode configurationsArray, String configId) {
        if (configId == null || configId.isEmpty()) {
            return null;
        }
        for (JsonNode config : configurationsArray) {
            if (!config.has(FIELD_ID) || !configId.equals(config.get(FIELD_ID).asText())) continue;
            return config;
        }
        return null;
    }

    private AiTestingPreferences buildAiTestingPreferences(JsonNode configNode) {
        String id = this.loadStringField(configNode, FIELD_ID);
        String name = this.loadStringField(configNode, FIELD_NAME);
        String serverUrl = this.loadStringField(configNode, FIELD_SERVER_URL);
        List<String> testCategories = this.loadListField(configNode, FIELD_TEST_TYPES);
        List<String> apiPaths = this.loadListField(configNode, FIELD_API_PATHS);
        List<String> httpMethods = this.loadListField(configNode, FIELD_HTTP_METHODS);
        return new AiTestingPreferences(id, name, serverUrl, testCategories, apiPaths, httpMethods);
    }

    private String loadStringField(JsonNode node, String fieldName) {
        if (!node.has(fieldName)) {
            return null;
        }
        String value = node.get(fieldName).asText();
        return value != null && !value.isEmpty() ? value : null;
    }

    private List<String> loadListField(JsonNode node, String fieldName) {
        ArrayList<String> result = new ArrayList<String>();
        if (!node.has(fieldName)) {
            return result;
        }
        JsonNode arrayNode = node.get(fieldName);
        if (arrayNode.isArray()) {
            for (JsonNode itemNode : arrayNode) {
                result.add(itemNode.asText());
            }
        }
        return result;
    }

    private String getAiTestingBaseDirectory(ApiCollectionEntity apiCollectionEntity) {
        if (apiCollectionEntity == null || apiCollectionEntity.getProject() == null) {
            return null;
        }
        String openApiSpecFileName = apiCollectionEntity.getOpenApiSpecFileName();
        if (openApiSpecFileName == null || openApiSpecFileName.isEmpty()) {
            return null;
        }
        String fileNameWithoutExtension = FilenameUtils.removeExtension((String)openApiSpecFileName);
        if (fileNameWithoutExtension == null || fileNameWithoutExtension.isEmpty()) {
            return null;
        }
        String projectFolderLocation = apiCollectionEntity.getProject().getFolderLocation();
        return projectFolderLocation + File.separator + ComposerWebserviceMessageConstants.OPENAPI_SPECIFICATION_FOLDER_NAME + File.separator + fileNameWithoutExtension;
    }

    private String getPreferencesFilePath(ApiCollectionEntity apiCollectionEntity) {
        String baseDirectory = this.getAiTestingBaseDirectory(apiCollectionEntity);
        return baseDirectory != null ? baseDirectory + File.separator + AI_TESTING_PREFERENCES_FILE_NAME : null;
    }

    private String getResultDirectoryPath(ApiCollectionEntity apiCollectionEntity) {
        return this.getAiTestingBaseDirectory(apiCollectionEntity);
    }

    public void saveTestResults(ApiCollectionEntity apiCollectionEntity, ApiCollectionExecutionSummary executionSummary, TestResultStatistics statistics, String htmlReportPath) {
        try {
            if (apiCollectionEntity == null || executionSummary == null || statistics == null) {
                logger.warn("Cannot save test results - invalid parameters");
                return;
            }
            String directoryPath = this.getResultDirectoryPath(apiCollectionEntity);
            if (directoryPath == null) {
                logger.warn("Cannot determine result directory path");
                return;
            }
            String runId = UUID.randomUUID().toString();
            File resultFile = new File(directoryPath + File.separator + RESULT_FILE_NAME);
            this.ensureParentDirectoryExists(resultFile);
            String timestamp = executionSummary.timestamp();
            long executionTimeMillis = executionSummary.executionTime();
            AiTestingPreferences configuration = this.loadPreferences(apiCollectionEntity);
            ObjectNode rootNode = this.loadOrCreateResultNode(resultFile);
            rootNode.put(FIELD_LATEST_RUN_ID, runId);
            ArrayNode runsArray = this.getOrCreateRunsArray(rootNode);
            ObjectNode runEntry = this.createRunEntry(runId, timestamp, executionTimeMillis, configuration, statistics, htmlReportPath);
            runsArray.insert(0, (JsonNode)runEntry);
            this.objectMapper.writerWithDefaultPrettyPrinter().writeValue(resultFile, (Object)rootNode);
            logger.info("Test results saved successfully to: {}", (Object)resultFile.getAbsolutePath());
        }
        catch (Exception e) {
            logger.error("Failed to save test results to statistics_result.json", (Throwable)e);
        }
    }

    private ObjectNode loadOrCreateResultNode(File resultFile) {
        if (!resultFile.exists()) {
            return this.objectMapper.createObjectNode();
        }
        try {
            JsonNode existingNode = this.objectMapper.readTree(resultFile);
            if (existingNode.isObject()) {
                return (ObjectNode)existingNode;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to read existing statistics_result.json: {}", (Object)e.getMessage());
        }
        return this.objectMapper.createObjectNode();
    }

    private ArrayNode getOrCreateRunsArray(ObjectNode rootNode) {
        if (rootNode.has(FIELD_RUNS) && rootNode.get(FIELD_RUNS).isArray()) {
            return (ArrayNode)rootNode.get(FIELD_RUNS);
        }
        ArrayNode runsArray = this.objectMapper.createArrayNode();
        rootNode.set(FIELD_RUNS, (JsonNode)runsArray);
        return runsArray;
    }

    private ObjectNode createRunEntry(String runId, String timestamp, long executionTimeMillis, AiTestingPreferences configuration, TestResultStatistics statistics, String htmlReportPath) {
        ObjectNode runEntry = this.objectMapper.createObjectNode();
        runEntry.put(FIELD_RUN_ID, runId);
        runEntry.put(FIELD_TIMESTAMP, timestamp);
        runEntry.put(FIELD_EXECUTION_TIME, executionTimeMillis);
        if (configuration != null) {
            ObjectNode configNode = this.objectMapper.createObjectNode();
            if (configuration.serverUrl() != null) {
                configNode.put(FIELD_SERVER_URL, configuration.serverUrl());
            }
            if (configuration.testTypes() != null && !configuration.testTypes().isEmpty()) {
                configNode.set(FIELD_TEST_TYPES, this.objectMapper.valueToTree(configuration.testTypes()));
            }
            if (configuration.apiPaths() != null && !configuration.apiPaths().isEmpty()) {
                configNode.set(FIELD_API_PATHS, this.objectMapper.valueToTree(configuration.apiPaths()));
            }
            if (configuration.httpMethods() != null && !configuration.httpMethods().isEmpty()) {
                configNode.set(FIELD_HTTP_METHODS, this.objectMapper.valueToTree(configuration.httpMethods()));
            }
            runEntry.set(FIELD_CONFIGURATION, (JsonNode)configNode);
        }
        runEntry.set(FIELD_STATISTICS, (JsonNode)this.createStatisticsNode(statistics));
        if (htmlReportPath != null && !htmlReportPath.isEmpty()) {
            ObjectNode reportPathsNode = this.objectMapper.createObjectNode();
            reportPathsNode.put(FIELD_HTML_REPORT, htmlReportPath);
            runEntry.set(FIELD_REPORT_PATHS, (JsonNode)reportPathsNode);
        }
        return runEntry;
    }

    private ObjectNode createStatisticsNode(TestResultStatistics statistics) {
        ObjectNode statisticsNode = this.objectMapper.createObjectNode();
        statisticsNode.put(FIELD_TOTAL_TESTS, statistics.totalTests());
        statisticsNode.put(FIELD_PASSED_TESTS, statistics.passedTests());
        statisticsNode.put(FIELD_FAILED_TESTS, statistics.failedTests());
        statisticsNode.put(FIELD_WARNINGS_TESTS, statistics.warningsTests());
        statisticsNode.set(FIELD_POSITIVE, (JsonNode)this.createTestTypeNode(statistics.passedPositive(), statistics.failedPositive(), statistics.warningsPositive()));
        statisticsNode.set(FIELD_NEGATIVE, (JsonNode)this.createTestTypeNode(statistics.passedNegative(), statistics.failedNegative(), statistics.warningsNegative()));
        statisticsNode.set(FIELD_SECURITY, (JsonNode)this.createTestTypeNode(statistics.passedSecurity(), statistics.failedSecurity(), statistics.warningsSecurity()));
        statisticsNode.set(FIELD_EDGE_CASE, (JsonNode)this.createTestTypeNode(statistics.passedEdgeCase(), statistics.failedEdgeCase(), statistics.warningsEdgeCase()));
        return statisticsNode;
    }

    private ObjectNode createTestTypeNode(int passed, int failed, int warnings) {
        ObjectNode node = this.objectMapper.createObjectNode();
        node.put(FIELD_TOTAL, passed + failed + warnings);
        node.put(FIELD_PASSED, passed);
        node.put(FIELD_FAILED, failed);
        node.put(FIELD_WARNINGS, warnings);
        return node;
    }

    public TestResultsData loadTestResults(ApiCollectionEntity apiCollectionEntity) {
        JsonNode rootNode;
        block5: {
            if (apiCollectionEntity == null) {
                logger.warn("Cannot load test results - apiCollectionEntity is null");
                return null;
            }
            String resultFilePath = this.getResultFilePath(apiCollectionEntity);
            if (resultFilePath == null) {
                logger.warn("Cannot load test results - result file path is null (check project and OpenAPI spec file name)");
                return null;
            }
            try {
                rootNode = this.loadAndValidateResultFile(resultFilePath);
                if (rootNode != null) break block5;
                return null;
            }
            catch (Exception e) {
                logger.error("Failed to load test results from statistics_result.json at: " + resultFilePath, (Throwable)e);
                return null;
            }
        }
        String latestRunId = this.parseLatestRunId(rootNode);
        List<TestResultRun> runs = this.parseRunsList(rootNode);
        logger.info("Successfully loaded {} test result(s)", (Object)runs.size());
        return new TestResultsData(latestRunId, runs);
    }

    private JsonNode loadAndValidateResultFile(String resultFilePath) {
        JsonNode rootNode;
        block5: {
            File resultFile;
            block4: {
                try {
                    resultFile = new File(resultFilePath);
                    logger.info("Attempting to load test results from: {}", (Object)resultFilePath);
                    if (resultFile.exists()) break block4;
                    logger.info("Test results file does not exist: {}", (Object)resultFilePath);
                    return null;
                }
                catch (Exception e) {
                    logger.error("Failed to read result file: " + resultFilePath, (Throwable)e);
                    return null;
                }
            }
            rootNode = this.objectMapper.readTree(resultFile);
            if (rootNode.isObject()) break block5;
            logger.warn("Test results file is not a valid JSON object");
            return null;
        }
        return rootNode;
    }

    private String parseLatestRunId(JsonNode rootNode) {
        if (!rootNode.has(FIELD_LATEST_RUN_ID)) {
            logger.warn("No latestRunId found in statistics_result.json");
            return null;
        }
        String latestRunId = rootNode.get(FIELD_LATEST_RUN_ID).asText();
        logger.info("Loaded latestRunId: {}", (Object)latestRunId);
        return latestRunId;
    }

    private List<TestResultRun> parseRunsList(JsonNode rootNode) {
        ArrayList<TestResultRun> runs = new ArrayList<TestResultRun>();
        if (!rootNode.has(FIELD_RUNS) || !rootNode.get(FIELD_RUNS).isArray()) {
            logger.warn("No runs array found in statistics_result.json");
            return runs;
        }
        ArrayNode runsArray = (ArrayNode)rootNode.get(FIELD_RUNS);
        logger.info("Found {} run(s) in statistics_result.json", (Object)runsArray.size());
        for (JsonNode runNode : runsArray) {
            TestResultRun run = this.parseTestResultRun(runNode);
            if (run != null) {
                runs.add(run);
                logger.info("Successfully parsed run with ID: {}", (Object)run.runId());
                continue;
            }
            logger.warn("Failed to parse a run entry");
        }
        return runs;
    }

    public TestResultRun loadLatestTestResult(ApiCollectionEntity apiCollectionEntity) {
        TestResultsData data = this.loadTestResults(apiCollectionEntity);
        if (data == null || data.runs() == null || data.runs().isEmpty()) {
            return null;
        }
        return data.runs().get(0);
    }

    public TestResultRun loadTestResultByLatestRunId(ApiCollectionEntity apiCollectionEntity) {
        TestResultsData data = this.loadTestResults(apiCollectionEntity);
        if (data == null || data.latestRunId() == null) {
            return null;
        }
        if (data.runs() != null) {
            for (TestResultRun run : data.runs()) {
                if (!data.latestRunId().equals(run.runId())) continue;
                return run;
            }
        }
        return null;
    }

    private String getResultFilePath(ApiCollectionEntity apiCollectionEntity) {
        String directoryPath = this.getResultDirectoryPath(apiCollectionEntity);
        if (directoryPath == null) {
            return null;
        }
        return directoryPath + File.separator + RESULT_FILE_NAME;
    }

    private TestResultRun parseTestResultRun(JsonNode runNode) {
        TestResultStatistics statistics;
        AiTestingPreferences configuration;
        long executionTime;
        String timestamp;
        String runId;
        block13: {
            JsonNode statsNode;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            try {
                                if (runNode.has(FIELD_RUN_ID)) break block9;
                                logger.warn(LOG_RUN_NODE_MISSING_FIELD, (Object)FIELD_RUN_ID);
                                return null;
                            }
                            catch (Exception e) {
                                logger.error("Failed to parse test result run", (Throwable)e);
                                return null;
                            }
                        }
                        if (runNode.has(FIELD_TIMESTAMP)) break block10;
                        logger.warn(LOG_RUN_NODE_MISSING_FIELD, (Object)FIELD_TIMESTAMP);
                        return null;
                    }
                    if (runNode.has(FIELD_EXECUTION_TIME)) break block11;
                    logger.warn(LOG_RUN_NODE_MISSING_FIELD, (Object)FIELD_EXECUTION_TIME);
                    return null;
                }
                if (runNode.has(FIELD_STATISTICS)) break block12;
                logger.warn(LOG_RUN_NODE_MISSING_FIELD, (Object)FIELD_STATISTICS);
                return null;
            }
            runId = runNode.get(FIELD_RUN_ID).asText();
            timestamp = runNode.get(FIELD_TIMESTAMP).asText();
            executionTime = runNode.get(FIELD_EXECUTION_TIME).asLong();
            configuration = null;
            if (runNode.has(FIELD_CONFIGURATION)) {
                configuration = this.parseConfiguration(runNode.get(FIELD_CONFIGURATION));
            }
            if ((statistics = this.catsReportParser.parseTestResultStatistics(statsNode = runNode.get(FIELD_STATISTICS))) != null) break block13;
            logger.warn("Failed to parse statistics for runId: {}", (Object)runId);
            return null;
        }
        TestResultRun.ReportPaths reportPaths = null;
        if (runNode.has(FIELD_REPORT_PATHS)) {
            JsonNode reportPathsNode = runNode.get(FIELD_REPORT_PATHS);
            String htmlReport = reportPathsNode.has(FIELD_HTML_REPORT) ? reportPathsNode.get(FIELD_HTML_REPORT).asText() : null;
            reportPaths = new TestResultRun.ReportPaths(htmlReport);
        }
        return new TestResultRun(runId, timestamp, executionTime, configuration, statistics, reportPaths);
    }

    private AiTestingPreferences parseConfiguration(JsonNode configNode) {
        block3: {
            try {
                if (configNode != null) break block3;
                return null;
            }
            catch (Exception e) {
                logger.warn("Failed to parse configuration: {}", (Object)e.getMessage());
                return null;
            }
        }
        String serverUrl = configNode.has(FIELD_SERVER_URL) ? configNode.get(FIELD_SERVER_URL).asText() : null;
        List<String> testTypes = this.loadListField(configNode, FIELD_TEST_TYPES);
        List<String> apiPaths = this.loadListField(configNode, FIELD_API_PATHS);
        List<String> httpMethods = this.loadListField(configNode, FIELD_HTTP_METHODS);
        return new AiTestingPreferences(null, null, serverUrl, testTypes, apiPaths, httpMethods);
    }
}

