/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.report;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.kms.katalon.composer.webservice.constants.APIAITestingConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatsHtmlReportGenerator {
    private static final Logger logger = LoggerFactory.getLogger(CatsHtmlReportGenerator.class);
    private static final String FIELD_TEST_CASES = "testCases";
    private static final String FIELD_FUZZER = "fuzzer";
    private static final String FIELD_SCENARIO = "scenario";
    private final ObjectMapper objectMapper = this.createObjectMapper();
    private final String templateCache;

    public CatsHtmlReportGenerator() {
        try {
            this.templateCache = this.loadTemplateFromBundle();
            logger.info("HTML report template loaded and cached successfully");
        }
        catch (IOException e) {
            logger.error("Failed to load HTML report template", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        return mapper;
    }

    private String loadTemplateFromBundle() throws IOException {
        Bundle bundle = FrameworkUtil.getBundle(CatsHtmlReportGenerator.class);
        if (bundle == null) {
            throw new IOException("Unable to get bundle for CatsHtmlReportGenerator");
        }
        String templatePath = "resources/html/api_ai_test_report_template.html";
        URL templateUrl = FileLocator.find((Bundle)bundle, (IPath)new Path(templatePath), null);
        if (templateUrl == null) {
            throw new IOException("Template file not found in bundle resources: " + templatePath);
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream is = templateUrl.openStream();){
            return IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void createCustomReport(File summaryJsonFile, String reportFolderPath) {
        if (!this.validateReportInputs(summaryJsonFile, reportFolderPath)) {
            return;
        }
        try {
            JsonNode summaryJson = this.loadAndProcessSummaryJson(summaryJsonFile);
            String htmlContent = this.generateHtmlContent(summaryJson);
            this.writeHtmlReport(htmlContent, reportFolderPath);
        }
        catch (IOException e) {
            logger.error("Failed to create custom HTML report", (Throwable)e);
        }
    }

    private boolean validateReportInputs(File summaryJsonFile, String reportFolderPath) {
        if (summaryJsonFile == null || !summaryJsonFile.exists()) {
            logger.warn("Summary JSON file does not exist: {}", (Object)summaryJsonFile);
            return false;
        }
        if (reportFolderPath == null || reportFolderPath.isEmpty()) {
            logger.warn("Report folder path is null or empty");
            return false;
        }
        return true;
    }

    private JsonNode loadAndProcessSummaryJson(File summaryJsonFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream fis = new FileInputStream(summaryJsonFile);){
            JsonNode summaryJson = this.objectMapper.readTree((InputStream)fis);
            this.categorizeTestCases(summaryJson);
            this.replaceCatsWithAiInScenarios(summaryJson);
            this.removeFuzzerAttributes(summaryJson);
            return summaryJson;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void categorizeTestCases(JsonNode summaryJson) {
        if (!summaryJson.has(FIELD_TEST_CASES) || !summaryJson.get(FIELD_TEST_CASES).isArray()) {
            return;
        }
        for (JsonNode testCase : summaryJson.get(FIELD_TEST_CASES)) {
            if (!testCase.isObject()) continue;
            String fuzzer = testCase.has(FIELD_FUZZER) ? testCase.get(FIELD_FUZZER).asText() : null;
            String category = APIAITestingConstants.getTestTypeFromFuzzer(fuzzer);
            ((ObjectNode)testCase).put("category", category);
        }
    }

    private String generateHtmlContent(JsonNode summaryJson) throws IOException {
        String jsonString = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)summaryJson);
        return this.embedJsonInTemplate(this.templateCache, jsonString);
    }

    private String embedJsonInTemplate(String templateContent, String jsonString) throws IOException {
        String placeholderStart = "const testData = {";
        String placeholderEnd = "};";
        int startIdx = templateContent.indexOf(placeholderStart);
        int endIdx = templateContent.indexOf(placeholderEnd, startIdx);
        if (startIdx == -1 || endIdx == -1) {
            throw new IOException("Could not find JSON placeholder in template");
        }
        String beforePlaceholder = templateContent.substring(0, startIdx);
        String afterPlaceholder = templateContent.substring(endIdx + placeholderEnd.length());
        return beforePlaceholder + "const testData = " + jsonString + ";" + afterPlaceholder;
    }

    private void writeHtmlReport(String htmlContent, String reportFolderPath) throws IOException {
        File outputFile = new File(reportFolderPath, "ai_test_report.html");
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8);){
            writer.write(htmlContent);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        logger.info("Generated custom HTML report: {}", (Object)outputFile.getAbsolutePath());
    }

    private void replaceCatsWithAiInScenarios(JsonNode node) {
        block5: {
            block4: {
                if (node == null) {
                    return;
                }
                if (!node.isObject()) break block4;
                ObjectNode objectNode = (ObjectNode)node;
                ArrayList fieldNames = new ArrayList();
                objectNode.fieldNames().forEachRemaining(fieldNames::add);
                for (String fieldName : fieldNames) {
                    JsonNode fieldValue = objectNode.get(fieldName);
                    if (FIELD_SCENARIO.equals(fieldName) && fieldValue.isTextual()) {
                        String scenarioValue = fieldValue.asText();
                        String updatedValue = scenarioValue.replace("cats", "ai");
                        objectNode.put(fieldName, updatedValue);
                        continue;
                    }
                    this.replaceCatsWithAiInScenarios(fieldValue);
                }
                break block5;
            }
            if (!node.isArray()) break block5;
            for (JsonNode arrayElement : node) {
                this.replaceCatsWithAiInScenarios(arrayElement);
            }
        }
    }

    private void removeFuzzerAttributes(JsonNode node) {
        block5: {
            block4: {
                if (node == null) {
                    return;
                }
                if (!node.isObject()) break block4;
                ObjectNode objectNode = (ObjectNode)node;
                if (objectNode.has(FIELD_FUZZER)) {
                    objectNode.remove(FIELD_FUZZER);
                }
                ArrayList fieldNames = new ArrayList();
                objectNode.fieldNames().forEachRemaining(fieldNames::add);
                for (String fieldName : fieldNames) {
                    JsonNode fieldValue = objectNode.get(fieldName);
                    this.removeFuzzerAttributes(fieldValue);
                }
                break block5;
            }
            if (!node.isArray()) break block5;
            for (JsonNode arrayElement : node) {
                this.removeFuzzerAttributes(arrayElement);
            }
        }
    }
}

