/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.report;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.composer.webservice.constants.APIAITestingConstants;
import com.kms.katalon.composer.webservice.report.TestResultStatisticsCalculator;
import com.kms.katalon.composer.webservice.viewmodel.ApiCollectionExecutionSummary;
import com.kms.katalon.composer.webservice.viewmodel.TestResultStatistics;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatsReportParser {
    private static final Logger logger = LoggerFactory.getLogger(CatsReportParser.class);
    private final ObjectMapper objectMapper = this.createObjectMapper();
    private static final String FIELD_TOTAL_TESTS = "totalTests";
    private static final String FIELD_PASSED_TESTS = "passedTests";
    private static final String FIELD_FAILED_TESTS = "failedTests";
    private static final String FIELD_WARNINGS_TESTS = "warningsTests";
    private static final String FIELD_POSITIVE = "positive";
    private static final String FIELD_NEGATIVE = "negative";
    private static final String FIELD_SECURITY = "security";
    private static final String FIELD_EDGE_CASE = "edgeCase";
    private static final String FIELD_PASSED = "passed";
    private static final String FIELD_FAILED = "failed";
    private static final String FIELD_WARNINGS = "warnings";

    private ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        return mapper;
    }

    public ApiCollectionExecutionSummary parseTestResults(String summaryJsonPath) {
        ApiCollectionExecutionSummary testResult;
        block7: {
            File jsonFile;
            block6: {
                block5: {
                    try {
                        if (summaryJsonPath != null) break block5;
                        logger.warn("Summary JSON path is null");
                        return null;
                    }
                    catch (Exception e) {
                        logger.error("Failed to parse AI summary report JSON", (Throwable)e);
                        return null;
                    }
                }
                jsonFile = new File(summaryJsonPath);
                if (jsonFile.exists()) break block6;
                logger.warn("AI summary report JSON file not found: {}", (Object)summaryJsonPath);
                return null;
            }
            testResult = (ApiCollectionExecutionSummary)this.objectMapper.readValue(jsonFile, ApiCollectionExecutionSummary.class);
            if (testResult != null) break block7;
            logger.warn("Failed to parse AI summary report JSON - result is null");
            return null;
        }
        return testResult;
    }

    public TestResultStatistics parseAndCalculateTestStatistics(String summaryJsonPath, TestResultStatisticsCalculator statisticsCalculator) {
        ApiCollectionExecutionSummary testResult = this.parseTestResults(summaryJsonPath);
        return statisticsCalculator.calculateStatistics(testResult);
    }

    public String getTestTypeFromFuzzer(String fuzzer) {
        return APIAITestingConstants.getTestTypeFromFuzzer(fuzzer);
    }

    public TestResultStatistics parseTestResultStatistics(JsonNode statsNode) {
        block3: {
            try {
                if (statsNode != null) break block3;
                logger.warn("Statistics node is null");
                return null;
            }
            catch (Exception e) {
                logger.error("Failed to parse test result statistics", (Throwable)e);
                return null;
            }
        }
        int totalTests = this.getIntField(statsNode, FIELD_TOTAL_TESTS);
        int passedTests = this.getIntField(statsNode, FIELD_PASSED_TESTS);
        int failedTests = this.getIntField(statsNode, FIELD_FAILED_TESTS);
        int warningsTests = this.getIntField(statsNode, FIELD_WARNINGS_TESTS);
        int[] positiveStats = this.parseTestTypeStats(statsNode, FIELD_POSITIVE);
        int[] negativeStats = this.parseTestTypeStats(statsNode, FIELD_NEGATIVE);
        int[] securityStats = this.parseTestTypeStats(statsNode, FIELD_SECURITY);
        int[] edgeCaseStats = this.parseTestTypeStats(statsNode, FIELD_EDGE_CASE);
        logger.info("Successfully parsed statistics: total={}, passed={}, failed={}, warnings={}", new Object[]{totalTests, passedTests, failedTests, warningsTests});
        return new TestResultStatistics(totalTests, passedTests, failedTests, warningsTests, positiveStats[0], positiveStats[1], positiveStats[2], negativeStats[0], negativeStats[1], negativeStats[2], securityStats[0], securityStats[1], securityStats[2], edgeCaseStats[0], edgeCaseStats[1], edgeCaseStats[2]);
    }

    private int[] parseTestTypeStats(JsonNode parentNode, String fieldName) {
        if (!parentNode.has(fieldName)) {
            return new int[3];
        }
        JsonNode testTypeNode = parentNode.get(fieldName);
        return new int[]{this.getIntField(testTypeNode, FIELD_PASSED), this.getIntField(testTypeNode, FIELD_FAILED), this.getIntField(testTypeNode, FIELD_WARNINGS)};
    }

    private int getIntField(JsonNode node, String fieldName) {
        return node.has(fieldName) ? node.get(fieldName).asInt() : 0;
    }
}

