/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.response.header;

import com.kms.katalon.composer.webservice.response.header.ResponseHeaderEditor;
import com.kms.katalon.core.testobject.ResponseObject;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class HeaderPrettyEditor
extends Composite
implements ResponseHeaderEditor {
    private TableViewer tableViewer;
    private Clipboard clipboard;
    private static final int KEY_COLUMN_WIDTH = 200;
    private static final int MIN_VALUE_COLUMN_WIDTH = 50;
    private static final int TABLE_BORDER_WIDTH = 4;
    private static final int MIN_TABLE_HEIGHT = 150;

    public HeaderPrettyEditor(Composite parent, int style) {
        super(parent, style);
        this.initializeLayout();
        this.clipboard = new Clipboard(parent.getDisplay());
        this.createTableViewer();
    }

    private void initializeLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer((Composite)this, 68354);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableColumns(this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.setupTableLayout();
        this.addColumnResizeHandling(table);
        this.addCopyFunctionality(table);
    }

    private void setupTableLayout() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 150;
        gridData.grabExcessVerticalSpace = true;
        this.tableViewer.getControl().setLayoutData((Object)gridData);
    }

    private void updateTableContent(Map<String, String> headers) {
        this.tableViewer.setInput(headers.entrySet());
        this.tableViewer.refresh();
        this.getDisplay().asyncExec(() -> {
            if (!this.isDisposed()) {
                this.layout(true, true);
                this.adjustHeaderValueColumnWidth(this.tableViewer.getTable(), this.tableViewer.getTable().getColumn(0), this.tableViewer.getTable().getColumn(1));
            }
        });
    }

    private void createTableColumns(TableViewer viewer) {
        this.createHeaderKeyColumn(viewer);
        this.createHeaderValueColumn(viewer);
    }

    private void createHeaderKeyColumn(TableViewer viewer) {
        TableViewerColumn keyCol = new TableViewerColumn(viewer, 0);
        keyCol.getColumn().setWidth(200);
        keyCol.getColumn().setText("Key");
        keyCol.getColumn().setResizable(true);
        keyCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Map.Entry) {
                    Map.Entry mapEntry = (Map.Entry)element;
                    return mapEntry.getKey() != null ? mapEntry.getKey().toString() : "";
                }
                return element.toString();
            }
        });
    }

    private void createHeaderValueColumn(TableViewer viewer) {
        TableViewerColumn valueCol = new TableViewerColumn(viewer, 0);
        valueCol.getColumn().setText("Value");
        valueCol.getColumn().setResizable(true);
        valueCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Map.Entry) {
                    Map.Entry mapEntry = (Map.Entry)element;
                    return mapEntry.getValue() != null ? mapEntry.getValue().toString() : "";
                }
                return element.toString();
            }
        });
    }

    private void addCopyFunctionality(Table table) {
        Menu menu = new Menu((Control)table);
        table.setMenu(menu);
        MenuItem copyKeyItem = new MenuItem(menu, 0);
        copyKeyItem.setText("Copy Key");
        copyKeyItem.addListener(13, event -> this.copyTableCellText(0));
        MenuItem copyValueItem = new MenuItem(menu, 0);
        copyValueItem.setText("Copy Value");
        copyValueItem.addListener(13, event -> this.copyTableCellText(1));
    }

    private void copyTableCellText(int columnIndex) {
        Table table = this.tableViewer.getTable();
        int selectionIndex = table.getSelectionIndex();
        if (selectionIndex != -1) {
            String textToCopy = this.extractTextFromCell(selectionIndex, columnIndex);
            this.copyToClipboard(textToCopy);
        }
    }

    private String extractTextFromCell(int rowIndex, int columnIndex) {
        Object element = this.tableViewer.getElementAt(rowIndex);
        if (element instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)element;
            if (columnIndex == 0) {
                return entry.getKey() != null ? entry.getKey().toString() : "";
            }
            if (columnIndex == 1) {
                return entry.getValue() != null ? entry.getValue().toString() : "";
            }
        }
        return "";
    }

    private void copyToClipboard(String text) {
        TextTransfer textTransfer = TextTransfer.getInstance();
        this.clipboard.setContents(new Object[]{text}, new Transfer[]{textTransfer});
    }

    private void addColumnResizeHandling(final Table table) {
        final TableColumn keyColumn = table.getColumn(0);
        final TableColumn valueColumn = table.getColumn(1);
        keyColumn.setWidth(200);
        ControlAdapter resizeListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (table.isDisposed()) {
                    return;
                }
                HeaderPrettyEditor.this.adjustHeaderValueColumnWidth(table, keyColumn, valueColumn);
            }
        };
        this.addControlListener((ControlListener)resizeListener);
        this.getDisplay().asyncExec(() -> {
            if (!this.isDisposed()) {
                this.adjustHeaderValueColumnWidth(table, keyColumn, valueColumn);
            }
        });
    }

    private void adjustHeaderValueColumnWidth(Table table, TableColumn keyColumn, TableColumn valueColumn) {
        Rectangle area = this.getClientArea();
        int width = area.width;
        if (table.getVerticalBar().isVisible()) {
            width -= table.getVerticalBar().getSize().x;
        }
        if ((width -= 4) > keyColumn.getWidth() + 50) {
            valueColumn.setWidth(width - keyColumn.getWidth());
        }
        table.redraw();
    }

    @Override
    public void setHeaderContent(ResponseObject responseObj) throws IOException {
        Map<String, String> headers = this.extractHeaders(responseObj);
        this.updateTableContent(headers);
    }

    private Map<String, String> extractHeaders(ResponseObject responseObj) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (responseObj != null && responseObj.getHeaderFields() != null) {
            responseObj.getHeaderFields().forEach((key, values) -> {
                String headerKey = key == null ? "" : key;
                String headerValue = values != null ? StringUtils.join((Collection)values, (String)", ") : "";
                headers.put(headerKey, headerValue);
            });
        }
        return headers;
    }

    @Override
    public void switchModeHeaderContent(ResponseObject responseObj) throws IOException {
        this.setHeaderContent(responseObj);
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }
}

