/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.service;

import com.kms.katalon.composer.webservice.constants.APIAITestingConstants;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.testobject.authorization.BasicRequestAuthorization;
import com.kms.katalon.core.util.internal.NamingUtil;
import com.kms.katalon.entity.folder.ApiCollectionEntity;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.PathUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatsExecutionService {
    private static final Logger logger = LoggerFactory.getLogger(CatsExecutionService.class);
    private ApiCollectionEntity apiCollectionEntity;
    private String openApiSpecFilePath;

    public CatsExecutionService(ApiCollectionEntity apiCollectionEntity, String openApiSpecFilePath) {
        this.apiCollectionEntity = apiCollectionEntity;
        this.openApiSpecFilePath = openApiSpecFilePath;
    }

    public int executeAiTests(IProgressMonitor monitor, String serverUrl, List<String> selectedTestTypes, List<String> selectedApiPaths, List<String> selectedHttpMethods, BasicRequestAuthorization authorization, Map<String, String> allHttpMethods) throws InterruptedException {
        try {
            List<String> command = this.buildCommand(serverUrl, selectedTestTypes, selectedApiPaths, selectedHttpMethods, authorization, allHttpMethods);
            return this.executeProcess(command, monitor);
        }
        catch (IOException e) {
            logger.error("Failed to execute AI tests", (Throwable)e);
            return 1;
        }
    }

    private List<String> buildCommand(String serverUrl, List<String> selectedTestTypes, List<String> selectedApiPaths, List<String> selectedHttpMethods, BasicRequestAuthorization authorization, Map<String, String> allHttpMethods) throws IOException {
        List<String> command = this.buildBaseCommand(serverUrl);
        this.addFuzzersToCommand(command, selectedTestTypes);
        this.addPathsToCommand(command, selectedApiPaths);
        this.addHttpMethodsToCommand(command, selectedHttpMethods, allHttpMethods);
        this.addReportFolderToCommand(command);
        this.addAuthorizationToCommand(command, authorization);
        return command;
    }

    private List<String> buildBaseCommand(String serverUrl) throws IOException {
        File catsJar = this.getCatsJar();
        if (!catsJar.exists()) {
            throw new FileNotFoundException("CATS JAR not found at: " + catsJar.getAbsolutePath());
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(ClassPathResolver.getInstalledJRE((boolean)false));
        command.add("-jar");
        command.add(catsJar.getAbsolutePath());
        command.add("--contract=" + this.openApiSpecFilePath);
        command.add("--server=" + serverUrl);
        return command;
    }

    private void addFuzzersToCommand(List<String> command, List<String> selectedTestTypes) {
        List<String> fuzzers;
        List<String> list = fuzzers = selectedTestTypes != null && !selectedTestTypes.isEmpty() ? APIAITestingConstants.getFuzzersForTestTypes(selectedTestTypes) : this.getAllFuzzers();
        if (fuzzers.isEmpty()) {
            if (selectedTestTypes != null && !selectedTestTypes.isEmpty()) {
                logger.warn("No fuzzers found for selected test types: {}", selectedTestTypes);
            } else {
                logger.warn("No fuzzers found in any category");
            }
            return;
        }
        String fuzzersParam = String.join((CharSequence)",", fuzzers);
        command.add("--fuzzers");
        command.add(fuzzersParam);
        if (selectedTestTypes != null && !selectedTestTypes.isEmpty()) {
            logger.info("Using fuzzers for selected test types: {}", (Object)fuzzersParam);
        } else {
            logger.info("No test type selected - using all fuzzers from all 4 categories: {}", (Object)fuzzersParam);
        }
    }

    private List<String> getAllFuzzers() {
        ArrayList<String> allFuzzers = new ArrayList<String>();
        allFuzzers.addAll(APIAITestingConstants.getPositiveTestingFuzzers());
        allFuzzers.addAll(APIAITestingConstants.getNegativeTestingFuzzers());
        allFuzzers.addAll(APIAITestingConstants.getSecurityTestingFuzzers());
        allFuzzers.addAll(APIAITestingConstants.getEdgeCaseTestingFuzzers());
        return allFuzzers;
    }

    private void addPathsToCommand(List<String> command, List<String> selectedApiPaths) {
        if (selectedApiPaths != null && !selectedApiPaths.isEmpty()) {
            command.add("--paths");
            command.add(String.join((CharSequence)",", selectedApiPaths));
        }
    }

    private void addHttpMethodsToCommand(List<String> command, List<String> selectedHttpMethods, Map<String, String> allHttpMethods) {
        List<String> methodsToUse;
        List<String> list = methodsToUse = selectedHttpMethods != null && !selectedHttpMethods.isEmpty() ? selectedHttpMethods : new ArrayList<String>(allHttpMethods.keySet());
        if (methodsToUse.isEmpty()) {
            logger.warn("No HTTP methods found in OpenAPI specification");
            return;
        }
        String httpMethodsParam = String.join((CharSequence)",", methodsToUse);
        command.add("--httpMethod");
        command.add(httpMethodsParam);
        if (selectedHttpMethods == null || selectedHttpMethods.isEmpty()) {
            logger.info("No HTTP method selected - using all available HTTP methods: {}", (Object)httpMethodsParam);
        }
    }

    private void addReportFolderToCommand(List<String> command) {
        String reportFolder = this.setupReportFolder();
        command.add("-o");
        command.add(reportFolder);
    }

    private String setupReportFolder() {
        Path workspace;
        String projectFolderLocation = this.apiCollectionEntity.getProject().getFolderLocation();
        String sanitizedFileName = this.getFileName(this.openApiSpecFilePath);
        if (sanitizedFileName == null || sanitizedFileName.trim().isEmpty()) {
            throw new SecurityException("Invalid OpenAPI spec filename");
        }
        Path aiReportPath = Path.of(projectFolderLocation, GlobalStringConstants.ROOT_FOLDER_NAME_REPORT, sanitizedFileName);
        Path normalized = aiReportPath.toAbsolutePath().normalize();
        if (!normalized.startsWith(workspace = Path.of(projectFolderLocation, new String[0]).toAbsolutePath().normalize())) {
            throw new SecurityException("Report folder must be within project workspace: " + String.valueOf(aiReportPath));
        }
        File catsReportDir = aiReportPath.toFile();
        if (catsReportDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)catsReportDir);
            }
            catch (IOException e) {
                logger.error("report folder deletion failed: " + catsReportDir.getAbsolutePath(), (Throwable)e);
            }
        }
        catsReportDir.mkdirs();
        return aiReportPath.toString();
    }

    private void addAuthorizationToCommand(List<String> command, BasicRequestAuthorization authorization) {
        if (authorization == null || authorization.getAuthorizationType() == null) {
            return;
        }
        String authType = authorization.getAuthorizationType();
        if (ComposerWebserviceMessageConstants.BASIC_AUTH.equals(authType)) {
            this.addBasicAuthToCommand(command, authorization.getAuthorizationInfo());
        } else if ("Bearer".equals(authType)) {
            this.addBearerAuthToCommand(command, authorization.getAuthorizationInfo());
        }
    }

    private void addBasicAuthToCommand(List<String> command, Map<String, String> authInfo) {
        if (authInfo == null) {
            logger.warn("BASIC_AUTH configured but authorization info is null");
            return;
        }
        String username = authInfo.get("username");
        String password = authInfo.get("password");
        if (username != null && password != null && !username.isEmpty() && !password.isEmpty()) {
            command.add("--basicauth");
            command.add(username + ":" + password);
        } else {
            logger.warn("BASIC_AUTH configured but username or password is empty");
        }
    }

    private void addBearerAuthToCommand(List<String> command, Map<String, String> authInfo) {
        if (authInfo == null) {
            logger.warn("Bearer authentication configured but authorization info is null");
            return;
        }
        String bearerToken = authInfo.get("bearerToken");
        if (bearerToken != null && !bearerToken.isEmpty()) {
            command.add("-H");
            command.add("Authorization=\"Bearer " + bearerToken + "\"");
        } else {
            logger.warn("Bearer authentication configured but bearer token is empty");
        }
    }

    /*
     * Exception decompiling
     */
    private int executeProcess(List<String> command, IProgressMonitor monitor) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 10[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File getCatsJar() throws IOException {
        String filePath = "resources/lib/cats.jar";
        Bundle bundle = FrameworkUtil.getBundle(CatsExecutionService.class);
        if (bundle == null) {
            throw new IllegalStateException("Unable to get bundle for CatsExecutionService");
        }
        if (Platform.inDevelopmentMode()) {
            File parentFolder = new File(ClassPathResolver.getBundleLocation((Bundle)bundle));
            return new File(parentFolder, filePath);
        }
        File configurationFolder = ClassPathResolver.getConfigurationFolder();
        File catsJarFile = new File(configurationFolder, filePath);
        if (!catsJarFile.exists()) {
            URL resourceUrl = bundle.getEntry(filePath);
            if (resourceUrl == null) {
                throw new FileNotFoundException("CATS JAR not found in bundle: " + filePath);
            }
            URL fileUrl = FileLocator.toFileURL((URL)resourceUrl);
            catsJarFile = new File(fileUrl.getPath());
        }
        return catsJarFile;
    }

    private String getFileName(String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            return "";
        }
        Path path = Paths.get(filePath, new String[0]);
        String fileName = PathUtils.getBaseName((Path)path);
        if ((fileName = NamingUtil.sanitizeFileName((String)fileName)).trim().isEmpty()) {
            throw new SecurityException("Filename became empty after sanitization");
        }
        if (fileName.contains("..") || fileName.contains(File.separator) || fileName.contains("/") || fileName.contains("\\")) {
            fileName = fileName.replace("/", "-").replace("\\", "-").replace("..", "-");
            logger.warn("Path separators found in filename after sanitization, replaced with dashes: {}", (Object)fileName);
        }
        return fileName;
    }

    public String getCatsReportFolderPath() {
        if (this.apiCollectionEntity == null || this.openApiSpecFilePath == null || this.openApiSpecFilePath.isEmpty()) {
            return null;
        }
        String projectFolderLocation = this.apiCollectionEntity.getProject().getFolderLocation();
        String sanitizedFileName = this.getFileName(this.openApiSpecFilePath);
        Path reportPath = Path.of(projectFolderLocation, GlobalStringConstants.ROOT_FOLDER_NAME_REPORT, sanitizedFileName);
        return reportPath.toString();
    }
}

