/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.soap.response.body;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.kms.katalon.composer.components.impl.constants.TextContentType;
import com.kms.katalon.composer.components.impl.editors.MirrorEditor;
import com.kms.katalon.composer.components.impl.handler.DocumentReadyHandler;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.parts.VerificationScriptEventHandler;
import com.kms.katalon.composer.webservice.response.body.ResponseBodyEditor;
import com.kms.katalon.composer.webservice.util.XPathUtils;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.entity.webservice.TextBodyContent;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SoapPrettyEditor
extends Composite
implements ResponseBodyEditor,
MirrorEditor.EditorChangeListener {
    private static final String[] TEXT_MODE_NAMES = TextContentType.getTextValues();
    private static final int JSON_TOKEN_SIZE = 4;
    private static final int XML_TOKEN_SIZE = 5;
    private static final int JSON_PROP_VALUE_TOKEN_IDX = 3;
    private static final int XML_PROP_VALUE_TOKEN_IDX = 4;
    private Map<TextContentType, Map<Integer, String>> lineIndexing = new HashMap<TextContentType, Map<Integer, String>>();
    private TextContentType preferedContentType;
    private TextBodyContent textBodyContent;
    private MirrorEditor mirrorEditor;
    private Button chckWrapLine;
    private Collection<VerificationScriptEventHandler> eventHanders = new LinkedList<VerificationScriptEventHandler>();

    public SoapPrettyEditor(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.mirrorEditor = new MirrorEditor((Composite)this, 0);
        this.mirrorEditor.setEditable(false);
        this.mirrorEditor.registerDocumentHandler(new DocumentReadyHandler(){

            public void onDocumentReady() {
                SoapPrettyEditor.this.handleControlModifyListener();
                SoapPrettyEditor.this.mirrorEditor.changeMode(TextContentType.XML.getText());
                SoapPrettyEditor.this.mirrorEditor.beautify();
            }
        });
        this.mirrorEditor.addEventListener((MirrorEditor.EditorChangeListener)this);
        Composite bottomComposite = new Composite((Composite)this, 0);
        GridLayout bottomLayout = new GridLayout(2, false);
        bottomLayout.marginHeight = 0;
        bottomLayout.marginWidth = 0;
        bottomLayout.marginBottom = 10;
        bottomComposite.setLayout((Layout)bottomLayout);
        bottomComposite.setLayoutData((Object)new GridData(768));
        this.chckWrapLine = new Button(bottomComposite, 32);
        this.chckWrapLine.setText(ComposerWebserviceMessageConstants.PA_LBL_WRAP_LINE);
        this.chckWrapLine.setSelection(true);
    }

    private void handleControlModifyListener() {
        this.chckWrapLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SoapPrettyEditor.this.mirrorEditor.wrapLine(SoapPrettyEditor.this.chckWrapLine.getSelection());
            }
        });
    }

    @Override
    public String getContentType() {
        return this.textBodyContent.getContentType();
    }

    @Override
    public void setContentBody(ResponseObject responseObject) throws IOException {
        this.textBodyContent = new TextBodyContent();
        this.textBodyContent.setText(responseObject.getResponseText());
        this.textBodyContent.setContentType(responseObject.getContentType());
        String text = this.textBodyContent.getText();
        this.mirrorEditor.setText(text);
        this.mirrorEditor.changeMode(TextContentType.XML.getText());
        this.mirrorEditor.beautify();
        if (TextContentType.XML.getContentType().equals(responseObject.getContentType()) && StringUtils.isNotEmpty((CharSequence)text)) {
            this.preferedContentType = TextContentType.XML;
            this.lineIndexing.put(this.preferedContentType, XPathUtils.evaluateXmlProperty(text));
        }
    }

    @Override
    public void switchModeContentBody(ResponseObject responseObject) throws IOException {
        if (responseObject != null) {
            if (this.textBodyContent == null) {
                this.setContentBody(responseObject);
            } else {
                this.textBodyContent.setContentType(responseObject.getContentType());
            }
        }
    }

    public void handleEditorEvent(String event, Object[] objects) {
        switch (event) {
            case "handleMouseOverChanged": {
                if (objects == null || objects.length != 1 || !(objects[0] instanceof String)) {
                    return;
                }
                JsonObject positionJsonObject = (JsonObject)new Gson().fromJson((String)objects[0], JsonObject.class);
                int line = positionJsonObject.get("line").getAsInt();
                Map<Integer, String> jsonPathCollection = this.lineIndexing.get(this.preferedContentType);
                if (jsonPathCollection.containsKey(line)) {
                    String hintText = XPathUtils.getXmlPropertyForSoapBody(jsonPathCollection.get(line));
                    this.mirrorEditor.setHintText(hintText);
                    break;
                }
                this.mirrorEditor.setHintText("");
                break;
            }
            case "handleGenerateVerificationEvent": {
                if (objects == null || objects.length != 2) {
                    return;
                }
                if (!this.preferedContentType.getContentType().equals(this.textBodyContent.getContentType())) {
                    return;
                }
                int line = ((Number)objects[0]).intValue();
                Map<Integer, String> propertyCollection = this.lineIndexing.get(this.preferedContentType);
                if (!propertyCollection.containsKey(line)) {
                    return;
                }
                String propertyName = propertyCollection.get(line);
                Object propertyValue = "";
                JsonArray lineTokensJson = (JsonArray)new Gson().fromJson((String)objects[1], JsonArray.class);
                switch (this.preferedContentType) {
                    case JSON: {
                        JsonObject jsObject;
                        if (lineTokensJson.size() < 4 || (jsObject = lineTokensJson.get(3).getAsJsonObject()).get("type").isJsonNull()) break;
                        propertyValue = jsObject.get("string").getAsString();
                        break;
                    }
                    case XML: {
                        if (lineTokensJson.size() < 5) break;
                        propertyValue = "'" + lineTokensJson.get(lineTokensJson.size() - 1).getAsJsonObject().get("string").getAsString().replace("'", "\\'") + "'";
                        break;
                    }
                }
                String script = String.format("WS.verifyElementText(response, '%s', %s)", XPathUtils.getXmlPropertyForSoapBody(propertyName), StringUtils.defaultIfEmpty((CharSequence)propertyValue, (CharSequence)"''"));
                Iterator<VerificationScriptEventHandler> iterator = this.eventHanders.iterator();
                while (iterator.hasNext()) {
                    iterator.next().insertScript(script);
                }
                break;
            }
        }
    }

    public void addHandler(VerificationScriptEventHandler handler) {
        this.eventHanders.add(handler);
    }
}

