/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.soap.response.body;

import com.kms.katalon.composer.components.impl.constants.TextContentType;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.parts.VerificationScriptEventHandler;
import com.kms.katalon.composer.webservice.response.body.RawEditor;
import com.kms.katalon.composer.webservice.response.body.ResponseBodyEditor;
import com.kms.katalon.composer.webservice.soap.response.body.SoapPrettyEditor;
import com.kms.katalon.composer.webservice.util.WebServiceUtil;
import com.kms.katalon.core.testobject.ResponseObject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.FrameworkUtil;

public class SoapResponseBodyEditorsComposite
extends Composite {
    protected final String WS_BUNDLE_NAME = FrameworkUtil.getBundle(SoapResponseBodyEditorsComposite.class).getSymbolicName();
    private Map<SoapEditorMode, ResponseBodyEditor> bodyEditors = new HashMap<SoapEditorMode, ResponseBodyEditor>();
    private Map<SoapEditorMode, Button> bodySelectionButtons = new HashMap<SoapEditorMode, Button>();
    private Button prettyRadio;
    private Button rawRadio;
    private Link saveResponseLink;
    private StackLayout slBodyContent;
    private ResponseObject responseObject;
    private SoapEditorMode selectedEditorMode;
    private final String PRETTY_MODE_DEFAULT_CONTENT_TYPE = TextContentType.XML.getContentType().toString();
    private final String PRETTY_MODE_DEFAULT_INITAL_MESSAGE = "";

    public SoapResponseBodyEditorsComposite(Composite parent, int style, VerificationScriptEventHandler eventHandler) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        Composite bodyTypeComposite = new Composite((Composite)this, 0);
        bodyTypeComposite.setLayoutData((Object)new GridData(768));
        GridLayout glBodyType = new GridLayout(2, false);
        glBodyType.marginHeight = 0;
        glBodyType.marginWidth = 0;
        bodyTypeComposite.setLayout((Layout)glBodyType);
        Composite bodyContentComposite = new Composite((Composite)this, 0);
        bodyContentComposite.setLayoutData((Object)new GridData(1808));
        this.slBodyContent = new StackLayout();
        bodyContentComposite.setLayout((Layout)this.slBodyContent);
        Composite tbBodyType = new Composite(bodyTypeComposite, 0);
        tbBodyType.setLayout((Layout)new GridLayout(3, false));
        tbBodyType.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.prettyRadio = new Button(tbBodyType, 16);
        this.prettyRadio.setText(SoapEditorMode.PRETTY.toString().toLowerCase());
        this.bodySelectionButtons.put(SoapEditorMode.PRETTY, this.prettyRadio);
        SoapPrettyEditor mirrorEditor = new SoapPrettyEditor(bodyContentComposite, 0);
        this.bodyEditors.put(SoapEditorMode.PRETTY, mirrorEditor);
        mirrorEditor.addHandler(eventHandler);
        this.rawRadio = new Button(tbBodyType, 16);
        this.rawRadio.setText(SoapEditorMode.RAW.toString().toLowerCase());
        this.bodySelectionButtons.put(SoapEditorMode.RAW, this.rawRadio);
        RawEditor rawEditor = new RawEditor(bodyContentComposite, 0);
        this.bodyEditors.put(SoapEditorMode.RAW, rawEditor);
        this.saveResponseLink = new Link(tbBodyType, 0);
        this.saveResponseLink.setText("<a>Save Response</a>");
        GridData saveResponseGridData = new GridData(131072, 0x1000000, true, false);
        this.saveResponseLink.setLayoutData((Object)saveResponseGridData);
        this.saveResponseLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServiceUtil.openDialogAndSaveResponseBody(SoapResponseBodyEditorsComposite.this.responseObject);
            }
        });
        this.saveResponseLink.setEnabled(false);
        this.handleControlModifyListeners();
        ResponseObject defaultResponseOb = new ResponseObject();
        defaultResponseOb.setContentType(this.PRETTY_MODE_DEFAULT_CONTENT_TYPE);
        defaultResponseOb.setResponseText("");
        this.setInput(defaultResponseOb);
    }

    public void setInput(ResponseObject responseOb) {
        try {
            this.responseObject = responseOb.clone();
            this.selectedEditorMode = SoapEditorMode.PRETTY;
            this.bodySelectionButtons.entrySet().forEach(e -> ((Button)e.getValue()).setSelection(false));
            Button selectedButton = this.bodySelectionButtons.get((Object)this.selectedEditorMode);
            selectedButton.setSelection(true);
            for (ResponseBodyEditor childEditor : this.bodyEditors.values()) {
                childEditor.setContentBody(this.responseObject);
            }
            Composite selectedEditor = (Composite)this.bodyEditors.get((Object)this.selectedEditorMode);
            this.slBodyContent.topControl = selectedEditor;
            selectedEditor.getParent().layout();
            boolean shouldEnableSaveResponseLink = this.responseObject != null && this.responseObject.getResponseBodySize() > 0L;
            this.saveResponseLink.setEnabled(shouldEnableSaveResponseLink);
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
            ErrorDialog.openError((Shell)this.getShell(), (String)StringConstants.ERROR_TITLE, (String)"There was problem while parsing the response object.", (IStatus)new Status(4, this.WS_BUNDLE_NAME, ex.getMessage(), (Throwable)ex));
        }
    }

    public ResponseObject getResponseObject() {
        return this.responseObject;
    }

    private void handleControlModifyListeners() {
        SelectionAdapter bodyTypeSelectedListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    try {
                        SoapResponseBodyEditorsComposite.this.selectedEditorMode = SoapEditorMode.valueOf(source.getText().toUpperCase());
                        ResponseBodyEditor editorComposite = SoapResponseBodyEditorsComposite.this.bodyEditors.get((Object)SoapResponseBodyEditorsComposite.this.selectedEditorMode);
                        editorComposite.switchModeContentBody(SoapResponseBodyEditorsComposite.this.responseObject);
                        SoapResponseBodyEditorsComposite.this.slBodyContent.topControl = (Composite)editorComposite;
                        ((Composite)editorComposite).getParent().layout();
                    }
                    catch (Exception ex) {
                        LoggerSingleton.logError((Throwable)ex);
                        ErrorDialog.openError((Shell)SoapResponseBodyEditorsComposite.this.getShell(), (String)StringConstants.ERROR_TITLE, (String)"There was problem while parsing the response object.", (IStatus)new Status(4, SoapResponseBodyEditorsComposite.this.WS_BUNDLE_NAME, ex.getMessage(), (Throwable)ex));
                    }
                }
            }
        };
        this.bodySelectionButtons.values().forEach(button -> button.addSelectionListener((SelectionListener)bodyTypeSelectedListener));
        this.bodyEditors.values().forEach(editor -> ((Composite)editor).addListener(24, event -> this.responseObject.setContentType(editor.getContentType())));
    }

    private static enum SoapEditorMode {
        PRETTY,
        RAW;

    }
}

