/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class JsonPathUtils {
    public static Map<Integer, String> evaluateJsonPath(String jsonString) throws IOException {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return Collections.emptyMap();
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(jsonString);
        IndexedJsonNode indexedNode = new IndexedJsonNode();
        indexedNode.key = "";
        indexedNode.index = 0;
        indexedNode.jsonPath = "$";
        indexedNode.jsonProperty = "";
        indexedNode.startLine = 0;
        indexedNode.endLine = 0;
        IndexedJsonNode evaluatedRootNode = JsonPathUtils.walk(null, indexedNode, rootNode);
        return JsonPathUtils.collectJsonPath(evaluatedRootNode);
    }

    public static Map<Integer, String> evaluateJsonProperty(String jsonString) throws IOException {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return Collections.emptyMap();
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(jsonString);
        IndexedJsonNode indexedNode = new IndexedJsonNode();
        indexedNode.key = "";
        indexedNode.index = 0;
        indexedNode.jsonPath = "$";
        indexedNode.jsonProperty = "";
        indexedNode.startLine = 0;
        indexedNode.endLine = 0;
        IndexedJsonNode evaluatedRootNode = JsonPathUtils.walk(null, indexedNode, rootNode);
        return JsonPathUtils.collectJsonProperty(evaluatedRootNode);
    }

    private static Map<Integer, String> collectJsonPath(IndexedJsonNode node) {
        HashMap<Integer, String> jsonPathCollection = new HashMap<Integer, String>();
        jsonPathCollection.put(node.startLine, node.jsonPath);
        for (IndexedJsonNode childNode : node.children) {
            jsonPathCollection.putAll(JsonPathUtils.collectJsonPath(childNode));
        }
        return jsonPathCollection;
    }

    private static Map<Integer, String> collectJsonProperty(IndexedJsonNode node) {
        HashMap<Integer, String> jsonPathCollection = new HashMap<Integer, String>();
        jsonPathCollection.put(node.startLine, node.jsonProperty);
        for (IndexedJsonNode childNode : node.children) {
            jsonPathCollection.putAll(JsonPathUtils.collectJsonProperty(childNode));
        }
        return jsonPathCollection;
    }

    private static IndexedJsonNode walk(IndexedJsonNode parentIndexedNode, IndexedJsonNode indexedNode, JsonNode node) {
        if (parentIndexedNode == null) {
            indexedNode.startLine = 0;
            indexedNode.endLine = 0;
        } else {
            indexedNode.endLine = indexedNode.startLine = parentIndexedNode.endLine + 1;
        }
        switch (node.getNodeType()) {
            case ARRAY: {
                Iterator childrenIterator = node.iterator();
                int index = 0;
                while (childrenIterator.hasNext()) {
                    JsonNode childNode = (JsonNode)childrenIterator.next();
                    IndexedJsonNode indexedChild = new IndexedJsonNode();
                    indexedChild.index = index;
                    indexedChild.jsonPath = indexedNode.jsonPath + "[" + index + "]";
                    indexedChild.jsonProperty = indexedNode.jsonProperty + "[" + index + "]";
                    indexedChild.key = "";
                    JsonPathUtils.walk(indexedNode, indexedChild, childNode);
                    indexedNode.endLine = indexedChild.endLine;
                    indexedNode.children.add(indexedChild);
                    ++index;
                }
                break;
            }
            case OBJECT: {
                Iterator childrenIterator = node.fields();
                int index = 0;
                while (childrenIterator.hasNext()) {
                    Map.Entry childEntry = (Map.Entry)childrenIterator.next();
                    JsonNode childNode = (JsonNode)childEntry.getValue();
                    IndexedJsonNode indexedChild = new IndexedJsonNode();
                    indexedChild.index = index;
                    indexedChild.jsonPath = indexedNode.jsonPath + "." + (String)childEntry.getKey();
                    indexedChild.jsonProperty = (String)(indexedNode.jsonProperty.isEmpty() ? "" : indexedNode.jsonProperty + ".") + (String)childEntry.getKey();
                    indexedChild.key = (String)childEntry.getKey();
                    JsonPathUtils.walk(indexedNode, indexedChild, childNode);
                    indexedNode.endLine = indexedChild.endLine;
                    indexedNode.children.add(indexedChild);
                    ++index;
                }
                ++indexedNode.endLine;
                break;
            }
        }
        return indexedNode;
    }

    private static class IndexedJsonNode {
        private String key;
        private int index;
        private String jsonPath;
        private String jsonProperty;
        private int startLine;
        private int endLine;
        private List<IndexedJsonNode> children = new ArrayList<IndexedJsonNode>();

        private IndexedJsonNode() {
        }

        public String toString() {
            return "IndexedJsonNode [key=" + this.key + ", index=" + this.index + ", jsonPath=" + this.jsonPath + ", jsonProperty=" + this.jsonProperty + ", startLine=" + this.startLine + ", endLine=" + this.endLine + ", children=" + String.valueOf(this.children) + "]\n";
        }
    }
}

