/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.composer.components.impl.dialogs.CustomTitleAreaDialog;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.parser.SwaggerParserUtil;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportWebServiceObjectsFromSwaggerDialog
extends CustomTitleAreaDialog {
    private FolderEntity parentFolder;
    private List<WebServiceRequestEntity> webServiceRequestEntities;
    private String directory = "";

    public ImportWebServiceObjectsFromSwaggerDialog(Shell parentShell, FolderEntity parentFolder) {
        super(parentShell);
        Trackings.trackOpenImportingSwagger();
        this.parentFolder = parentFolder;
    }

    public void createWebServiceRequestEntities() throws Exception {
        this.webServiceRequestEntities = SwaggerParserUtil.newWSTestObjectsFromSwagger(this.parentFolder, this.directory);
    }

    public List<WebServiceRequestEntity> getWebServiceRequestEntities() {
        return this.webServiceRequestEntities;
    }

    protected void okPressed() {
        if (!DialogUtil.getCanClickOK((Shell)this.getShell())) {
            return;
        }
        Button ok = this.getButton(0);
        boolean closeTheDialog = true;
        try {
            try {
                this.createWebServiceRequestEntities();
            }
            catch (Exception exception) {
                closeTheDialog = false;
                this.setMessage(StringConstants.EXC_INVALID_SWAGGER_FILE, 3);
                this.getShell().pack();
                ok.setEnabled(false);
                if (closeTheDialog) {
                    super.okPressed();
                }
            }
        }
        finally {
            if (closeTheDialog) {
                super.okPressed();
            }
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(StringConstants.VIEW_DIA_TITLE_WEBSERVICE_REQ_SWAGGER);
    }

    protected Composite createContentArea(Composite parent) {
        this.setDialogTitle(StringConstants.VIEW_DIA_TITLE_WEBSERVICE_REQ_SWAGGER);
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).fillHorizontal().build();
        ComponentBuilder.label((Composite)container).text("File location or URL: ").fillHorizontal().build();
        Composite browseContainer = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2).fillHorizontal().build();
        Text text = (Text)ComponentBuilder.text((Composite)browseContainer, (int)2048).fillHorizontal().onChange(event -> {
            Button ok = this.getButton(0);
            if (!ok.isEnabled()) {
                ok.setEnabled(true);
            }
            this.directory = ((Text)event.widget).getText();
        }).build();
        ComponentBuilder.button((Composite)browseContainer, (int)8).text(StringConstants.BROWSE).onSelection(event -> {
            this.getShell().pack();
            FileDialog directoryDialog = new FileDialog(this.getParentShell());
            String filePath = directoryDialog.open();
            text.setText(filePath);
            this.directory = filePath;
        }).build();
        if (this.messageLabel != null) {
            this.messageLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Program.launch((String)"https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md");
                }
            });
            this.setMessage(StringConstants.DIA_MSG_IMPORT_WEBSERVICE_REQ_SWAGGER, 1);
        }
        return container;
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        return size;
    }

    public String getSwaggerSpecLocation() {
        return this.directory;
    }

    protected boolean canHandleShellCloseEvent() {
        return true;
    }

    protected void handleShellCloseEvent() {
        if (!DialogUtil.getCanClose((Shell)this.getShell())) {
            return;
        }
        super.handleShellCloseEvent();
    }
}

