/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.wadl;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.importer.AbstractWebServiceImporter;
import com.kms.katalon.composer.webservice.importing.model.RestMethodImportResult;
import com.kms.katalon.composer.webservice.importing.model.RestParameterImportResult;
import com.kms.katalon.composer.webservice.importing.model.RestResourceImportResult;
import com.kms.katalon.composer.webservice.importing.model.RestServiceImportResult;
import com.kms.katalon.composer.webservice.wadl.WadlImportResult;
import com.kms.katalon.composer.webservice.wadl.WadlRequestImportResult;
import com.kms.katalon.core.webservice.definition.WebServiceDefinitionLoader;
import com.kms.katalon.entity.folder.FolderEntity;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.dev.wadl.x2009.x02.ApplicationDocument;
import net.java.dev.wadl.x2009.x02.DocDocument;
import net.java.dev.wadl.x2009.x02.MethodDocument;
import net.java.dev.wadl.x2009.x02.ParamDocument;
import net.java.dev.wadl.x2009.x02.ParamStyle;
import net.java.dev.wadl.x2009.x02.ResourceDocument;
import net.java.dev.wadl.x2009.x02.ResourceTypeDocument;
import net.java.dev.wadl.x2009.x02.ResourcesDocument;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WadlImporter
extends AbstractWebServiceImporter {
    private static final String WADL11_NS = "http://wadl.dev.java.net/2009/02";
    private static final Pattern PROPERTY_EXPANSION_CONTAINS_PATTERN = Pattern.compile("(\\$\\{(.*?)\\})|(%24%7B.*?%7D)|(%2524%257B.*?%257D)|(%252524%25257B.*?%25257D)");
    private ApplicationDocument.Application application;
    private List<ResourcesDocument.Resources> resourcesList;
    private Map<String, ApplicationDocument> refCache = new HashMap<String, ApplicationDocument>();

    public WadlImportResult importWadl(WebServiceDefinitionLoader definitionLoader, FolderEntity rootFolder) throws Exception {
        XmlObject xmlObject = XmlObject.Factory.parse((InputStream)definitionLoader.load());
        String content = this.removePropertyExpansions(xmlObject.xmlText());
        Element element = ((Document)xmlObject.getDomNode()).getDocumentElement();
        if (element.getLocalName().equals("application") && element.getNamespaceURI().startsWith("http://research.sun.com/wadl")) {
            content = content.replaceAll("\"" + element.getNamespaceURI() + "\"", "\"http://wadl.dev.java.net/2009/02\"");
        } else if (!element.getLocalName().equals("application") || !element.getNamespaceURI().equals(WADL11_NS)) {
            throw new IllegalArgumentException("Document is not a WADL application with http://wadl.dev.java.net/2009/02 namespace");
        }
        WadlImportResult importResult = new WadlImportResult(definitionLoader.getDefinitionLocation(), rootFolder);
        ApplicationDocument applicationDocument = ApplicationDocument.Factory.parse((String)content);
        this.application = applicationDocument.getApplication();
        this.resourcesList = Arrays.asList(this.application.getResourcesArray());
        String serviceName = this.getFirstTitle(this.application.getDocArray(), "Imported from WADL");
        RestServiceImportResult serviceImportResult = importResult.newService(this.toValidFileName(serviceName));
        String base = this.resourcesList.size() == 1 ? this.resourcesList.get(0).getBase() : "";
        try {
            URL baseURL = new URL(base);
            serviceImportResult.setBasePath(baseURL.getPath());
            serviceImportResult.setEndpoint(this.getEndpointFromUrl(baseURL));
        }
        catch (Exception exception) {
            serviceImportResult.setBasePath(base);
        }
        for (ResourcesDocument.Resources resources : this.resourcesList) {
            RestResourceImportResult baseResourceImportResult = null;
            if (this.resourcesList.size() > 1) {
                String path = resources.getBase();
                String baseResourceFolderName = this.getResourceFolderName(serviceImportResult, path);
                baseResourceImportResult = serviceImportResult.newResource(baseResourceFolderName, path);
            }
            ResourceDocument.Resource[] resourceArray = resources.getResourceArray();
            int n = resourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceDocument.Resource resource = resourceArray[n2];
                String title = this.getFirstTitle(resource.getDocArray(), resource.getPath());
                String path = resource.getPath();
                RestResourceImportResult newResourceImportResult = null;
                if (baseResourceImportResult != null && path != null) {
                    resourceName = this.getResourceFolderName(baseResourceImportResult, title);
                    for (RestResourceImportResult res : baseResourceImportResult.getChildResourceImportResults()) {
                        if (!path.equals(res.getPath())) continue;
                        newResourceImportResult = res;
                        break;
                    }
                    if (newResourceImportResult == null) {
                        newResourceImportResult = baseResourceImportResult.newResource(resourceName, path);
                    }
                } else if (path != null) {
                    for (RestResourceImportResult res : serviceImportResult.getResourceImportResults()) {
                        if (!path.equals(res.getPath())) continue;
                        newResourceImportResult = res;
                        break;
                    }
                    if (newResourceImportResult == null) {
                        resourceName = this.getResourceFolderName(serviceImportResult, title);
                        newResourceImportResult = serviceImportResult.newResource(resourceName, path);
                    }
                } else {
                    resourceName = this.getResourceFolderName(serviceImportResult, title);
                    newResourceImportResult = serviceImportResult.newResource(resourceName, "");
                }
                this.initResourceFromWadlResource(newResourceImportResult, resource);
                this.addSubResources(newResourceImportResult, resource);
                ++n2;
            }
        }
        return importResult;
    }

    private String getResourceFolderName(RestServiceImportResult serviceImportResult, String suggestion) {
        if (StringUtils.isBlank((CharSequence)suggestion)) {
            suggestion = "Resource";
        }
        suggestion = this.toValidFileName(suggestion);
        return suggestion;
    }

    private String getResourceFolderName(RestResourceImportResult resourceImportResult, String suggestion) {
        if (StringUtils.isBlank((CharSequence)suggestion)) {
            suggestion = "Resource";
        }
        suggestion = this.toValidFileName(suggestion);
        return suggestion;
    }

    private void addSubResources(RestResourceImportResult newRestResourceImportResult, ResourceDocument.Resource resource) {
        ResourceDocument.Resource[] resourceArray = resource.getResourceArray();
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceDocument.Resource res = resourceArray[n2];
            String path = res.getPath();
            if (path == null) {
                path = "";
            }
            String title = this.getFirstTitle(res.getDocArray(), path);
            String name = this.getResourceFolderName(newRestResourceImportResult, title);
            RestResourceImportResult newChildResourceImportResult = null;
            for (RestResourceImportResult child : newRestResourceImportResult.getChildResourceImportResults()) {
                if (!path.equals(child.getPath())) continue;
                newRestResourceImportResult = child;
                break;
            }
            if (newChildResourceImportResult == null) {
                newChildResourceImportResult = newRestResourceImportResult.newResource(name, path);
            }
            this.initResourceFromWadlResource(newChildResourceImportResult, res);
            this.addSubResources(newChildResourceImportResult, res);
            ++n2;
        }
    }

    private String getFirstTitle(DocDocument.Doc[] docs, String defaultTitle) {
        DocDocument.Doc[] docArray = docs;
        int n = docs.length;
        int n2 = 0;
        while (n2 < n) {
            DocDocument.Doc doc = docArray[n2];
            if (StringUtils.isNotBlank((CharSequence)doc.getTitle())) {
                return doc.getTitle();
            }
            ++n2;
        }
        return defaultTitle;
    }

    private String removePropertyExpansions(String definition) {
        Matcher matcher = PROPERTY_EXPANSION_CONTAINS_PATTERN.matcher(definition);
        return matcher.replaceAll("");
    }

    public String getEndpointFromUrl(URL baseUrl) {
        StringBuilder result = new StringBuilder();
        result.append(baseUrl.getProtocol()).append("://");
        result.append(baseUrl.getHost());
        if (baseUrl.getPort() > 0) {
            result.append(':').append(baseUrl.getPort());
        }
        return result.toString();
    }

    private void initResourceFromWadlResource(RestResourceImportResult resourceImportResult, ResourceDocument.Resource resource) {
        ParamDocument.Param[] paramArray = resource.getParamArray();
        int n = paramArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParamDocument.Param param = paramArray[n2];
            if ((param = this.resolveParameter(param)) != null) {
                String nm = param.getName();
                RestParameterImportResult parameterImportResult = resourceImportResult.hasParameter(nm) ? resourceImportResult.getParameter(nm) : resourceImportResult.addNewParameter(nm);
                this.initParam(param, parameterImportResult);
            }
            ++n2;
        }
        paramArray = resource.getMethodArray();
        n = paramArray.length;
        n2 = 0;
        while (n2 < n) {
            ParamDocument.Param method = paramArray[n2];
            method = this.resolveMethod((MethodDocument.Method)method);
            this.initMethod(resourceImportResult, (MethodDocument.Method)method);
            ++n2;
        }
        List types = resource.getType();
        if (types != null && types.size() > 0) {
            for (Object obj : types) {
                ResourceTypeDocument.ResourceType type = this.resolveResource(obj.toString());
                if (type == null) continue;
                MethodDocument.Method[] methodArray = type.getMethodArray();
                int n3 = methodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    MethodDocument.Method method = methodArray[n4];
                    method = this.resolveMethod(method);
                    RestMethodImportResult methodImportResult = this.initMethod(resourceImportResult, method);
                    ParamDocument.Param[] paramArray2 = type.getParamArray();
                    int n5 = paramArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ParamDocument.Param param = paramArray2[n6];
                        if ((param = this.resolveParameter(param)) != null) {
                            String nm = param.getName();
                            RestParameterImportResult parameterImportResult = methodImportResult.hasParameter(nm) ? methodImportResult.getParameter(nm) : methodImportResult.addNewParameter(nm);
                            this.initParam(param, parameterImportResult);
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
        }
    }

    private void initParam(ParamDocument.Param param, RestParameterImportResult parameterImportResult) {
        parameterImportResult.setValue(param.getDefault());
        ParamStyle.Enum paramStyle = param.getStyle();
        if (paramStyle == null) {
            paramStyle = ParamStyle.QUERY;
        }
        parameterImportResult.setStyle(RestParameterImportResult.Style.valueOf(paramStyle.toString().toUpperCase()));
    }

    private MethodDocument.Method resolveMethod(MethodDocument.Method method) {
        String href = method.getHref();
        if (StringUtils.isBlank((CharSequence)href)) {
            return method;
        }
        MethodDocument.Method[] methodArray = this.application.getMethodArray();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDocument.Method m = methodArray[n2];
            if (m.getId().equals(href.substring(1))) {
                return m;
            }
            ++n2;
        }
        try {
            ApplicationDocument applicationDocument = this.loadReferencedWadl(href);
            if (applicationDocument != null) {
                int ix = href.lastIndexOf(35);
                if (ix > 0) {
                    href = href.substring(ix + 1);
                }
                MethodDocument.Method[] methodArray2 = this.application.getMethodArray();
                int n3 = methodArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    MethodDocument.Method m = methodArray2[n4];
                    if (m.getId().equals(href)) {
                        return m;
                    }
                    ++n4;
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return method;
    }

    private ApplicationDocument loadReferencedWadl(String id) throws URISyntaxException, XmlException, IOException {
        ApplicationDocument applicationDocument;
        int ix = id.indexOf(35);
        if (ix != -1) {
            id = id.substring(0, ix);
        }
        if ((applicationDocument = this.refCache.get(id)) == null) {
            URI uri = new URI(id);
            applicationDocument = ApplicationDocument.Factory.parse((URL)uri.toURL());
            this.refCache.put(id, applicationDocument);
        }
        return applicationDocument;
    }

    private RestMethodImportResult initMethod(RestResourceImportResult resourceImportResult, MethodDocument.Method method) {
        String name = this.getFirstTitle(method.getDocArray(), method.getName());
        name = this.getMethodFolderName(resourceImportResult, name);
        RestMethodImportResult methodImportResult = resourceImportResult.newMethod(name, method.getName());
        if (method.getRequest() != null) {
            ParamDocument.Param[] paramArray = method.getRequest().getParamArray();
            int n2 = paramArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ParamDocument.Param param = paramArray[n3];
                if ((param = this.resolveParameter(param)) != null) {
                    RestParameterImportResult parameterImportResult = methodImportResult.addNewParameter(param.getName());
                    this.initParam(param, parameterImportResult);
                }
                ++n3;
            }
        }
        WadlRequestImportResult request = methodImportResult.newRequest("Request 1", n -> new WadlRequestImportResult((String)n, methodImportResult));
        String httpMethod = (String)StringUtils.defaultIfBlank((CharSequence)method.getName(), (CharSequence)"GET");
        request.setHttpMethod(httpMethod);
        return methodImportResult;
    }

    private String getMethodFolderName(RestResourceImportResult resourceImportResult, String suggestion) {
        if (StringUtils.isBlank((CharSequence)suggestion)) {
            suggestion = "Method";
        }
        suggestion = this.toValidFileName(suggestion);
        return suggestion;
    }

    private ResourceTypeDocument.ResourceType resolveResource(String id) {
        for (ResourceTypeDocument.ResourceType resourceType : Arrays.asList(this.application.getResourceTypeArray())) {
            if (!resourceType.getId().equals(id)) continue;
            return resourceType;
        }
        try {
            ApplicationDocument applicationDocument = this.loadReferencedWadl(id);
            if (applicationDocument != null) {
                int ix = id.lastIndexOf(35);
                if (ix > 0) {
                    id = id.substring(ix + 1);
                }
                ResourceTypeDocument.ResourceType[] resourceTypeArray = applicationDocument.getApplication().getResourceTypeArray();
                int n = resourceTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourceTypeDocument.ResourceType resourceType = resourceTypeArray[n2];
                    if (resourceType.getId().equals(id)) {
                        return resourceType;
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return null;
    }

    private ParamDocument.Param resolveParameter(ParamDocument.Param param) {
        String href = param.getHref();
        if (!StringUtils.isNotBlank((CharSequence)href)) {
            return param;
        }
        try {
            ApplicationDocument.Application app = this.application;
            if (!href.startsWith("#")) {
                ApplicationDocument applicationDocument = this.loadReferencedWadl(href);
                app = applicationDocument.getApplication();
            }
            if (app != null) {
                int ix = href.lastIndexOf(35);
                if (ix >= 0) {
                    href = href.substring(ix + 1);
                }
                ParamDocument.Param[] paramArray = this.application.getParamArray();
                int n = paramArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ParamDocument.Param p = paramArray[n2];
                    if (p.getId().equals(href)) {
                        return p;
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return null;
    }
}

