/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.wadl;

import com.kms.katalon.composer.webservice.importing.model.RestMethodImportResult;
import com.kms.katalon.composer.webservice.importing.model.RestParameterImportResult;
import com.kms.katalon.composer.webservice.importing.model.RestRequestImportResult;
import com.kms.katalon.composer.webservice.importing.model.RestServiceImportResult;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.webservice.FormDataBodyParameter;
import com.kms.katalon.entity.webservice.HttpBodyContent;
import com.kms.katalon.entity.webservice.ParameterizedBodyContent;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class WadlRequestImportResult
extends RestRequestImportResult {
    private static final String MULTIPART_FORM_DATA_CONTENT_TYPE = "multipart/form-data";

    public WadlRequestImportResult(String name, RestMethodImportResult methodResult) {
        super(name, methodResult);
    }

    @Override
    protected String getBaseUrl() {
        String resourcePath;
        String serviceBasePath;
        StringBuilder urlBuilder = new StringBuilder();
        String serviceEndpoint = this.getServiceEndpoint();
        if (StringUtils.isNotBlank((CharSequence)serviceEndpoint)) {
            urlBuilder.append(serviceEndpoint);
            if (serviceEndpoint.endsWith("/")) {
                urlBuilder.deleteCharAt(serviceEndpoint.length() - 1);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(serviceBasePath = this.getServiceBasePath()))) {
            urlBuilder.append(serviceBasePath);
        }
        if (StringUtils.isNotBlank((CharSequence)(resourcePath = this.getResourcePath()))) {
            urlBuilder.append(resourcePath);
        }
        return urlBuilder.toString();
    }

    @Override
    protected List<RestParameterImportResult> getUrlQueryParameters() {
        List<RestParameterImportResult> queryParameters = this.getQueryParameters();
        if (!queryParameters.isEmpty() && !this.isBodySupported()) {
            return queryParameters;
        }
        return Collections.emptyList();
    }

    private String getServiceEndpoint() {
        RestServiceImportResult serviceImportResult = this.getServiceImportResult();
        return serviceImportResult.getEndpoint();
    }

    @Override
    protected List<WebElementPropertyEntity> getRequestHeaders() {
        List<RestParameterImportResult> headerParameters = this.getHeaderParameters();
        return headerParameters.stream().map(p -> {
            WebElementPropertyEntity headerPropertyEntity = new WebElementPropertyEntity();
            headerPropertyEntity.setName(p.getName());
            headerPropertyEntity.setValue(p.getValue());
            return headerPropertyEntity;
        }).collect(Collectors.toList());
    }

    @Override
    protected String getHttpBodyContent() {
        HttpBodyContent bodyContent = null;
        if (this.isBodySupported()) {
            bodyContent = this.getFormDataBodyContent();
        }
        if (bodyContent != null) {
            return JsonUtil.toJson((Object)bodyContent);
        }
        return "";
    }

    @Override
    protected String getHttpBodyType() {
        HttpBodyContent bodyContent = null;
        if (this.isBodySupported()) {
            bodyContent = this.getFormDataBodyContent();
        }
        if (bodyContent != null) {
            return "form-data";
        }
        return "";
    }

    private HttpBodyContent getFormDataBodyContent() {
        List<FormDataBodyParameter> bodyParameters = this.getFormDataBodyParameters();
        if (bodyParameters != null && !bodyParameters.isEmpty()) {
            ParameterizedBodyContent httpBody = new ParameterizedBodyContent();
            bodyParameters.stream().forEach(p -> httpBody.addParameter(p));
            httpBody.setContentType(MULTIPART_FORM_DATA_CONTENT_TYPE);
            httpBody.setCharset(StandardCharsets.UTF_8.name());
            return httpBody;
        }
        return null;
    }

    private List<FormDataBodyParameter> getFormDataBodyParameters() {
        List<RestParameterImportResult> queryParameters = this.getQueryParameters();
        return queryParameters.stream().map(p -> {
            FormDataBodyParameter formDataParameter = new FormDataBodyParameter();
            formDataParameter.setName(p.getName());
            formDataParameter.setValue(p.getValue());
            return formDataParameter;
        }).collect(Collectors.toList());
    }

    private boolean isBodySupported() {
        List<String> BODY_SUPPORTED_METHODS = Arrays.asList("POST", "PUT", "DELETE", "PATCH");
        return BODY_SUPPORTED_METHODS.contains(this.httpMethod);
    }
}

