/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.configuration.impl;

import com.kms.katalon.configuration.core.interfaces.IHostConfiguration;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class LocalHostConfiguration
implements IHostConfiguration {
    private int port = -1;

    public String getOS() {
        return ExecutionUtil.getLocalOS();
    }

    public String getHostName() {
        return ExecutionUtil.getLocalHostName();
    }

    public String getHostAddress() {
        return ExecutionUtil.getLocalHostAddress();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getHostPort() {
        int n;
        if (this.port >= 0) {
            return this.port;
        }
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            n = this.port = socket.getLocalPort();
        }
        catch (IOException e) {
            try {
                LogUtil.logError((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(socket);
                throw throwable;
            }
            IOUtils.closeQuietly((ServerSocket)socket);
            return -1;
        }
        IOUtils.closeQuietly((ServerSocket)socket);
        return n;
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("hostName", this.getHostName());
        properties.put("os", this.getOS());
        properties.put("hostAddress", this.getHostAddress());
        properties.put("hostPort", this.getHostPort());
        return properties;
    }
}

