/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.console;

import com.katalon.platform.api.event.ExecutionEvent;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.core.windows.driver.FlaUIDriverManager;
import com.kms.katalon.core.windows.driver.WindowsDriverType;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.addon.ExecutionBundleActivator;
import com.kms.katalon.execution.collector.ConsoleOptionCollector;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.ConsoleOptionContributor;
import com.kms.katalon.execution.console.entity.LauncherOptionParser;
import com.kms.katalon.execution.console.entity.TestSuiteCollectionLauncherOptionParser;
import com.kms.katalon.execution.console.entity.TestSuiteLauncherOptionParser;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.entity.TestSuiteExecutionEvent;
import com.kms.katalon.execution.exception.InvalidConsoleArgumentException;
import com.kms.katalon.execution.launcher.IConsoleLauncher;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.ReportableLauncher;
import com.kms.katalon.execution.launcher.TestSuiteCollectionConsoleLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import joptsimple.OptionSet;
import org.apache.commons.lang.StringUtils;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ConsoleExecutor {
    private List<LauncherOptionParser> launcherOptions = new ArrayList<LauncherOptionParser>();
    private List<ConsoleOptionContributor> optionalOptions;

    public ConsoleExecutor() {
        this.launcherOptions.addAll(Arrays.asList(new TestSuiteLauncherOptionParser(), new TestSuiteCollectionLauncherOptionParser()));
        this.optionalOptions = ConsoleOptionCollector.getInstance().getOptionContributors();
    }

    public void addAndPrioritizeLauncherOptionParser(List<LauncherOptionParser> consoleOptionParser) {
        this.launcherOptions.addAll(0, consoleOptionParser);
    }

    public List<ConsoleOption<?>> getAllConsoleOptions() {
        ArrayList consoleOptions = new ArrayList();
        consoleOptions.addAll(this.getConsoleOptionInContributors(this.launcherOptions));
        consoleOptions.addAll(this.getConsoleOptionInContributors(this.optionalOptions));
        return consoleOptions;
    }

    private List<ConsoleOption<?>> getConsoleOptionInContributors(List<? extends ConsoleOptionContributor> contributors) {
        ArrayList consoleOptions = new ArrayList();
        for (ConsoleOptionContributor consoleOptionContributor : contributors) {
            consoleOptions.addAll(consoleOptionContributor.getConsoleOptionList());
        }
        return consoleOptions;
    }

    public void execute(ProjectEntity projectEntity, OptionSet optionSet) throws Exception {
        this.setValueForOptionalOptions(this.optionalOptions, optionSet);
        LauncherOptionParser launcherOption = new LauncherOptionSelector().getSelectedOption(optionSet);
        List<ConsoleOption<?>> listConsoleOption = launcherOption.getConsoleOptionList();
        for (ConsoleOption<?> consoleOption : listConsoleOption) {
            String option = consoleOption.getOption();
            if (!optionSet.has(option)) continue;
            launcherOption.setArgumentValue(consoleOption, String.valueOf(optionSet.valueOf(consoleOption.getOption())));
        }
        LauncherManager launcherManager = LauncherManager.getInstance();
        IConsoleLauncher launcher = launcherOption.getConsoleLauncher(projectEntity, launcherManager);
        this.registerToTerminateDriverAfterEachTestSuite(launcher);
        launcherManager.addLauncher(launcher);
    }

    private void registerToTerminateDriverAfterEachTestSuite(IConsoleLauncher launcher) {
        ArrayList<ReportableLauncher> launchers = new ArrayList<ReportableLauncher>();
        if (launcher instanceof ReportableLauncher) {
            ReportableLauncher consoleLauncher = (ReportableLauncher)((Object)launcher);
            launchers.add(consoleLauncher);
        }
        if (launcher instanceof TestSuiteCollectionConsoleLauncher) {
            TestSuiteCollectionConsoleLauncher tscConsoleLauncher = (TestSuiteCollectionConsoleLauncher)launcher;
            launchers.addAll(tscConsoleLauncher.getSubLaunchers());
        }
        final HashMap<String, IRunConfiguration> testSuiteSourceIdsNeedToTerminateDriverAfterRun = new HashMap<String, IRunConfiguration>();
        for (ReportableLauncher reportableLauncher : launchers) {
            IRunConfiguration runConfig = reportableLauncher.getRunConfig();
            String testSuiteSourceId = reportableLauncher.buildTestSuiteExecutionContext().getSourceId();
            if (!runConfig.shouldTerminateDriverAfterTestSuite()) continue;
            testSuiteSourceIdsNeedToTerminateDriverAfterRun.put(testSuiteSourceId, runConfig);
        }
        ExecutionBundleActivator.getInstance().getEventBroker().subscribe("KATALON_EXECUTION/TEST_SUITE_FINISHED", new EventHandler(){

            public void handleEvent(Event event) {
                ExecutionEvent eventObject = (ExecutionEvent)event.getProperty("org.eclipse.e4.data");
                TestSuiteExecutionEvent testSuiteExecutionEvent = (TestSuiteExecutionEvent)eventObject;
                IRunConfiguration runConfig = (IRunConfiguration)testSuiteSourceIdsNeedToTerminateDriverAfterRun.get(testSuiteExecutionEvent.getExecutionContext().getSourceId());
                boolean isWindowTestSuite = runConfig.getDriverConnectors().values().stream().anyMatch(connector -> WindowsDriverType.getInstance().equals(connector.getDriverType()));
                if (isWindowTestSuite) {
                    FlaUIDriverManager.getInstance().stopLocalServer();
                }
            }
        });
    }

    public ILauncher getUILauncher(ProjectEntity projectEntity, OptionSet optionSet) throws Exception {
        this.setValueForOptionalOptions(this.optionalOptions, optionSet);
        LauncherOptionParser launcherOption = new LauncherOptionSelector().getSelectedOption(optionSet);
        List<ConsoleOption<?>> listConsoleOption = launcherOption.getConsoleOptionList();
        for (ConsoleOption<?> consoleOption : listConsoleOption) {
            String option = consoleOption.getOption();
            if (!optionSet.has(option)) continue;
            launcherOption.setArgumentValue(consoleOption, String.valueOf(optionSet.valueOf(consoleOption.getOption())));
        }
        return launcherOption.getIDELauncher(projectEntity, LauncherManager.getInstance());
    }

    private void setValueForOptionalOptions(List<ConsoleOptionContributor> optionContributors, OptionSet optionSet) throws Exception {
        for (ConsoleOptionContributor contributor : optionContributors) {
            for (ConsoleOption<?> consoleOption : contributor.getConsoleOptionList()) {
                this.validateRequiredArgument(consoleOption, optionSet);
                String optionName = consoleOption.getOption();
                if (!optionSet.has(optionName) || !consoleOption.hasArgument()) continue;
                contributor.setArgumentValue(consoleOption, String.valueOf(optionSet.valueOf(optionName)));
            }
        }
    }

    private void validateRequiredArgument(ConsoleOption<?> consoleOption, OptionSet optionSet) throws InvalidConsoleArgumentException {
        if (consoleOption.isRequired() && !optionSet.has(consoleOption.getOption())) {
            String optionName = consoleOption.getOption();
            throw new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_MISSING_REQUIRED_ARG, optionName));
        }
    }

    private class LauncherOptionSelector {
        private LauncherOptionSelector() {
        }

        public LauncherOptionParser getSelectedOption(OptionSet optionSet) throws InvalidConsoleArgumentException {
            for (LauncherOptionParser launcherOption : ConsoleExecutor.this.launcherOptions) {
                if (!this.evaluate(launcherOption, optionSet)) continue;
                return launcherOption;
            }
            throw this.buildMissingLauncherArgumentException();
        }

        private InvalidConsoleArgumentException buildMissingLauncherArgumentException() {
            Iterator<LauncherOptionParser> iterator = ConsoleExecutor.this.launcherOptions.iterator();
            StringBuilder messageBuilder = new StringBuilder();
            while (iterator.hasNext()) {
                LauncherOptionParser launcherOption = iterator.next();
                if (StringUtils.isNotEmpty((String)messageBuilder.toString())) {
                    messageBuilder.append(" or ");
                }
                messageBuilder.append(this.getRequiredOptionsString(launcherOption));
            }
            return new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_MISSING_REQUIRED_ARG, messageBuilder.toString()));
        }

        private String getRequiredOptionsString(LauncherOptionParser launcherOption) {
            String requiredOptions = launcherOption.getConsoleOptionList().stream().filter(option -> option.isRequired()).map(option -> "-" + option.getOption()).collect(Collectors.joining(", "));
            return "{" + requiredOptions + "}";
        }

        private boolean evaluate(LauncherOptionParser optionParser, OptionSet optionSet) throws InvalidConsoleArgumentException {
            Iterator<ConsoleOption<?>> iterator = optionParser.getConsoleOptionList().iterator();
            boolean anyRequiesExisted = false;
            while (iterator.hasNext()) {
                ConsoleOption<?> consoleOption = iterator.next();
                if (!consoleOption.isRequired()) continue;
                if (optionSet.has(consoleOption.getOption())) {
                    anyRequiesExisted = true;
                    continue;
                }
                if (anyRequiesExisted) {
                    throw new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_MISSING_REQUIRED_ARG, consoleOption.getOption()));
                }
                return false;
            }
            return anyRequiesExisted;
        }
    }
}

