/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class EmailTemplateUtil {
    private static final String KATALON_STUDIO_EMAIL_SIGNATURE = "Katalon Studio";
    private static final String RESOURCES_TEMPLATE_EMAIL_FOLDER = "resources/template/email";
    private static final String TEST_SUITE_EMAIL_TEMPLATE_HTML = "default_template.html";
    private static final String TEST_SUITE_COLLECTION_EMAIL_TEMPLATE_HTML = "default_collection_template.html";
    private static final String TINY_MCE_TEMPLATE_HTML = "tinymce_template.html";
    public static final String OLD_LOGO_URL = "https://www.katalon.com/wp-content/themes/katalon/images/logo-katalon.png";
    public static final String NEW_LOGO_URL = "https://raw.githubusercontent.com/katalon-studio/docs-images/master/katalon-studio/product-logo/logo-katalon.png";
    private static final Map<File, Configuration> configCache = new ConcurrentHashMap<File, Configuration>();

    public static String getTinyMCETemplate() throws IOException, URISyntaxException {
        File htmlTemplateFile = new File(EmailTemplateUtil.getTemplateFolder(), TINY_MCE_TEMPLATE_HTML);
        String htmlTemplate = FileUtils.readFileToString((File)htmlTemplateFile, (String)"UTF-8");
        return htmlTemplate;
    }

    public static String getHTMLTemplateForTestSuite() throws IOException, URISyntaxException {
        return EmailTemplateUtil.getHTMLTemplateForTestSuite(KATALON_STUDIO_EMAIL_SIGNATURE);
    }

    public static String getHTMLTemplateForTestSuite(String emailSignature) throws IOException, URISyntaxException {
        File templateFile = new File(EmailTemplateUtil.getTemplateFolder(), TEST_SUITE_EMAIL_TEMPLATE_HTML);
        String template = FileUtils.readFileToString((File)templateFile);
        String signature = (String)StringUtils.defaultIfEmpty((CharSequence)emailSignature, (CharSequence)KATALON_STUDIO_EMAIL_SIGNATURE);
        template = template.replace(KATALON_STUDIO_EMAIL_SIGNATURE, signature);
        return template;
    }

    public static String getEmailHTMLTemplateForTestSuiteCollection() throws IOException, URISyntaxException {
        File templateFile = new File(EmailTemplateUtil.getTemplateFolder(), TEST_SUITE_COLLECTION_EMAIL_TEMPLATE_HTML);
        String template = FileUtils.readFileToString((File)templateFile);
        return template;
    }

    public static File getTemplateFolder() throws IOException {
        Bundle bundle = FrameworkUtil.getBundle(EmailTemplateUtil.class);
        URL templateFolderUrl = FileLocator.find((Bundle)bundle, (IPath)new Path(RESOURCES_TEMPLATE_EMAIL_FOLDER), null);
        return FileUtils.toFile((URL)FileLocator.toFileURL((URL)templateFolderUrl));
    }

    private static Configuration createFreeMarkerConfig(File templateDir) throws IOException {
        return configCache.computeIfAbsent(templateDir, dir -> {
            try {
                Configuration cfg = new Configuration(Configuration.VERSION_2_3_31);
                cfg.setDirectoryForTemplateLoading(dir);
                cfg.setDefaultEncoding("UTF-8");
                return cfg;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create FreeMarker configuration", e);
            }
        });
    }

    private static String processFreeMarkerTemplate(File templateFile, Map<String, Object> dataModel) throws IOException, TemplateException {
        if (!templateFile.exists()) {
            return "";
        }
        Configuration cfg = EmailTemplateUtil.createFreeMarkerConfig(templateFile.getParentFile());
        Template template = cfg.getTemplate(templateFile.getName());
        Throwable throwable = null;
        Object var5_6 = null;
        try (StringWriter out = new StringWriter();){
            template.process(dataModel, (Writer)out);
            return out.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getHtmlTemplateForTestSuiteFromFile(String projectPath, Map<String, Object> dataModel) throws IOException, TemplateException {
        File templateFile = Paths.get(projectPath, "settings", "email", TEST_SUITE_EMAIL_TEMPLATE_HTML).toFile();
        return EmailTemplateUtil.processFreeMarkerTemplate(templateFile, dataModel);
    }

    public static String getHtmlTemplateForTestSuiteCollectionFromFile(String projectPath, Map<String, Object> dataModel) throws IOException, TemplateException {
        File templateFile = Paths.get(projectPath, "settings", "email", TEST_SUITE_COLLECTION_EMAIL_TEMPLATE_HTML).toFile();
        return EmailTemplateUtil.processFreeMarkerTemplate(templateFile, dataModel);
    }
}

