/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug;

import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import groovy.lang.Script;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.eclipse.debug.JDITargetDelegate;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaClassObject;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaValue;

public class JDIMetaClass
implements MetaClass {
    private final MetaClass theMetaClass;
    private final IJavaObject jdiMetaClass;
    private final JDITargetDelegate delegate;

    public JDIMetaClass(IJavaObject object, JDITargetDelegate delegate) throws DebugException {
        this(null, delegate.getMetaClass((IJavaValue)object), delegate);
    }

    public JDIMetaClass(MetaClass metaClass, JDITargetDelegate delegate) throws DebugException {
        this(metaClass, delegate.createMetaClassInDebuggedApplication(metaClass), delegate);
    }

    public JDIMetaClass(MetaClass theMetaClass, IJavaObject jdiMetaClass, JDITargetDelegate delegate) {
        this.theMetaClass = theMetaClass;
        this.jdiMetaClass = jdiMetaClass;
        this.delegate = delegate;
    }

    public Object getAttribute(Class sender, Object receiver, String messageName, boolean useSuper) {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public Object getAttribute(Object object, String attribute) {
        try {
            IJavaValue attributeValue = this.sendMessage(this.jdiMetaClass, "getAttribute", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", new IJavaValue[]{this.delegate.toJDIObject(object), this.delegate.getTarget().newValue(attribute)});
            return this.delegate.createProxyFor(attributeValue);
        }
        catch (DebugException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassNode getClassNode() {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public MetaMethod getMetaMethod(String name, Object[] args) {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public List<MetaMethod> getMetaMethods() {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public MetaProperty getMetaProperty(String name) {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public List<MetaMethod> getMethods() {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public List<MetaProperty> getProperties() {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public Object getProperty(Class sender, Object receiver, String property, boolean isCallToSuper, boolean fromInsideClass) {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public Object getProperty(Object object, String property) {
        try {
            IJavaObject target = this.delegate.toJDIObject(object);
            if (!"owner".equals(property) && !"delegate".equals(property) && target instanceof IJavaObject && !target.isNull() && (target.getJavaType().getName().contains("$_closure") || target.getJavaType().getName().contains("$_run_closure"))) {
                try {
                    return this.getProperty(JDIMetaClass.getClosureDelegate((IJavaValue)target), property);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if (target instanceof IJavaObject && !(target instanceof IJavaClassObject)) {
                try {
                    IJavaValue propertyValue = this.sendMessage(target, "getProperty", "(Ljava/lang/String;)Ljava/lang/Object;", this.delegate.getTarget().newValue(property));
                    return this.delegate.createProxyFor(propertyValue);
                }
                catch (DebugException propertyValue) {
                    // empty catch block
                }
            }
            IJavaValue propertyValue = this.sendMessage(this.jdiMetaClass, "getProperty", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", new IJavaValue[]{target, this.delegate.getTarget().newValue(property)});
            return this.delegate.createProxyFor(propertyValue);
        }
        catch (DebugException e) {
            throw new RuntimeException(e);
        }
    }

    public MetaMethod getStaticMetaMethod(String name, Object[] args) {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public Class getTheClass() {
        return this.theMetaClass != null ? this.theMetaClass.getTheClass() : Object.class;
    }

    public MetaProperty hasProperty(Object obj, String name) {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public void initialize() {
    }

    public Object invokeConstructor(Object[] arguments) {
        try {
            IJavaValue newObject = this.sendMessage(this.jdiMetaClass, "invokeConstructor", "([Ljava/lang/Object;)Ljava/lang/Object;", new IJavaValue[]{this.delegate.toJDIObject(arguments)});
            return this.delegate.createProxyFor(newObject);
        }
        catch (DebugException e) {
            throw new RuntimeException(e);
        }
    }

    public Object invokeMethod(Class sender, Object receiver, String methodName, Object[] arguments, boolean isCallToSuper, boolean fromInsideClass) {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public Object invokeMethod(Object object, String methodName, Object arguments) {
        IJavaObject jdiMethodArgs;
        IJavaValue jdiMethodName;
        IJavaValue jdiClosureDelegate;
        IJavaObject jdiMethodTarget;
        try {
            jdiMethodTarget = this.delegate.toJDIObject(object);
        }
        catch (DebugException e) {
            throw new RuntimeException(e);
        }
        if (object instanceof Script && jdiMethodTarget instanceof IJavaClassObject) {
            Object[] objectArray;
            if (arguments instanceof Object[]) {
                objectArray = (Object[])arguments;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = arguments;
            }
            return this.invokeStaticMethod(object, methodName, objectArray);
        }
        try {
            jdiClosureDelegate = JDIMetaClass.getClosureDelegate((IJavaValue)jdiMethodTarget);
            jdiMethodName = this.delegate.getTarget().newValue(methodName);
            jdiMethodArgs = this.delegate.toJDIObject(arguments);
        }
        catch (DebugException e) {
            throw new RuntimeException(e);
        }
        try {
            IJavaValue returnValue = this.sendMessage(this.jdiMetaClass, "invokeMethod", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", new IJavaValue[]{jdiClosureDelegate, jdiMethodName, jdiMethodArgs});
            return this.delegate.createProxyFor(returnValue);
        }
        catch (DebugException e) {
            try {
                if (jdiClosureDelegate != jdiMethodTarget) {
                    IJavaValue returnValue = this.sendMessage(this.jdiMetaClass, "invokeMethod", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", new IJavaValue[]{jdiMethodTarget, jdiMethodName, jdiMethodArgs});
                    return this.delegate.createProxyFor(returnValue);
                }
            }
            catch (DebugException debugException) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
    }

    public Object invokeMethod(Object object, String methodName, Object[] arguments) {
        try {
            IJavaValue returnValue = this.sendMessage(this.jdiMetaClass, "invokeMethod", "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", new IJavaValue[]{JDIMetaClass.getClosureDelegate((IJavaValue)this.delegate.toJDIObject(object)), this.delegate.getTarget().newValue(methodName), this.delegate.toJDIObject(arguments)});
            if (!returnValue.isNull()) {
                if (returnValue.getJavaType().getName().equals("java.lang.Boolean")) {
                    return this.delegate.convertToBoolean(returnValue);
                }
                if (returnValue.getJavaType().getName().equals("java.lang.Integer")) {
                    return this.delegate.convertToInteger(returnValue);
                }
                if ("iterator".equals(methodName)) {
                    return this.delegate.convertToIterator(returnValue);
                }
            }
            return this.delegate.createProxyFor(returnValue);
        }
        catch (DebugException e) {
            throw new RuntimeException(e);
        }
    }

    public Object invokeMissingMethod(Object instance, String methodName, Object[] arguments) {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public Object invokeMissingProperty(Object instance, String propertyName, Object optionalValue, boolean isGetter) {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public Object invokeStaticMethod(Object object, String methodName, Object[] arguments) {
        try {
            IJavaValue returnValue = this.sendMessage(this.jdiMetaClass, "invokeStaticMethod", "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", new IJavaValue[]{JDIMetaClass.getClosureDelegate((IJavaValue)this.delegate.toJDIObject(object)), this.delegate.getTarget().newValue(methodName), this.delegate.toJDIObject(arguments)});
            return this.delegate.createProxyFor(returnValue);
        }
        catch (DebugException e) {
            throw new RuntimeException(e);
        }
    }

    public MetaMethod pickMethod(String methodName, Class[] arguments) {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public List<MetaMethod> respondsTo(Object obj, String name) {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public List<MetaMethod> respondsTo(Object obj, String name, Object[] argTypes) {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public int selectConstructorAndTransformArguments(int numberOfConstructors, Object[] arguments) {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public void setAttribute(Class sender, Object receiver, String messageName, Object messageValue, boolean useSuper, boolean fromInsideClass) {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public void setAttribute(Object object, String attribute, Object newValue) {
        try {
            this.sendMessage(this.jdiMetaClass, "setAttribute", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)V", new IJavaValue[]{this.delegate.toJDIObject(object), this.delegate.getTarget().newValue(attribute), this.delegate.toJDIObject(newValue)});
        }
        catch (DebugException e) {
            throw new RuntimeException(e);
        }
    }

    public void setProperty(Class sender, Object receiver, String property, Object value, boolean isCallToSuper, boolean fromInsideClass) {
        throw new IllegalArgumentException("Not implemented (Groovy-Eclipse)");
    }

    public void setProperty(Object object, String property, Object newValue) {
        try {
            this.sendMessage(this.jdiMetaClass, "setProperty", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)V", new IJavaValue[]{this.delegate.toJDIObject(object), this.delegate.getTarget().newValue(property), this.delegate.toJDIObject(newValue)});
        }
        catch (DebugException e) {
            throw new RuntimeException(e);
        }
    }

    private static IJavaValue getClosureDelegate(IJavaValue jdiValue) throws DebugException {
        IJavaFieldVariable delegateField;
        if (jdiValue instanceof IJavaObject && (delegateField = ((IJavaObject)jdiValue).getField("delegate", false)) != null) {
            jdiValue = (IJavaValue)delegateField.getValue();
        }
        return jdiValue;
    }

    private IJavaValue sendMessage(IJavaObject receiver, String methodName, String signature, IJavaValue ... arguments) throws DebugException {
        return receiver.sendMessage(methodName, signature, arguments, this.delegate.getThread(), false);
    }
}

