/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.highlighting;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.eclipse.editor.highlighting.GatherSemanticReferences;
import org.codehaus.groovy.eclipse.editor.highlighting.HighlightedTypedPosition;
import org.codehaus.groovy.eclipse.preferences.PreferenceConstants;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightingPresenter;
import org.eclipse.jdt.internal.ui.text.JavaPresentationReconciler;
import org.eclipse.jdt.internal.ui.text.java.IJavaReconcilingListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public class GroovySemanticReconciler
implements IJavaReconcilingListener {
    private static final String GROOVY_HIGHLIGHT_PREFERENCE = "groovy.editor.highlight.gjdk.color".replaceFirst("\\.color$", "");
    private static final String STRING_HIGHLIGHT_PREFERENCE = "java_string".replaceFirst("\\.color$", "");
    private static final String NUMBER_HIGHLIGHT_PREFERENCE = "semanticHighlighting.number";
    private static final String COMMENT_HIGHLIGHT_PREFERENCE = "java_single_line_comment";
    private static final String DEFAULT_HIGHLIGHT_PREFERENCE = "java_default";
    private static final String KEYWORD_HIGHLIGHT_PREFERENCE = "groovy.editor.highlight.javakeywords.color".replaceFirst("\\.color$", "");
    private static final String RESERVED_HIGHLIGHT_PREFERENCE = "groovy.editor.highlight.javatypes.color".replaceFirst("\\.color$", "");
    private static final String DEPRECATED_HIGHLIGHT_PREFERENCE = "semanticHighlighting.deprecatedMember";
    private static final String VARIABLE_HIGHLIGHT_PREFERENCE = "semanticHighlighting.localVariable";
    private static final String PARAMETER_HIGHLIGHT_PREFERENCE = "semanticHighlighting.parameterVariable";
    private static final String ATTRIBUTE_HIGHLIGHT_PREFERENCE = "semanticHighlighting.annotationElementReference";
    private static final String OBJECT_FIELD_HIGHLIGHT_PREFERENCE = "semanticHighlighting.field";
    private static final String STATIC_FIELD_HIGHLIGHT_PREFERENCE = "semanticHighlighting.staticField";
    private static final String STATIC_VALUE_HIGHLIGHT_PREFERENCE = "semanticHighlighting.staticFinalField";
    private static final String OBJECT_METHOD_HIGHLIGHT_PREFERENCE = "semanticHighlighting.method";
    private static final String STATIC_METHOD_HIGHLIGHT_PREFERENCE = "semanticHighlighting.staticMethodInvocation";
    private static final String METHOD_DECLARATION_HIGHLIGHT_PREFERENCE = "semanticHighlighting.methodDeclarationName";
    private static final String CLASS_HIGHLIGHT_PREFERENCE = "semanticHighlighting.class";
    private static final String ABSTRACT_CLASS_HIGHLIGHT_PREFERENCE = "semanticHighlighting.abstractClass";
    private static final String INTERFACE_HIGHLIGHT_PREFERENCE = "semanticHighlighting.interface";
    private static final String ANNOTATION_HIGHLIGHT_PREFERENCE = "semanticHighlighting.annotation.color".replaceFirst("\\.color$", "");
    private static final String ENUMERATION_HIGHLIGHT_PREFERENCE = "semanticHighlighting.enum";
    private static final String PLACEHOLDER_HIGHLIGHT_PREFERENCE = "semanticHighlighting.typeParameter";
    private static final String TRAIT_HIGHLIGHT_PREFERENCE = GROOVY_HIGHLIGHT_PREFERENCE;
    private static Method GET_HIGHLIGHTING = null;
    private static Constructor<?> HIGHLIGHTING_STYLE;
    private static Constructor<?> HIGHLIGHTED_POSITION;
    private volatile GroovyEditor editor;
    private SemanticHighlightingPresenter presenter;
    private final Semaphore lock = new Semaphore(1, true);
    private Object mapKeyHighlighting;
    private Object tagKeyHighlighting;
    private Object stringRefHighlighting;
    private Object numberRefHighlighting;
    private Object regexpRefHighlighting;
    private Object commentRefHighlighting;
    private Object defaultRefHighlighting;
    private Object keywordRefHighlighting;
    private Object reservedRefHighlighting;
    private Object undefinedRefHighlighting;
    private Object deprecatedRefHighlighting;
    private Object localHighlighting;
    private Object paramHighlighting;
    private Object objectFieldHighlighting;
    private Object staticFieldHighlighting;
    private Object staticValueHighlighting;
    private Object methodUseHighlighting;
    private Object groovyMethodUseHighlighting;
    private Object staticMethodUseHighlighting;
    private Object methodDeclarationHighlighting;
    private Object classHighlighting;
    private Object traitHighlighting;
    private Object interfaceHighlighting;
    private Object annotationHighlighting;
    private Object enumerationHighlighting;
    private Object placeholderHighlighting;
    private Object abstractClassHighlighting;

    static {
        try {
            Class<?> style = Class.forName("org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightingManager$Highlighting");
            try {
                HIGHLIGHTING_STYLE = style.getDeclaredConstructor(String.class, TextAttribute.class, Boolean.TYPE);
            }
            catch (NoSuchMethodException nsme) {
                HIGHLIGHTING_STYLE = style.getDeclaredConstructor(TextAttribute.class, Boolean.TYPE);
            }
            HIGHLIGHTING_STYLE.setAccessible(true);
            Class<?> position = Class.forName("org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightingManager$HighlightedPosition");
            HIGHLIGHTED_POSITION = position.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, style, Object.class);
            HIGHLIGHTED_POSITION.setAccessible(true);
            GET_HIGHLIGHTING = position.getDeclaredMethod("getHighlighting", new Class[0]);
            GET_HIGHLIGHTING.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            HIGHLIGHTING_STYLE = null;
            HIGHLIGHTED_POSITION = null;
            GroovyPlugin.getDefault().logError("Semantic highlighting disabled", e);
        }
    }

    public GroovySemanticReconciler() {
        IPreferenceStore prefs = PreferenceConstants.getPreferenceStore();
        Color groovyColor = GroovySemanticReconciler.loadColorFrom(prefs, GROOVY_HIGHLIGHT_PREFERENCE);
        Color numberColor = GroovySemanticReconciler.loadColorFrom(prefs, NUMBER_HIGHLIGHT_PREFERENCE);
        Color stringColor = GroovySemanticReconciler.loadColorFrom(prefs, STRING_HIGHLIGHT_PREFERENCE);
        Color tagKeyColor = GroovySemanticReconciler.loadColorFrom(prefs, ATTRIBUTE_HIGHLIGHT_PREFERENCE);
        Color commentColor = GroovySemanticReconciler.loadColorFrom(prefs, COMMENT_HIGHLIGHT_PREFERENCE);
        Color defaultColor = GroovySemanticReconciler.loadColorFrom(prefs, DEFAULT_HIGHLIGHT_PREFERENCE);
        Color keywordColor = GroovySemanticReconciler.loadColorFrom(prefs, KEYWORD_HIGHLIGHT_PREFERENCE);
        Color reservedColor = GroovySemanticReconciler.loadColorFrom(prefs, RESERVED_HIGHLIGHT_PREFERENCE);
        Color variableColor = GroovySemanticReconciler.loadColorFrom(prefs, VARIABLE_HIGHLIGHT_PREFERENCE);
        Color parameterColor = GroovySemanticReconciler.loadColorFrom(prefs, PARAMETER_HIGHLIGHT_PREFERENCE);
        Color objectFieldColor = GroovySemanticReconciler.loadColorFrom(prefs, OBJECT_FIELD_HIGHLIGHT_PREFERENCE);
        Color staticFieldColor = GroovySemanticReconciler.loadColorFrom(prefs, STATIC_FIELD_HIGHLIGHT_PREFERENCE);
        Color staticValueColor = GroovySemanticReconciler.loadColorFrom(prefs, STATIC_VALUE_HIGHLIGHT_PREFERENCE);
        Color staticCallColor = GroovySemanticReconciler.loadColorFrom(prefs, STATIC_METHOD_HIGHLIGHT_PREFERENCE);
        Color methodCallColor = GroovySemanticReconciler.loadColorFrom(prefs, OBJECT_METHOD_HIGHLIGHT_PREFERENCE);
        Color methodDeclColor = GroovySemanticReconciler.loadColorFrom(prefs, METHOD_DECLARATION_HIGHLIGHT_PREFERENCE);
        Color classColor = GroovySemanticReconciler.loadColorFrom(prefs, CLASS_HIGHLIGHT_PREFERENCE);
        Color traitColor = GroovySemanticReconciler.loadColorFrom(prefs, TRAIT_HIGHLIGHT_PREFERENCE);
        Color interfaceColor = GroovySemanticReconciler.loadColorFrom(prefs, INTERFACE_HIGHLIGHT_PREFERENCE);
        Color annotationColor = GroovySemanticReconciler.loadColorFrom(prefs, ANNOTATION_HIGHLIGHT_PREFERENCE);
        Color enumerationColor = GroovySemanticReconciler.loadColorFrom(prefs, ENUMERATION_HIGHLIGHT_PREFERENCE);
        Color placeholderColor = GroovySemanticReconciler.loadColorFrom(prefs, PLACEHOLDER_HIGHLIGHT_PREFERENCE);
        Color abstractClassColor = GroovySemanticReconciler.loadColorFrom(prefs, ABSTRACT_CLASS_HIGHLIGHT_PREFERENCE);
        this.mapKeyHighlighting = this.newHighlightingStyle(stringColor);
        this.tagKeyHighlighting = this.newHighlightingStyle(tagKeyColor, GroovySemanticReconciler.loadStyleFrom(prefs, ATTRIBUTE_HIGHLIGHT_PREFERENCE));
        this.stringRefHighlighting = this.newHighlightingStyle(stringColor, GroovySemanticReconciler.loadStyleFrom(prefs, STRING_HIGHLIGHT_PREFERENCE));
        this.numberRefHighlighting = this.newHighlightingStyle(numberColor, GroovySemanticReconciler.loadStyleFrom(prefs, NUMBER_HIGHLIGHT_PREFERENCE));
        this.regexpRefHighlighting = this.newHighlightingStyle(stringColor, GroovySemanticReconciler.loadStyleFrom(prefs, STRING_HIGHLIGHT_PREFERENCE) | 2);
        this.commentRefHighlighting = this.newHighlightingStyle(commentColor);
        this.defaultRefHighlighting = this.newHighlightingStyle(defaultColor);
        this.keywordRefHighlighting = this.newHighlightingStyle(keywordColor, GroovySemanticReconciler.loadStyleFrom(prefs, KEYWORD_HIGHLIGHT_PREFERENCE));
        this.reservedRefHighlighting = this.newHighlightingStyle(reservedColor, GroovySemanticReconciler.loadStyleFrom(prefs, RESERVED_HIGHLIGHT_PREFERENCE));
        this.deprecatedRefHighlighting = this.newHighlightingStyle(GroovySemanticReconciler.loadStyleFrom(prefs, DEPRECATED_HIGHLIGHT_PREFERENCE));
        this.undefinedRefHighlighting = this.newHighlightingStyle(0x40000000);
        this.localHighlighting = this.newHighlightingStyle(variableColor, GroovySemanticReconciler.loadStyleFrom(prefs, VARIABLE_HIGHLIGHT_PREFERENCE));
        this.paramHighlighting = parameterColor == null ? this.localHighlighting : this.newHighlightingStyle(parameterColor, GroovySemanticReconciler.loadStyleFrom(prefs, PARAMETER_HIGHLIGHT_PREFERENCE));
        this.objectFieldHighlighting = this.newHighlightingStyle(objectFieldColor, GroovySemanticReconciler.loadStyleFrom(prefs, OBJECT_FIELD_HIGHLIGHT_PREFERENCE));
        this.staticFieldHighlighting = staticFieldColor == null ? this.objectFieldHighlighting : this.newHighlightingStyle(staticFieldColor, GroovySemanticReconciler.loadStyleFrom(prefs, STATIC_FIELD_HIGHLIGHT_PREFERENCE));
        this.staticValueHighlighting = staticValueColor == null ? this.staticFieldHighlighting : this.newHighlightingStyle(staticValueColor, GroovySemanticReconciler.loadStyleFrom(prefs, STATIC_VALUE_HIGHLIGHT_PREFERENCE));
        this.methodUseHighlighting = this.newHighlightingStyle(methodCallColor, GroovySemanticReconciler.loadStyleFrom(prefs, OBJECT_METHOD_HIGHLIGHT_PREFERENCE));
        this.groovyMethodUseHighlighting = groovyColor == null ? this.methodUseHighlighting : this.newHighlightingStyle(groovyColor, GroovySemanticReconciler.loadStyleFrom(prefs, GROOVY_HIGHLIGHT_PREFERENCE));
        this.staticMethodUseHighlighting = staticCallColor == null ? this.methodUseHighlighting : this.newHighlightingStyle(staticCallColor, GroovySemanticReconciler.loadStyleFrom(prefs, STATIC_METHOD_HIGHLIGHT_PREFERENCE));
        this.methodDeclarationHighlighting = methodDeclColor == null ? this.methodUseHighlighting : this.newHighlightingStyle(methodDeclColor, GroovySemanticReconciler.loadStyleFrom(prefs, METHOD_DECLARATION_HIGHLIGHT_PREFERENCE));
        this.classHighlighting = this.newHighlightingStyle(classColor, GroovySemanticReconciler.loadStyleFrom(prefs, CLASS_HIGHLIGHT_PREFERENCE));
        this.traitHighlighting = this.newHighlightingStyle(traitColor, GroovySemanticReconciler.loadStyleFrom(prefs, TRAIT_HIGHLIGHT_PREFERENCE));
        this.interfaceHighlighting = this.newHighlightingStyle(interfaceColor, GroovySemanticReconciler.loadStyleFrom(prefs, INTERFACE_HIGHLIGHT_PREFERENCE));
        this.annotationHighlighting = this.newHighlightingStyle(annotationColor, GroovySemanticReconciler.loadStyleFrom(prefs, ANNOTATION_HIGHLIGHT_PREFERENCE));
        this.enumerationHighlighting = this.newHighlightingStyle(enumerationColor, GroovySemanticReconciler.loadStyleFrom(prefs, ENUMERATION_HIGHLIGHT_PREFERENCE));
        this.placeholderHighlighting = this.newHighlightingStyle(placeholderColor, GroovySemanticReconciler.loadStyleFrom(prefs, PLACEHOLDER_HIGHLIGHT_PREFERENCE));
        this.abstractClassHighlighting = abstractClassColor == null ? this.classHighlighting : this.newHighlightingStyle(abstractClassColor, GroovySemanticReconciler.loadStyleFrom(prefs, ABSTRACT_CLASS_HIGHLIGHT_PREFERENCE));
    }

    protected static Color loadColorFrom(IPreferenceStore prefs, String which) {
        if (prefs.contains(which + ".enabled") && !prefs.getBoolean(which + ".enabled")) {
            return null;
        }
        RGB color = PreferenceConverter.getColor((IPreferenceStore)prefs, (String)(which.startsWith("java_") ? which : which + ".color"));
        return GroovyPlugin.getDefault().getTextTools().getColorManager().getColor(color);
    }

    protected static int loadStyleFrom(IPreferenceStore prefs, String which) {
        int style = 0;
        if (!prefs.contains(which + ".enabled") || prefs.getBoolean(which + ".enabled")) {
            if (prefs.getBoolean(which + ".bold") || prefs.getBoolean(which + ".color_bold")) {
                style |= 1;
            }
            if (prefs.getBoolean(which + ".italic")) {
                style |= 2;
            }
            if (prefs.getBoolean(which + ".underline")) {
                style |= 0x40000000;
            }
            if (prefs.getBoolean(which + ".strikethrough")) {
                style |= 0x20000000;
            }
        }
        return style;
    }

    protected Object newHighlightingStyle(Color color) {
        Object[] arguments = new Object[HIGHLIGHTING_STYLE.getParameterCount()];
        arguments[arguments.length - 2] = new TextAttribute(color);
        arguments[arguments.length - 1] = Boolean.TRUE;
        return ReflectionUtils.invokeConstructor(HIGHLIGHTING_STYLE, (Object[])arguments);
    }

    protected Object newHighlightingStyle(int style) {
        Object[] arguments = new Object[HIGHLIGHTING_STYLE.getParameterCount()];
        arguments[arguments.length - 2] = new TextAttribute(null, null, style);
        arguments[arguments.length - 1] = Boolean.TRUE;
        return ReflectionUtils.invokeConstructor(HIGHLIGHTING_STYLE, (Object[])arguments);
    }

    protected Object newHighlightingStyle(Color color, int style) {
        Object[] arguments = new Object[HIGHLIGHTING_STYLE.getParameterCount()];
        arguments[arguments.length - 2] = new TextAttribute(color, null, style);
        arguments[arguments.length - 1] = color != null;
        return ReflectionUtils.invokeConstructor(HIGHLIGHTING_STYLE, (Object[])arguments);
    }

    protected void setHighlightingStyle(Position pos, Object val) {
        try {
            ReflectionUtils.throwableSetPrivateField(pos.getClass(), (String)"fStyle", (Object)pos, (Object)val);
        }
        catch (Exception e) {
            ReflectionUtils.setPrivateField(pos.getClass().getSuperclass(), (String)"fHighlighting", (Object)pos, (Object)val);
        }
    }

    public void install(GroovyEditor editor, JavaSourceViewer viewer) {
        this.editor = editor;
        this.presenter = new SemanticHighlightingPresenter();
        this.presenter.install(viewer, (JavaPresentationReconciler)editor.getGroovyConfiguration().getPresentationReconciler((ISourceViewer)viewer));
    }

    public void uninstall() {
        this.presenter.uninstall();
        this.presenter = null;
        this.editor = null;
    }

    public void aboutToBeReconciled() {
    }

    public void reconciled(CompilationUnit ast, boolean forced, IProgressMonitor monitor) {
        block25: {
            if (ast != null && this.synchronize()) {
                try {
                    if (this.editor == null || this.presenter == null) {
                        return;
                    }
                    monitor.beginTask("Groovy semantic highlighting", 10);
                    GroovyCompilationUnit unit = this.editor.getGroovyCompilationUnit();
                    if (unit == null) break block25;
                    this.presenter.setCanceled(monitor.isCanceled());
                    if (this.update(monitor, 1)) {
                        return;
                    }
                    GatherSemanticReferences finder = new GatherSemanticReferences(unit);
                    Collection<HighlightedTypedPosition> semanticReferences = finder.findSemanticHighlightingReferences();
                    if (this.update(monitor, 5)) {
                        return;
                    }
                    ArrayList<Position> newPositions = new ArrayList<Position>(semanticReferences.size());
                    LinkedList<Position> oldPositions = new LinkedList<Position>(this.getHighlightedPositions());
                    if (this.update(monitor, 1)) {
                        return;
                    }
                    HighlightedTypedPosition last = null;
                    Position x = null;
                    for (HighlightedTypedPosition ref : semanticReferences) {
                        Position pos;
                        if (last == null || last.getOffset() != ref.getOffset() || last.getLength() != ref.getLength()) {
                            pos = this.newHighlightedPosition(ref);
                            x = this.tryAddPosition(newPositions, oldPositions, pos);
                        } else if (GET_HIGHLIGHTING != null && (ref.kind == HighlightedTypedPosition.HighlightKind.DEPRECATED || ref.kind == HighlightedTypedPosition.HighlightKind.UNKNOWN)) {
                            Position position = pos = !newPositions.isEmpty() ? (Position)newPositions.get(newPositions.size() - 1) : null;
                            if (ref.compareTo(pos) != 0) {
                                if (ref.compareTo(x) == 0) {
                                    pos = this.newHighlightedPosition(last);
                                    newPositions.add(pos);
                                    oldPositions.add(x);
                                } else {
                                    GroovyPlugin.getDefault().logWarning(String.format("Failed to apply %s semantic at %s", ref.kind.name().toLowerCase(), ref.toString()));
                                    continue;
                                }
                            }
                            Object style = GET_HIGHLIGHTING.invoke((Object)pos, new Object[0]);
                            TextAttribute one = this.getTextAttribute(style);
                            TextAttribute two = this.getTextAttribute(ref.kind == HighlightedTypedPosition.HighlightKind.DEPRECATED ? this.deprecatedRefHighlighting : this.undefinedRefHighlighting);
                            this.setHighlightingStyle(pos, this.newHighlightingStyle(one.getForeground(), one.getStyle() | two.getStyle()));
                        }
                        last = ref;
                    }
                    if (this.update(monitor, 2)) {
                        return;
                    }
                    try {
                        TextPresentation textPresentation = null;
                        if (!this.presenter.isCanceled()) {
                            textPresentation = this.presenter.createPresentation(newPositions, oldPositions);
                        }
                        if (!this.presenter.isCanceled()) {
                            this.updatePresentation(textPresentation, newPositions, oldPositions);
                        }
                        this.update(monitor, 1);
                    }
                    catch (AssertionError | Exception | LinkageError e) {
                        GroovyCore.logException((String)"Semantic highlighting failed", (Throwable)e);
                    }
                }
                finally {
                    this.lock.release();
                }
            }
        }
    }

    private boolean synchronize() {
        try {
            boolean acquired = this.lock.tryAcquire(2L, TimeUnit.SECONDS);
            if (!acquired) {
                GroovyPlugin.getDefault().logWarning("Failed to acquire semantic highlight semaphore");
            }
            return acquired;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean update(IProgressMonitor monitor, int units) {
        monitor.worked(units);
        return monitor.isCanceled();
    }

    private List<Position> getHighlightedPositions() {
        try {
            return (List)ReflectionUtils.throwableGetPrivateField(SemanticHighlightingPresenter.class, (String)"fPositions", (Object)this.presenter);
        }
        catch (Exception e) {
            return (List)ReflectionUtils.getPrivateField(SemanticHighlightingPresenter.class.getSuperclass(), (String)"fPositions", (Object)this.presenter);
        }
    }

    private Position newHighlightedPosition(HighlightedTypedPosition pos) {
        Object style = null;
        switch (pos.kind) {
            case DEPRECATED: {
                style = this.deprecatedRefHighlighting;
                break;
            }
            case UNKNOWN: {
                style = this.undefinedRefHighlighting;
                break;
            }
            case COMMENT: {
                style = this.commentRefHighlighting;
                break;
            }
            case DEFAULT: {
                style = this.defaultRefHighlighting;
                break;
            }
            case KEYWORD: {
                style = this.keywordRefHighlighting;
                break;
            }
            case RESERVED: {
                style = this.reservedRefHighlighting;
                break;
            }
            case NUMBER: {
                style = this.numberRefHighlighting;
                break;
            }
            case STRING: {
                style = this.stringRefHighlighting;
                break;
            }
            case REGEXP: {
                style = this.regexpRefHighlighting;
                break;
            }
            case MAP_KEY: {
                style = this.mapKeyHighlighting;
                break;
            }
            case TAG_KEY: {
                style = this.tagKeyHighlighting;
                break;
            }
            case VARIABLE: {
                style = this.localHighlighting;
                break;
            }
            case PARAMETER: {
                style = this.paramHighlighting;
                break;
            }
            case FIELD: {
                style = this.objectFieldHighlighting;
                break;
            }
            case STATIC_FIELD: {
                style = this.staticFieldHighlighting;
                break;
            }
            case STATIC_VALUE: {
                style = this.staticValueHighlighting;
                break;
            }
            case CTOR: 
            case METHOD: 
            case STATIC_METHOD: {
                style = this.methodDeclarationHighlighting;
                break;
            }
            case CTOR_CALL: 
            case METHOD_CALL: {
                style = this.methodUseHighlighting;
                break;
            }
            case GROOVY_CALL: {
                style = this.groovyMethodUseHighlighting;
                break;
            }
            case STATIC_CALL: {
                style = this.staticMethodUseHighlighting;
                break;
            }
            case CLASS: {
                style = this.classHighlighting;
                break;
            }
            case TRAIT: {
                style = this.traitHighlighting;
                break;
            }
            case INTERFACE: {
                style = this.interfaceHighlighting;
                break;
            }
            case ANNOTATION: {
                style = this.annotationHighlighting;
                break;
            }
            case ENUMERATION: {
                style = this.enumerationHighlighting;
                break;
            }
            case PLACEHOLDER: {
                style = this.placeholderHighlighting;
                break;
            }
            case ABSTRACT_CLASS: {
                style = this.abstractClassHighlighting;
            }
        }
        return (Position)ReflectionUtils.invokeConstructor(HIGHLIGHTED_POSITION, (Object[])new Object[]{pos.offset, pos.length, style, this});
    }

    private Position tryAddPosition(List<Position> newPositions, List<Position> oldPositions, Position maybePosition) {
        Iterator<Position> it = oldPositions.iterator();
        while (it.hasNext()) {
            Position oldPosition = it.next();
            if (oldPosition.isDeleted() || !oldPosition.equals((Object)maybePosition) || !this.isSameStyle(oldPosition, maybePosition)) continue;
            it.remove();
            return oldPosition;
        }
        newPositions.add(maybePosition);
        return null;
    }

    private boolean isSameStyle(Position a, Position b) {
        if (GET_HIGHLIGHTING != null) {
            try {
                return GET_HIGHLIGHTING.invoke((Object)a, new Object[0]) == GET_HIGHLIGHTING.invoke((Object)b, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return true;
    }

    private TextAttribute getTextAttribute(Object highlightingStyle) {
        return (TextAttribute)ReflectionUtils.executePrivateMethod(highlightingStyle.getClass(), (String)"getTextAttribute", (Object)highlightingStyle);
    }

    private void updatePresentation(TextPresentation textPresentation, List<Position> addedPositions, List<Position> removedPositions) {
        Runnable runnable = this.presenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        GroovyEditor thisEditor = this.editor;
        if (thisEditor == null) {
            return;
        }
        IWorkbenchPartSite site = thisEditor.getSite();
        if (site == null) {
            return;
        }
        Shell shell = site.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(runnable);
    }
}

