/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.composer.core.webview.browserfunction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.katalon.composer.core.webview.browserfunction.BaseRpcHandlerRegistry;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiRpcHandlerRegistry<T, U>
extends BaseRpcHandlerRegistry {
    private static final Logger logger = LoggerFactory.getLogger(BiRpcHandlerRegistry.class);
    private final Class<T> clazzT;
    private final Class<U> clazzU;
    private final BiConsumer<T, U> handler;

    public BiRpcHandlerRegistry(String name, Class<T> clazzT, Class<U> clazzU, BiConsumer<T, U> handler) {
        super(name);
        this.clazzT = clazzT;
        this.clazzU = clazzU;
        this.handler = handler;
    }

    @Override
    public void invoke(ArrayNode args) {
        if (args.size() < 2) {
            logger.error("Not enough arguments from browser function | name = {} | expected = 2 | actual = {}", (Object)this.name, (Object)args.size());
            return;
        }
        try {
            T argT = this.parseArgument(args.get(0), null, this.clazzT);
            U argU = this.parseArgument(args.get(1), null, this.clazzU);
            UISynchronizeService.asyncExec(() -> this.handler.accept(argT, argU));
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to parse data from browser function | name = %s | argT = %s | argU = %s".formatted(this.name, args.get(0).toString(), args.get(1).toString()), (Throwable)e);
        }
    }
}

