/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.menu;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.menu.MenuFactory;
import com.kms.katalon.composer.objectrepository.constant.ComposerObjectRepositoryMessageConstants;
import com.kms.katalon.composer.objectrepository.handler.NewTestObjectHandler;
import com.kms.katalon.constants.helper.ConstantsHelper;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;

public class AddToObjectSpyMenuContribution {
    private static final String ADD_TO_OBJECTSPY_POPUP_MENUITEM_LABEL = ComposerObjectRepositoryMessageConstants.MENU_CONTEXT_ADD_TO_OBJECTSPY;
    private static final String ADD_TO_OBJECTSPY_COMMAND_ID = "com.kms.katalon.composer.objectrepository.command.addToObjectSpy";
    @Inject
    private ECommandService commandService;
    @Inject
    private ESelectionService selectionService;

    @Inject
    public void init() {
        this.selectionService.addSelectionListener(new ISelectionListener(){

            public void selectionChanged(MPart part, Object selection) {
                if (part.getElementId().equals("com.kms.katalon.composer.part.explorer")) {
                    AddToObjectSpyMenuContribution.this.selectionService.setSelection(selection);
                } else {
                    AddToObjectSpyMenuContribution.this.selectionService.setSelection(null);
                }
            }
        });
    }

    @AboutToShow
    public void aboutToShow(List<MMenuElement> menuItems) {
        try {
            MHandledMenuItem newTestObjectPopupMenuItem;
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            if (selectedObjects == null || selectedObjects.length == 0) {
                return;
            }
            if (NewTestObjectHandler.getParentTreeEntity(selectedObjects) != null && (newTestObjectPopupMenuItem = MenuFactory.createPopupMenuItem((ParameterizedCommand)this.commandService.createCommand(ADD_TO_OBJECTSPY_COMMAND_ID, null), (String)ADD_TO_OBJECTSPY_POPUP_MENUITEM_LABEL, (String)ConstantsHelper.getApplicationURI())) != null) {
                menuItems.add((MMenuElement)MMenuFactory.INSTANCE.createMenuSeparator());
                menuItems.add((MMenuElement)newTestObjectPopupMenuItem);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

