/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.support;

import com.kms.katalon.composer.objectrepository.part.TestObjectPart;
import com.kms.katalon.composer.objectrepository.provider.ObjectXpathsTableViewer;
import com.kms.katalon.entity.repository.WebElementXpathEntity;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;

public class XpathSelectedEditingSupport
extends EditingSupport {
    private ObjectXpathsTableViewer viewer;
    private IEventBroker eventBroker;
    private TestObjectPart testObjectPart;

    public XpathSelectedEditingSupport(ObjectXpathsTableViewer viewer, IEventBroker eventBroker, TestObjectPart testObjectPart) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.eventBroker = eventBroker;
        this.testObjectPart = testObjectPart;
    }

    protected CellEditor getCellEditor(Object element) {
        return new CheckboxCellEditor((Composite)this.viewer.getTable());
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (element instanceof WebElementXpathEntity) {
            WebElementXpathEntity xpath = (WebElementXpathEntity)element;
            return xpath.getIsSelected();
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof WebElementXpathEntity && value instanceof Boolean) {
            this.testObjectPart.executeOperation((IUndoableOperation)new XpathSelectionChangeOperation((WebElementXpathEntity)element, (Boolean)value));
        }
    }

    private class XpathSelectionChangeOperation
    extends AbstractOperation {
        private WebElementXpathEntity xpath;
        private boolean value;

        public XpathSelectionChangeOperation(WebElementXpathEntity xpath, boolean value) {
            super(XpathSelectionChangeOperation.class.getName());
            this.xpath = xpath;
            this.value = value;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.value == this.xpath.getIsSelected()) {
                return Status.CANCEL_STATUS;
            }
            return this.doSetItemValue(this.value);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetItemValue(this.value);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetItemValue(!this.value);
        }

        protected IStatus doSetItemValue(boolean itemValue) {
            XpathSelectedEditingSupport.this.viewer.getInput().forEach(e -> e.setIsSelected(false));
            this.xpath.setIsSelected(itemValue);
            XpathSelectedEditingSupport.this.viewer.refresh();
            XpathSelectedEditingSupport.this.eventBroker.post("OBJECT/UPDATE_DIRTY", (Object)XpathSelectedEditingSupport.this.viewer);
            return Status.OK_STATUS;
        }
    }
}

