/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.dialog;

import com.kms.katalon.composer.components.impl.control.ScrollableComposite;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.windows.dialog.WindowsObjectDialog;
import com.kms.katalon.composer.windows.element.BasicWindowsElement;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

public class WindowsScreenView {
    private Image currentScreenShot;
    private Canvas canvas;
    private List<Rectangle> highlightRects = new ArrayList<Rectangle>();
    private boolean highlightPhase = false;
    private Image highlightedImage;
    private double hRatio;
    private boolean isDisposed;
    private WindowsObjectDialog parentDialog;
    private ScrolledComposite scrolledComposite;

    public WindowsScreenView(WindowsObjectDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    public Composite createControls(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new GridLayout());
        Label lblScreenComposite = new Label(mainComposite, 0);
        lblScreenComposite.setText("SCREEN VIEW");
        ControlUtils.setFontToBeBold((Control)lblScreenComposite);
        this.scrolledComposite = new ScrollableComposite(mainComposite, 2816);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setLayout((Layout)new GridLayout());
        Composite container = new Composite((Composite)this.scrolledComposite, 0);
        container.setLayout((Layout)new FillLayout());
        this.scrolledComposite.setContent((Control)container);
        this.canvas = new Canvas(container, 0x20000000);
        this.canvas.pack();
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (WindowsScreenView.this.currentScreenShot == null) {
                    return;
                }
                if (WindowsScreenView.this.currentScreenShot.isDisposed()) {
                    return;
                }
                if (WindowsScreenView.this.highlightPhase && WindowsScreenView.this.highlightedImage != null && !WindowsScreenView.this.highlightedImage.isDisposed()) {
                    e.gc.drawImage(WindowsScreenView.this.highlightedImage, 0, 0);
                    return;
                }
                e.gc.drawImage(WindowsScreenView.this.currentScreenShot, 0, 0);
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    WindowsScreenView.this.inspectElementAt(e.x, e.y);
                }
            }
        });
        return mainComposite;
    }

    private void inspectElementAt(int x, int y) {
        Double realX = (double)x / this.hRatio;
        Double realY = (double)y / this.hRatio;
        this.parentDialog.setSelectedElementByLocation(WindowsScreenView.safeRoundDouble(realX), WindowsScreenView.safeRoundDouble(realY));
    }

    public boolean isElementOnScreen(Double x, Double y, Double width, Double height) {
        Rectangle elementRect = new Rectangle(x.intValue(), y.intValue(), width.intValue(), height.intValue());
        return elementRect.intersects(this.getCurrentViewportRect());
    }

    private void scrollToElement(Double x, Double y) {
        this.scrolledComposite.setOrigin(x.intValue(), y.intValue());
    }

    private Rectangle getCurrentViewportRect() {
        ScrollBar verticalBar = this.scrolledComposite.getVerticalBar();
        ScrollBar horizontalBar = this.scrolledComposite.getHorizontalBar();
        int viewPortY = verticalBar.isVisible() ? verticalBar.getSelection() : 0;
        int viewPortX = horizontalBar.isVisible() ? horizontalBar.getSelection() : 0;
        Point viewPortSize = this.scrolledComposite.getSize();
        Rectangle viewPortRect = new Rectangle(viewPortX, viewPortY, viewPortSize.x, viewPortSize.y);
        return viewPortRect;
    }

    public void highlightRects(final List<Rectangle> rects) {
        if (rects == null || rects.size() == 0) {
            return;
        }
        this.highlightRects.addAll(rects);
        this.prepareHighlightImages(rects);
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                Rectangle firstRect;
                Rectangle rectangle = firstRect = rects.size() > 0 ? (Rectangle)rects.get(0) : null;
                if (firstRect == null) {
                    return;
                }
                double currentX = (double)firstRect.x * WindowsScreenView.this.hRatio;
                double currentY = (double)firstRect.y * WindowsScreenView.this.hRatio;
                double currentWidth = (double)firstRect.width * WindowsScreenView.this.hRatio;
                double currentHeight = (double)firstRect.height * WindowsScreenView.this.hRatio;
                if (!WindowsScreenView.this.isElementOnScreen(currentX, currentY, currentWidth, currentHeight)) {
                    WindowsScreenView.this.scrollToElement(currentX, currentY);
                }
            }
        });
        Thread highlightThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < 9) {
                    WindowsScreenView.this.highlightPhase = i % 2 == 1;
                    try {
                        Thread.sleep(400L);
                    }
                    catch (InterruptedException interruptedException) {}
                    UISynchronizeService.syncExec(() -> {
                        if (!WindowsScreenView.this.canvas.isDisposed()) {
                            WindowsScreenView.this.canvas.redraw();
                        }
                    });
                    ++i;
                }
                WindowsScreenView.this.highlightRects.removeAll(rects);
            }
        });
        highlightThread.start();
    }

    private void prepareHighlightImages(List<Rectangle> rects) {
        if (this.currentScreenShot == null || this.currentScreenShot.isDisposed()) {
            return;
        }
        if (this.highlightedImage != null && !this.highlightedImage.isDisposed()) {
            this.highlightedImage.dispose();
        }
        this.highlightedImage = new Image((Device)this.canvas.getDisplay(), this.currentScreenShot.getBounds());
        GC highlightGC = new GC((Drawable)this.highlightedImage);
        highlightGC.drawImage(this.currentScreenShot, 0, 0);
        Color oldForegroundColor = highlightGC.getForeground();
        highlightGC.setForeground(ColorUtil.getColor((String)"#76BF42"));
        int oldLineWidth = highlightGC.getLineWidth();
        highlightGC.setLineWidth(2);
        for (Rectangle rect : rects) {
            highlightGC.drawRectangle(rect.x, rect.y, rect.width, rect.height);
        }
        highlightGC.setLineWidth(oldLineWidth);
        highlightGC.setForeground(oldForegroundColor);
        highlightGC.dispose();
    }

    private Image scaleImage(Image image, double newWidth, double newHeight) {
        Image scaled = new Image((Device)Display.getDefault(), WindowsScreenView.safeRoundDouble(newWidth), WindowsScreenView.safeRoundDouble(newHeight));
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, WindowsScreenView.safeRoundDouble(newWidth), WindowsScreenView.safeRoundDouble(newHeight));
        gc.dispose();
        image.dispose();
        return scaled;
    }

    public void highlightElement(BasicWindowsElement selectedElement) {
        Map<String, String> attributes = selectedElement.getProperties();
        if (!(attributes != null && attributes.containsKey("x") && attributes.containsKey("y") && attributes.containsKey("width") && attributes.containsKey("height"))) {
            return;
        }
        double x = Double.parseDouble(attributes.get("x"));
        double y = Double.parseDouble(attributes.get("y"));
        double w = Double.parseDouble(attributes.get("width"));
        double h = Double.parseDouble(attributes.get("height"));
        Rectangle newHighlightRect = new Rectangle(WindowsScreenView.safeRoundDouble(x * this.hRatio), WindowsScreenView.safeRoundDouble(y * this.hRatio), WindowsScreenView.safeRoundDouble(w * this.hRatio), WindowsScreenView.safeRoundDouble(h * this.hRatio));
        this.highlightRects(new ArrayList<Rectangle>(List.of(newHighlightRect)));
    }

    public void refreshDialog(File imageFile) {
        try {
            if (imageFile == null) {
                this.currentScreenShot = null;
            } else {
                ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)imageFile.toURI().toURL());
                final Image img = imgDesc.createImage();
                this.hRatio = 1.0;
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WindowsScreenView.this.currentScreenShot = WindowsScreenView.this.scaleImage(img, (double)img.getBounds().width * WindowsScreenView.this.hRatio, (double)img.getBounds().height * WindowsScreenView.this.hRatio);
                    }
                });
                this.highlightedImage = null;
            }
            UISynchronizeService.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!WindowsScreenView.this.canvas.isDisposed()) {
                        WindowsScreenView.this.canvas.redraw();
                    }
                }
            });
            this.refreshView();
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    private void refreshView() {
        if (this.scrolledComposite == null || this.currentScreenShot == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (WindowsScreenView.this.currentScreenShot != null) {
                    WindowsScreenView.this.scrolledComposite.setMinSize(WindowsScreenView.this.currentScreenShot.getImageData().width + 10, WindowsScreenView.this.currentScreenShot.getImageData().height + 10);
                } else {
                    WindowsScreenView.this.scrolledComposite.setMinSize(WindowsScreenView.this.scrolledComposite.computeSize(-1, -1));
                }
            }
        });
    }

    public void dispose() {
        this.isDisposed = true;
        if (this.highlightedImage != null && !this.highlightedImage.isDisposed()) {
            this.highlightedImage.dispose();
            this.highlightedImage = null;
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public static int safeRoundDouble(double d) {
        long rounded = Math.round(d);
        return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, rounded));
    }
}

