/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.windows.keyword.helper;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.enums.windows.LocatorStrategy;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.testobject.WindowsTestObject;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.core.windows.driver.WindowsDesiredCapsBuilder;
import com.kms.katalon.core.windows.driver.WindowsDriverFactory;
import com.kms.katalon.core.windows.driver.WindowsSession;
import com.kms.katalon.core.windows.keyword.exception.DriverNotStartedException;
import com.kms.katalon.core.windows.keyword.exception.SessionNotStartedException;
import com.kms.katalon.core.windows.model.StringMatchingStrategy;
import io.appium.java_client.AppiumBy;
import io.appium.java_client.windows.WindowsDriver;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.support.ui.FluentWait;

public class WindowsActionHelper {
    private static KeywordLogger logger = KeywordLogger.getInstance(WindowsActionHelper.class);
    private static final String FLAUI_MSG_APP_CLOSED_OR_LOST_CONNECTION = "An event was unable to invoke any of the subscribers";
    public static final List<Keys> MODIFIER_KEYS = Collections.unmodifiableList(Arrays.asList(Keys.SHIFT, Keys.CONTROL, Keys.ALT, Keys.META));
    private WindowsSession windowsSession;

    public WindowsActionHelper(WindowsSession windowsSession) {
        this.windowsSession = windowsSession;
    }

    public static int checkTimeout(int timeout) throws IllegalArgumentException {
        if (timeout < 0) {
            throw new IllegalArgumentException(String.format("Timeout '%s' is invalid. Cannot be a negative number", timeout));
        }
        if (timeout == 0) {
            int defaultPageLoadTimeout = WindowsActionHelper.getDefaultTimeout();
            logger.logWarning(MessageFormat.format(StringConstants.COMM_LOG_WARNING_INVALID_TIMEOUT, timeout, defaultPageLoadTimeout));
            return defaultPageLoadTimeout;
        }
        return timeout;
    }

    public static WindowsActionHelper create(WindowsSession windowsSession) {
        return new WindowsActionHelper(windowsSession);
    }

    public WebElement findElement(WindowsTestObject testObject) {
        try {
            return this.findElement(testObject, WindowsActionHelper.getDefaultTimeout());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new StepFailedException("Element: " + testObject.getObjectId() + " not found");
        }
    }

    public WebElement findElement(WindowsTestObject testObject, int timeout) {
        try {
            return this.findElement(testObject, timeout, true);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new StepFailedException("Element: " + testObject.getObjectId() + " not found");
        }
    }

    public WebElement findElement(WindowsTestObject testObject, int timeout, boolean continueWhenNotFound) throws IllegalArgumentException, DriverNotStartedException, NoSuchElementException {
        if (this.windowsSession == null) {
            throw new SessionNotStartedException("Windows Session has not started yet!");
        }
        WindowsDriver windowsDriver = this.windowsSession.getRunningDriver();
        if (windowsDriver == null) {
            throw new DriverNotStartedException("WindowsDriver has not started yet!");
        }
        final By elementLocator = this.buildElementLocator(testObject);
        if (elementLocator == null) {
            throw new IllegalArgumentException("No selected locator found");
        }
        timeout = WindowsActionHelper.checkTimeout(timeout);
        try {
            WebElement webElement;
            windowsDriver.manage().timeouts().implicitlyWait(Duration.ofSeconds(0L));
            FluentWait wait = new FluentWait((Object)windowsDriver).withTimeout(Duration.ofSeconds(timeout)).pollingEvery(Duration.ofMillis(50L));
            if (continueWhenNotFound) {
                wait.ignoring(NoSuchElementException.class);
            }
            WebElement webElement2 = webElement = (WebElement)wait.until((Function)new Function<WindowsDriver, WebElement>(){

                @Override
                public WebElement apply(WindowsDriver driver) {
                    return WindowsActionHelper.this.runWithReattachToAppOnFailure(() -> {
                        WindowsDriver currentDriver = WindowsActionHelper.this.windowsSession.getRunningDriver();
                        return currentDriver.findElement(elementLocator);
                    });
                }
            });
            return webElement2;
        }
        finally {
            windowsDriver.manage().timeouts().implicitlyWait(Duration.ofSeconds(WindowsActionHelper.getDefaultTimeout()));
        }
    }

    public List<WebElement> findElements(WindowsTestObject testObject) {
        try {
            return this.findElements(testObject, WindowsActionHelper.getDefaultTimeout());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new StepFailedException("Element: " + testObject.getObjectId() + " not found");
        }
    }

    public List<WebElement> findElements(WindowsTestObject testObject, int timeout) {
        try {
            return this.findElements(testObject, timeout, true);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new StepFailedException("Element: " + testObject.getObjectId() + " not found");
        }
    }

    public List<WebElement> findElements(WindowsTestObject testObject, int timeout, boolean continueWhenNotFound) throws IllegalArgumentException, DriverNotStartedException, NoSuchElementException {
        if (this.windowsSession == null) {
            throw new SessionNotStartedException("Windows Session has not started yet!");
        }
        WindowsDriver windowsDriver = this.windowsSession.getRunningDriver();
        if (windowsDriver == null) {
            throw new DriverNotStartedException("WindowsDriver has not started yet!");
        }
        final By selectedLocator = this.buildElementLocator(testObject);
        if (selectedLocator == null) {
            throw new IllegalArgumentException("No selected locator found");
        }
        try {
            List webElementList;
            windowsDriver.manage().timeouts().implicitlyWait(Duration.ofSeconds(0L));
            FluentWait wait = new FluentWait((Object)windowsDriver).withTimeout(Duration.ofSeconds(timeout)).pollingEvery(Duration.ofMillis(50L));
            if (continueWhenNotFound) {
                wait.ignoring(NoSuchElementException.class);
            }
            List list = webElementList = (List)wait.until((Function)new Function<WindowsDriver, List<WebElement>>(){

                @Override
                public List<WebElement> apply(WindowsDriver arg0) {
                    return WindowsActionHelper.this.runWithReattachToAppOnFailure(() -> {
                        WindowsDriver currentDriver = WindowsActionHelper.this.windowsSession.getRunningDriver();
                        return currentDriver.findElements(selectedLocator);
                    });
                }
            });
            return list;
        }
        finally {
            windowsDriver.manage().timeouts().implicitlyWait(Duration.ofSeconds(WindowsActionHelper.getDefaultTimeout()));
        }
    }

    private By buildElementLocator(WindowsTestObject testObject) {
        if (testObject == null) {
            throw new IllegalArgumentException("Test object cannot be null");
        }
        LocatorStrategy strategy = testObject.getLocatorStrategy();
        String locatorValue = testObject.getLocator();
        if (StringUtils.isEmpty((CharSequence)locatorValue)) {
            throw new IllegalArgumentException(String.format("Test object %s does not have locator for strategy: %s. ", testObject.getObjectId(), locatorValue));
        }
        By finalLocator = null;
        switch (strategy) {
            case ACCESSIBILITY_ID: {
                finalLocator = AppiumBy.accessibilityId((String)locatorValue);
                break;
            }
            case CLASS_NAME: {
                finalLocator = AppiumBy.className((String)locatorValue);
                break;
            }
            case NAME: {
                finalLocator = AppiumBy.name((String)locatorValue);
                break;
            }
            case TAG_NAME: {
                finalLocator = AppiumBy.tagName((String)locatorValue);
                break;
            }
            case XPATH: {
                finalLocator = AppiumBy.xpath((String)locatorValue);
                break;
            }
        }
        return finalLocator;
    }

    private static int getDefaultTimeout() {
        try {
            return RunConfiguration.getElementTimeoutForWindows();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private WebElement findElementFromElement(final WebElement originalElement, final By locator, int timeoutInSeconds, boolean continueWhenNotFound) throws IllegalArgumentException, DriverNotStartedException, NoSuchElementException {
        if (this.windowsSession == null) {
            throw new SessionNotStartedException("Windows Session has not started yet!");
        }
        WindowsDriver windowsDriver = this.windowsSession.getRunningDriver();
        if (windowsDriver == null) {
            throw new IllegalArgumentException("WindowsDriver has not started yet!");
        }
        if (locator == null) {
            throw new IllegalArgumentException("No selected locator found");
        }
        int finalTimeoutInSeconds = WindowsActionHelper.checkTimeout(timeoutInSeconds);
        try {
            WebElement webElement;
            windowsDriver.manage().timeouts().implicitlyWait(Duration.ofSeconds(0L));
            FluentWait wait = new FluentWait((Object)windowsDriver).withTimeout(Duration.ofSeconds(finalTimeoutInSeconds)).pollingEvery(Duration.ofMillis(50L));
            if (continueWhenNotFound) {
                wait.ignoring(NoSuchElementException.class);
            }
            WebElement webElement2 = webElement = (WebElement)wait.until((Function)new Function<WindowsDriver, WebElement>(){

                @Override
                public WebElement apply(WindowsDriver driver) {
                    return originalElement.findElement(locator);
                }
            });
            return webElement2;
        }
        finally {
            windowsDriver.manage().timeouts().implicitlyWait(Duration.ofSeconds(WindowsActionHelper.getDefaultTimeout()));
        }
    }

    public Map<String, String> getAdditionalAttributes(WindowsTestObject testObject) {
        WebElement webElement = this.findElement(testObject, 0);
        if (webElement instanceof RemoteWebElement) {
            RemoteWebElement remoteElement = (RemoteWebElement)webElement;
            WindowsDriver windowsDriver = this.windowsSession.getRunningDriver();
            Object result = windowsDriver.executeScript("windows: getAttributes", new Object[]{remoteElement.getId(), true});
            if (result instanceof Map) {
                Map map = (Map)result;
                HashMap<String, String> attrs = new HashMap<String, String>();
                for (Map.Entry entry : map.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (!(key instanceof String) || !(value instanceof String)) continue;
                    attrs.put((String)key, (String)value);
                }
                return attrs;
            }
        }
        return Map.of();
    }

    public String getText(WindowsTestObject testObject) {
        WebElement webElement = this.findElement(testObject);
        if (webElement == null) {
            throw new StepFailedException("Element: " + testObject.getObjectId() + " not found");
        }
        logger.logDebug("Getting text of test object: " + testObject.getObjectId());
        return webElement.getText();
    }

    public void clearText(WindowsTestObject testObject) {
        WebElement webElement = this.findElement(testObject);
        this.clearText(testObject, webElement);
    }

    public void clearText(WindowsTestObject testObject, WebElement webElement) {
        if (webElement == null) {
            throw new StepFailedException("Element: " + testObject.getObjectId() + " not found");
        }
        logger.logDebug("Clearing text of test object: " + testObject.getObjectId());
        logger.logDebug("Text before clearing: " + webElement.getText());
        webElement.clear();
    }

    public void click(WindowsTestObject testObject) {
        WebElement webElement = this.findElement(testObject);
        if (webElement == null) {
            throw new StepFailedException("Element: " + testObject.getObjectId() + " not found");
        }
        logger.logInfo("Clicking on element: " + testObject.getObjectId());
        webElement.click();
    }

    public void clickOffset(WindowsTestObject testObject, int offsetX, int offsetY) {
        WebElement webElement = this.findElement(testObject);
        if (webElement == null) {
            throw new StepFailedException("Element: " + testObject.getObjectId() + " not found");
        }
        logger.logInfo("Clicking on element: " + testObject.getObjectId() + " at offset " + offsetX + " ," + offsetY);
        Actions builder = new Actions((WebDriver)this.windowsSession.getRunningDriver());
        builder.moveToElement(webElement, offsetX, offsetY).click().build().perform();
    }

    public void rightClickOffset(WindowsTestObject testObject, int offsetX, int offsetY) {
        WebElement webElement = this.findElement(testObject);
        if (webElement == null) {
            throw new StepFailedException("Element: " + testObject.getObjectId() + " not found");
        }
        logger.logInfo("Right clicking on element: " + testObject.getObjectId() + " at offset " + offsetX + " ," + offsetY);
        WindowsDriver windowsDriver = this.windowsSession.getRunningDriver();
        Actions action = new Actions((WebDriver)windowsDriver);
        action.moveToElement(webElement, offsetX, offsetY).contextClick().perform();
    }

    public void rightClick(WindowsTestObject testObject) {
        WebElement webElement = this.findElement(testObject);
        if (webElement == null) {
            throw new StepFailedException("Element: " + testObject.getObjectId() + " not found");
        }
        logger.logInfo("Right clicking on element: " + testObject.getObjectId());
        WindowsDriver windowsDriver = this.windowsSession.getRunningDriver();
        Actions action = new Actions((WebDriver)windowsDriver);
        action.moveToElement(webElement).contextClick().perform();
    }

    public void doubleClick(WindowsTestObject testObject) {
        WebElement webElement = this.findElement(testObject);
        if (webElement == null) {
            throw new StepFailedException("Element: " + testObject.getObjectId() + " not found");
        }
        logger.logInfo("Double clicking on element: " + testObject.getObjectId());
        WindowsDriver windowsDriver = this.windowsSession.getRunningDriver();
        Actions action = new Actions((WebDriver)windowsDriver);
        action.moveToElement(webElement);
        action.doubleClick();
        action.perform();
    }

    public void hover(WindowsTestObject testObject) {
        WebElement webElement = this.findElement(testObject);
        if (webElement == null) {
            throw new StepFailedException("Element: " + testObject.getObjectId() + " not found");
        }
        if (!webElement.isDisplayed()) {
            throw new StepFailedException("Element: " + testObject.getObjectId() + " not visible to hover");
        }
        logger.logInfo("Hovering over element: " + testObject.getObjectId());
        WindowsDriver windowsDriver = this.windowsSession.getRunningDriver();
        Actions action = new Actions((WebDriver)windowsDriver);
        action.moveToElement(webElement);
        action.perform();
    }

    public void sendKeys(WindowsTestObject testObject, CharSequence ... keys) {
        WebElement windowElement = this.findElement(testObject);
        if (!this.isModifierKeyIncluded(keys)) {
            windowElement.sendKeys(keys);
            return;
        }
        WindowsDriver windowsDriver = this.windowsSession.getRunningDriver();
        Actions actions = this.buildActionsForSendKeys(windowsDriver, windowElement, keys);
        actions.perform();
    }

    private Keys extractModifierKey(char c) {
        for (Keys modifierKey : MODIFIER_KEYS) {
            if (c != modifierKey.charAt(0)) continue;
            return modifierKey;
        }
        return null;
    }

    private boolean isModifierKeyIncluded(CharSequence ... keys) {
        CharSequence[] charSequenceArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence key = charSequenceArray[n2];
            int i = 0;
            while (i < key.length()) {
                if (this.extractModifierKey(key.charAt(i)) != null) {
                    return true;
                }
                ++i;
            }
            ++n2;
        }
        return false;
    }

    private Actions buildActionsForSendKeys(WindowsDriver windowsDriver, WebElement element, CharSequence ... keys) {
        Actions actions = new Actions((WebDriver)windowsDriver);
        actions.click(element);
        StringBuilder normalText = new StringBuilder();
        ArrayList<Keys> modifierKeysPressed = new ArrayList<Keys>();
        boolean gotNullKey = false;
        CharSequence[] charSequenceArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence key = charSequenceArray[n2];
            int i = 0;
            while (i < key.length()) {
                char c = key.charAt(i);
                if (c == Keys.NULL.charAt(0)) {
                    gotNullKey = true;
                    break;
                }
                Keys modifierKey = this.extractModifierKey(c);
                if (modifierKey != null) {
                    if (!StringUtils.isEmpty((CharSequence)normalText)) {
                        actions.sendKeys(new CharSequence[]{normalText.toString()});
                        normalText.setLength(0);
                    }
                    actions.keyDown((CharSequence)modifierKey);
                    modifierKeysPressed.add(modifierKey);
                } else {
                    normalText.append(c);
                }
                ++i;
            }
            if (gotNullKey) break;
            ++n2;
        }
        if (!StringUtils.isEmpty((CharSequence)normalText)) {
            actions.sendKeys(new CharSequence[]{normalText.toString()});
        }
        for (Keys modifierKey : modifierKeysPressed) {
            actions.keyUp((CharSequence)modifierKey);
        }
        return actions;
    }

    public void setText(WindowsTestObject testObject, String text) {
        WebElement windowElement = this.findElement(testObject);
        this.setText(testObject, windowElement, text);
    }

    public void setText(WindowsTestObject testObject, WebElement windowElement, String text) {
        logger.logDebug("Setting text on test object: " + testObject.getObjectId());
        windowElement.sendKeys(new CharSequence[]{text});
    }

    public Point getPosition(WindowsTestObject testObject) {
        WebElement windowElement = this.findElement(testObject);
        return windowElement.getLocation();
    }

    public Rectangle getRect(WindowsTestObject testObject) {
        WebElement windowElement = this.findElement(testObject);
        Point position = windowElement.getLocation();
        Dimension size = windowElement.getSize();
        return new Rectangle(position.x, position.y, size.height, size.width);
    }

    public void selectComboBoxItemByLabel(WindowsTestObject testObject, String labelText, int timeoutInSeconds) {
        WebElement combobox = this.findElement(testObject);
        if (combobox == null) {
            throw new StepFailedException("Element: " + testObject.getObjectId() + " not found");
        }
        if (combobox instanceof RemoteWebElement) {
            RemoteWebElement remoteCombobox = (RemoteWebElement)combobox;
            WindowsDriver windowsDriver = this.windowsSession.getRunningDriver();
            windowsDriver.executeScript("windows: selectFromComboBox", new Object[]{remoteCombobox.getId(), labelText, timeoutInSeconds});
        }
    }

    public void closeApp() {
        this.runWithReattachToAppOnFailure(() -> {
            this.windowsSession.getRunningDriver().close();
            return null;
        });
    }

    public void takeScreenshot(String screenshotLocation) throws IOException {
        byte[] screenshotBytes = this.runWithReattachToAppOnFailure(() -> {
            WindowsDriver currentDriver = this.windowsSession.getRunningDriver();
            return (byte[])currentDriver.getScreenshotAs(OutputType.BYTES);
        });
        this.writeBytesToPngFile(screenshotBytes, screenshotLocation);
    }

    public void takeElementScreenshot(String screenshotLocation, WindowsTestObject testObject) throws IOException {
        WebElement element = this.findElement(testObject);
        if (element == null) {
            throw new StepFailedException("Element: " + testObject.getObjectId() + " not found");
        }
        byte[] screenshotBytes = (byte[])element.getScreenshotAs(OutputType.BYTES);
        this.writeBytesToPngFile(screenshotBytes, screenshotLocation);
    }

    private void writeBytesToPngFile(byte[] screenshotBytes, String filePath) throws IOException {
        File screenshotFile = new File(filePath);
        PathUtil.ensureDirectory((File)screenshotFile, (boolean)true);
        Throwable throwable = null;
        Object var5_6 = null;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(screenshotBytes);){
            BufferedImage image = ImageIO.read(inputStream);
            ImageIO.write((RenderedImage)image, "png", screenshotFile);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void switchToDesktop() throws IOException, URISyntaxException {
        this.windowsSession.getOrCreateDesktopDriver();
        this.windowsSession.setTargetAppType(WindowsSession.TargetAppType.ROOT_APP);
    }

    public void switchToApplication() {
        this.windowsSession.setTargetAppType(WindowsSession.TargetAppType.SPECIFIC_APP);
    }

    public WindowsDriver switchToWindowTitle(String windowName, StringMatchingStrategy strategy) throws IOException, URISyntaxException, InterruptedException {
        DesiredCapabilities retryDesiredCapabilities = new WindowsDesiredCapsBuilder().merge(this.windowsSession.getInitCapabilities()).withAppTopLevelWindowTitleMatch((String)(switch (strategy) {
            case StringMatchingStrategy.EXACT, StringMatchingStrategy.REGEXP -> windowName;
            default -> ".*" + windowName + ".*";
        })).build();
        WindowsDriver windowsDriver = WindowsDriverFactory.newWindowsDriver(this.windowsSession.getRemoteAddressURL(), retryDesiredCapabilities, this.windowsSession.getProxyInfo());
        this.windowsSession.setApplicationDriver(windowsDriver);
        this.windowsSession.setTargetAppType(WindowsSession.TargetAppType.SPECIFIC_APP);
        this.bringAppToForegroundIfPossible();
        return windowsDriver;
    }

    public WindowsDriver switchToWindow(WindowsTestObject windowsObject) throws IOException, URISyntaxException, IllegalAccessException {
        this.windowsSession.getOrCreateDesktopDriver();
        WebElement webElement = this.findElement(windowsObject);
        if (webElement == null) {
            throw new NoSuchElementException("No such window matches with the given windowsObject");
        }
        String appTopLevelWindow = webElement.getDomAttribute("NativeWindowHandle");
        if (StringUtils.isNotEmpty((CharSequence)appTopLevelWindow)) {
            DesiredCapabilities retryDesiredCapabilities = new WindowsDesiredCapsBuilder().merge(this.windowsSession.getInitCapabilities()).withAppTopLevelWindow(Integer.toHexString(Integer.parseInt(appTopLevelWindow))).build();
            WindowsDriver windowsDriver = WindowsDriverFactory.newWindowsDriver(this.windowsSession.getRemoteAddressURL(), retryDesiredCapabilities, this.windowsSession.getProxyInfo());
            windowsDriver.manage().timeouts().implicitlyWait(Duration.ofSeconds(WindowsActionHelper.getDefaultTimeout()));
            this.windowsSession.setApplicationDriver(windowsDriver);
            this.windowsSession.setTargetAppType(WindowsSession.TargetAppType.SPECIFIC_APP);
            return windowsDriver;
        }
        throw new NotFoundException("The found window does not have NativeWindowHandle property");
    }

    public void bringAppToForegroundIfPossible() {
        if (!WindowsSession.TargetAppType.SPECIFIC_APP.equals((Object)this.windowsSession.getTargetAppType())) {
            return;
        }
        String handle = this.windowsSession.getRunningDriver().getWindowHandle();
        this.windowsSession.getRunningDriver().switchTo().window(handle);
    }

    public void reattachToApplicationIfPossible() throws IOException, URISyntaxException, InterruptedException {
        if (this.windowsSession == null) {
            return;
        }
        if (WindowsSession.TargetAppType.ROOT_APP.equals((Object)this.windowsSession.getTargetAppType())) {
            WindowsActionHelper.create(this.windowsSession).switchToDesktop();
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.windowsSession.getAppTitle())) {
            return;
        }
        this.switchToWindowTitle(this.windowsSession.getAppTitle(), this.windowsSession.getAppTitleMatchingStrategy());
    }

    private <T> T runWithReattachToAppOnFailure(Supplier<T> action) {
        try {
            return action.get();
        }
        catch (Exception ex) {
            if (ex.getMessage() != null && ex.getMessage().contains(FLAUI_MSG_APP_CLOSED_OR_LOST_CONNECTION)) {
                try {
                    this.reattachToApplicationIfPossible();
                }
                catch (Exception ex2) {
                    logger.logWarning(MessageFormat.format("Failed to re-attach to the application or desktop: {0}", ex2.getMessage()));
                }
                return action.get();
            }
            throw ex;
        }
    }

    static /* synthetic */ WindowsSession access$0(WindowsActionHelper windowsActionHelper) {
        return windowsActionHelper.windowsSession;
    }
}

