/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.dataprovider;

import com.kms.katalon.dal.IFolderDataProvider;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.fileservice.dataprovider.setting.FileServiceDataProviderSetting;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.util.Collections;
import java.util.List;

public class FolderFileServiceDataProvider
implements IFolderDataProvider {
    public FolderEntity addNewFolder(FolderEntity parentFolder, String folderName) throws Exception {
        return FolderFileServiceManager.addNewFolder(parentFolder, folderName);
    }

    public FolderEntity addNewRootFolder(ProjectEntity project, String folderName) throws Exception {
        return FolderFileServiceManager.addNewRootFolder(project, folderName);
    }

    public FolderEntity getFolder(String folderLocation) throws Exception {
        return FolderFileServiceManager.getFolder(folderLocation);
    }

    public List<FileEntity> getChildren(FolderEntity folder) throws Exception {
        if (folder != null) {
            if (folder.getFolderType() == FolderEntity.FolderType.REPORT) {
                return FolderFileServiceManager.getChildReportsOfFolder(folder);
            }
            if (folder.getFolderType() == FolderEntity.FolderType.INCLUDE) {
                return new FileServiceDataProviderSetting().getSystemFileDataProvider().getChildren(folder);
            }
            if (folder.getFolderType() == FolderEntity.FolderType.USER) {
                return new FileServiceDataProviderSetting().getUserFileDataProvider().getChildren(folder);
            }
            return FolderFileServiceManager.getChildren(folder);
        }
        return Collections.emptyList();
    }

    public void updateFolderName(FolderEntity folder, String newName) throws Exception {
        FolderFileServiceManager.updateFolderName(folder, newName);
    }

    public void deleteFolder(FolderEntity folder) throws Exception {
        FolderFileServiceManager.deleteFolder(folder);
    }

    public FolderEntity getTestSuiteRoot(ProjectEntity project) throws Exception {
        return FolderFileServiceManager.getTestSuiteRoot(project);
    }

    public FolderEntity getTestCaseRoot(ProjectEntity project) throws Exception {
        return FolderFileServiceManager.getTestCaseRoot(project);
    }

    public FolderEntity getTestDataRoot(ProjectEntity project) throws Exception {
        return FolderFileServiceManager.getTestDataRoot(project);
    }

    public FolderEntity getObjectRepositoryRoot(ProjectEntity project) throws Exception {
        return FolderFileServiceManager.getObjectRepositoryRoot(project);
    }

    public FolderEntity getKeywordRoot(ProjectEntity project) throws Exception {
        return FolderFileServiceManager.getKeywordRoot(project);
    }

    public FolderEntity getReportRoot(ProjectEntity project) throws Exception {
        return FolderFileServiceManager.getReportRoot(project);
    }

    public FolderEntity getCheckpointRoot(ProjectEntity project) throws Exception {
        return FolderFileServiceManager.getCheckpointRoot(project);
    }

    public FolderEntity getTestListenerRoot(ProjectEntity project) throws Exception {
        return FolderFileServiceManager.getTestListenerRoot(project);
    }

    public static List<TestSuiteEntity> getChildTestSuitesOfFolder(FolderEntity folder) throws Exception {
        return EntityFileServiceManager.getChildren(folder, TestSuiteEntity.class);
    }

    public FolderEntity copyFolder(FolderEntity folder, FolderEntity destinationFolder) throws Exception {
        return FolderFileServiceManager.copyFolder(folder, destinationFolder);
    }

    public FolderEntity moveFolder(FolderEntity folder, FolderEntity destinationFolder) throws Exception {
        if (destinationFolder.getFolderType() == FolderEntity.FolderType.INCLUDE) {
            return new FileServiceDataProviderSetting().getSystemFileDataProvider().moveFolder(folder, destinationFolder);
        }
        return FolderFileServiceManager.moveFolder(folder, destinationFolder);
    }

    public void refreshFolder(FolderEntity folder) throws Exception {
        FolderFileServiceManager.refreshFolder(folder);
    }

    public FolderEntity saveFolder(FolderEntity folder) throws Exception {
        return FolderFileServiceManager.saveFolder(folder);
    }

    public String getAvailableFolderName(FolderEntity parentFolder, String name) throws Exception {
        return FolderFileServiceManager.getAvailableFolderName(parentFolder, name);
    }

    public List<TestCaseEntity> getTestCaseChildren(FolderEntity parentFolder) throws Exception {
        return FolderFileServiceManager.getChildTestCasesOfFolder(parentFolder);
    }

    public FolderEntity getProfileRoot(ProjectEntity project) throws DALException {
        return FolderFileServiceManager.getProfileRoot(project);
    }

    public FolderEntity getIncludeRoot(ProjectEntity project) throws DALException {
        return FolderFileServiceManager.getSourceRoot(project);
    }

    public FolderEntity getFeatureRoot(ProjectEntity project) throws DALException {
        return FolderFileServiceManager.getFeatureRoot(project);
    }

    public FolderEntity getGroovyScriptRoot(ProjectEntity project) throws DALException {
        return FolderFileServiceManager.getGroovyScriptRoot(project);
    }

    public List<FileEntity> getRootUserFilesOrFolders(ProjectEntity project) throws DALException {
        return FolderFileServiceManager.getRootUserFilesOrFolders(project);
    }
}

