/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.manager;

import com.kms.katalon.dal.ITestCaseDataProvider;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.dal.fileservice.FileServiceConstant;
import com.kms.katalon.dal.fileservice.constants.StringConstants;
import com.kms.katalon.dal.fileservice.dataprovider.setting.FileServiceDataProviderSetting;
import com.kms.katalon.dal.fileservice.manager.DataFileFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.TestSuiteFileServiceManager;
import com.kms.katalon.dal.fileservice.strategies.DefaultEntitySaveStrategy;
import com.kms.katalon.dal.fileservice.strategies.FilePathPrecheckEntityLoadStrategy;
import com.kms.katalon.dal.fileservice.strategies.IEntityLoadStrategy;
import com.kms.katalon.dal.fileservice.strategies.StringMatchPrecheckEntityLoadStrategy;
import com.kms.katalon.dal.fileservice.util.PathValidationUtil;
import com.kms.katalon.entity.dal.exception.DuplicatedFileNameException;
import com.kms.katalon.entity.dal.exception.LengthExceedLimitationException;
import com.kms.katalon.entity.dal.exception.NoEntityException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.groovy.reference.EntityReferenceIndexService;
import com.kms.katalon.groovy.reference.TestArtifactScriptRefactor;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.ExecutionTimeTracker;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;

public class TestCaseFileServiceManager {
    public static String getAvailableName(FolderEntity parentFolder, String name) throws Exception {
        if (parentFolder != null) {
            Object newname = name;
            ArrayList<String> fileNames = new ArrayList<String>();
            for (FileEntity testCase : FolderFileServiceManager.getChildren(parentFolder)) {
                fileNames.add(testCase.getName().toLowerCase());
            }
            if (fileNames.contains(((String)newname).toLowerCase())) {
                int i = 1;
                while (fileNames.contains(((String)newname).toLowerCase())) {
                    newname = name + " (" + i + ")";
                    ++i;
                }
            }
            return newname;
        }
        return name;
    }

    public static TestCaseEntity saveNewTestCase(TestCaseEntity newTestCase) throws Exception {
        if (newTestCase == null || newTestCase.getProject() == null || newTestCase.getParentFolder() == null) {
            return null;
        }
        PathValidationUtil.validatePathLength((FileEntity)newTestCase);
        EntityService.getInstance().saveEntity((FileEntity)newTestCase);
        FolderEntity parentFolder = newTestCase.getParentFolder();
        GroovyUtil.refreshScriptTestCaseClasspath((ProjectEntity)newTestCase.getProject(), (FolderEntity)parentFolder);
        FolderFileServiceManager.refreshFolder(parentFolder);
        return newTestCase;
    }

    public static TestCaseEntity getTestCase(String testCasePk) throws Exception {
        FileEntity entity = EntityFileServiceManager.get(new File(testCasePk));
        if (entity instanceof TestCaseEntity) {
            return (TestCaseEntity)entity;
        }
        return null;
    }

    public static void initTestCase(TestCaseEntity testCase) throws Exception {
        if (testCase != null && testCase.getProject() != null) {
            testCase.getDataFiles().clear();
            String projectFolderLocation = testCase.getProject().getFolderLocation();
            for (String dataFileLocation : testCase.getDataFileLocations()) {
                DataFileEntity dataFile = DataFileFileServiceManager.getDataFile(projectFolderLocation + File.separator + dataFileLocation);
                if (dataFile == null) continue;
                testCase.getDataFiles().add(dataFile);
            }
        }
    }

    public static TestCaseEntity updateTestCase(TestCaseEntity testCase) throws Exception {
        return TestCaseFileServiceManager.updateTestCase(testCase, ITestCaseDataProvider.ReferenceUpdateOption.UPDATE_REFERENCE);
    }

    public static TestCaseEntity updateTestCase(TestCaseEntity testCase, ITestCaseDataProvider.ReferenceUpdateOption referenceUpdateOption) throws Exception {
        if (testCase != null && testCase.getProject() != null) {
            ITestCaseDataProvider.ReferenceUpdateOption finalReferenceUpdateOption;
            ProjectEntity project = testCase.getProject();
            TestCaseFileServiceManager.validateData(testCase);
            String oldTestCaseLocation = EntityService.getInstance().getEntityCache().getKey((FileEntity)testCase);
            if (oldTestCaseLocation == null) {
                PathValidationUtil.validatePathLength((FileEntity)testCase);
                oldTestCaseLocation = testCase.getLocation();
            }
            ITestCaseDataProvider.ReferenceUpdateOption referenceUpdateOption2 = finalReferenceUpdateOption = referenceUpdateOption != null ? referenceUpdateOption : ITestCaseDataProvider.ReferenceUpdateOption.UPDATE_REFERENCE;
            if (finalReferenceUpdateOption.equals((Object)ITestCaseDataProvider.ReferenceUpdateOption.UPDATE_REFERENCE)) {
                TestCaseFileServiceManager.refactorReferencingTestSuites(project, testCase, oldTestCaseLocation);
            }
            if (EntityService.getInstance().getEntityCache().contains((FileEntity)testCase) && oldTestCaseLocation != null && !oldTestCaseLocation.equals(testCase.getLocation())) {
                EntityService.getInstance().getEntityCache().remove((FileEntity)testCase, true);
            }
            EntityService.getInstance().saveEntity((FileEntity)testCase);
            return testCase;
        }
        return null;
    }

    private static void refactorReferencingTestSuites(ProjectEntity project, TestCaseEntity testCase, String oldTestCaseLocation) throws Exception {
        File projectFile = new File(project.getLocation());
        String oldRelativeTcLocation = oldTestCaseLocation.substring(projectFile.getParent().length() + 1);
        String oldRelativeTcId = FilenameUtils.removeExtension((String)oldRelativeTcLocation).replace(File.separator, "/");
        String newRelativeTcId = testCase.getRelativePathForUI().replace(File.separator, "/");
        FolderEntity testSuiteRoot = FolderFileServiceManager.getTestSuiteRoot(project);
        IEntityLoadStrategy entityLoadStrategy = null;
        if (EntityReferenceIndexService.getInstance().isReady()) {
            try {
                Throwable throwable = null;
                Object var10_11 = null;
                try (Stream<Path> paths = Files.walk(Paths.get(testSuiteRoot.getLocation(), new String[0]), new FileVisitOption[0]);){
                    List testSuiteXmlFiles = paths.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> path.toString().endsWith(".ts")).map(Path::toFile).collect(Collectors.toList());
                    final Set filteredPathStringSet = EntityReferenceIndexService.getInstance().searchFilesReferencingEntityId(oldRelativeTcId, testSuiteXmlFiles).stream().map(path -> path.getAbsolutePath()).collect(Collectors.toSet());
                    entityLoadStrategy = new FilePathPrecheckEntityLoadStrategy(new Predicate<String>(){

                        @Override
                        public boolean test(String filePath) {
                            boolean passed = filteredPathStringSet.contains(filePath);
                            return passed;
                        }
                    });
                    LogUtil.logInfo((String)String.format("Use entity reference index to find test suites to rename", new Object[0]));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {}
        }
        if (entityLoadStrategy == null) {
            final String searchText = String.format("<testCaseId>%s</testCaseId>", oldRelativeTcId);
            entityLoadStrategy = new StringMatchPrecheckEntityLoadStrategy(new Predicate<String>(){

                @Override
                public boolean test(String fileContent) {
                    boolean passed = StringUtils.contains((String)fileContent, (String)searchText);
                    return passed;
                }
            });
        }
        String taskName = String.format("Load all test suites to rename ref (%s)", oldRelativeTcId);
        ExecutionTimeTracker.getInstance().start(taskName);
        List<TestSuiteEntity> lstTestSuites = FolderFileServiceManager.getDescendantTestSuitesOfFolder(testSuiteRoot, entityLoadStrategy);
        ExecutionTimeTracker.getInstance().stop(taskName);
        LogUtil.logInfo((String)String.format("Found %d test suite(s) to rename ref", lstTestSuites.size()));
        DefaultEntitySaveStrategy entitySaveStrategy = DefaultEntitySaveStrategy.getInstance();
        String taskName2 = "Save test suite(s) after renaming test case";
        ExecutionTimeTracker.getInstance().start(taskName2);
        for (TestSuiteEntity testSuite : lstTestSuites) {
            boolean hasTestCaseIdChange = false;
            boolean hasTestCaseVariablesChange = false;
            for (TestSuiteTestCaseLink testCaseLink : testSuite.getTestSuiteTestCaseLinks()) {
                if (!testCaseLink.getTestCaseId().equals(oldRelativeTcId)) continue;
                if (!oldRelativeTcId.equals(newRelativeTcId)) {
                    hasTestCaseIdChange = true;
                }
                testCaseLink.setTestCaseId(newRelativeTcId);
                ArrayList<VariableLink> retainedVariableLinks = new ArrayList<VariableLink>();
                for (VariableEntity variable : testCase.getVariables()) {
                    boolean isNewVariable = true;
                    for (VariableLink variableLink : testCaseLink.getVariableLinks()) {
                        if (!variable.getId().equals(variableLink.getVariableId())) continue;
                        isNewVariable = false;
                        retainedVariableLinks.add(variableLink);
                        break;
                    }
                    if (!isNewVariable) continue;
                    VariableLink newVariableLink = new VariableLink();
                    newVariableLink.setVariableId(variable.getId());
                    testCaseLink.getVariableLinks().add(newVariableLink);
                    retainedVariableLinks.add(newVariableLink);
                    hasTestCaseVariablesChange = true;
                }
                boolean changed = testCaseLink.getVariableLinks().retainAll(retainedVariableLinks);
                if (!changed) continue;
                hasTestCaseVariablesChange = true;
            }
            if (hasTestCaseVariablesChange) {
                EntityService.getInstance().saveEntity((FileEntity)testSuite);
                continue;
            }
            if (!hasTestCaseIdChange) continue;
            EntityService.getInstance().saveEntity((FileEntity)testSuite, entitySaveStrategy);
        }
        ExecutionTimeTracker.getInstance().stop(taskName2);
    }

    public static TestCaseEntity mergeTestCase(String testCasePk, String folderPk) throws Exception {
        TestCaseEntity testCase = (TestCaseEntity)EntityService.getInstance().getEntityByPath(testCasePk);
        FolderEntity folder = (FolderEntity)EntityService.getInstance().getEntityByPath(folderPk);
        if (testCase != null && folder != null) {
            if (EntityService.getInstance().getEntityCache().contains((FileEntity)testCase)) {
                EntityService.getInstance().getEntityCache().remove((FileEntity)testCase, false);
            }
            FileUtils.moveFileToDirectory((File)new File(testCase.getLocation()), (File)new File(folder.getLocation()), (boolean)false);
            testCase.setParentFolder(folder);
            EntityService.getInstance().saveEntity((FileEntity)testCase);
        }
        return testCase;
    }

    private static void validateData(TestCaseEntity testCaseEntity) throws Exception {
        TestCaseEntity oldEntity;
        if (testCaseEntity.getTag() != null && testCaseEntity.getTag().length() >= 200) {
            throw new LengthExceedLimitationException();
        }
        EntityService.getInstance().validateName(testCaseEntity.getName());
        File file = new File(testCaseEntity.getLocation());
        if (file.exists() && !(oldEntity = (TestCaseEntity)EntityService.getInstance().getEntityByPath(testCaseEntity.getLocation())).getTestCaseGuid().equals(testCaseEntity.getTestCaseGuid())) {
            throw new DuplicatedFileNameException(MessageFormat.format(StringConstants.MNG_EXC_EXISTED_TEST_CASE_NAME_INSENSITVE, testCaseEntity.getName()));
        }
    }

    public static TestCaseEntity copyTestCase(TestCaseEntity testCase, FolderEntity destinationFolder) throws Exception {
        TestCaseEntity oldTestCase = testCase.clone();
        TestCaseEntity newTestCase = EntityFileServiceManager.copy(testCase, destinationFolder);
        IProject groovyProject = GroovyUtil.getGroovyProject((ProjectEntity)newTestCase.getProject());
        IFolder testCaseScriptFolder = groovyProject.getFolder(GroovyUtil.getScriptPackageRelativePathForTestCase((TestCaseEntity)newTestCase));
        GroovyUtil.copyScriptFolder((TestCaseEntity)oldTestCase, (String)testCaseScriptFolder.getLocation().toString());
        return newTestCase;
    }

    public static TestCaseEntity moveTestCase(TestCaseEntity testCase, FolderEntity destinationFolder) throws Exception {
        TestCaseFileServiceManager.validateNewTestCaseLocation(testCase, (FileEntity)destinationFolder);
        String oldTestCaseLocation = testCase.getLocation();
        String oldTestCaseRelativeLocation = testCase.getIdForDisplay();
        String oldName = testCase.getName();
        TestCaseEntity oldTestCase = testCase.clone();
        TestCaseEntity newTestCase = null;
        FolderEntity oldDestinationFolder = testCase.getParentFolder();
        String newTestCaseLocation = null;
        try {
            newTestCase = EntityFileServiceManager.move(testCase, destinationFolder);
            if (!newTestCase.getLocation().equals(oldTestCaseLocation)) {
                String newScriptFolderLocation = newTestCase.getProject().getFolderLocation() + File.separator + GroovyUtil.getScriptPackageRelativePathForTestCase((TestCaseEntity)newTestCase);
                if (TestCaseFileServiceManager.isGroovyScriptFolder(newScriptFolderLocation)) {
                    throw new DuplicatedFileNameException(MessageFormat.format(StringConstants.MNG_EXC_EXISTED_SCRIPT_FOLDER_NAME, newScriptFolderLocation));
                }
                newTestCaseLocation = newTestCase.getLocation();
                TestCaseFileServiceManager.refactorReferencingTestSuites(destinationFolder.getProject(), testCase, oldTestCaseLocation);
                TestArtifactScriptRefactor.createForTestCaseEntity((String)oldTestCaseRelativeLocation).updateReferenceForProject(newTestCase.getIdForDisplay(), newTestCase.getProject());
                GroovyUtil.moveScriptFolder((TestCaseEntity)oldTestCase, (FolderEntity)destinationFolder);
                GroovyUtil.getTestCaseScriptSourceFolder((ProjectEntity)newTestCase.getProject()).refreshLocal(2, null);
            }
        }
        catch (Exception e) {
            EntityFileServiceManager.move(newTestCase, oldDestinationFolder, oldName);
            if (newTestCaseLocation != null) {
                TestCaseFileServiceManager.refactorReferencingTestSuites(oldDestinationFolder.getProject(), newTestCase, newTestCaseLocation);
            }
            throw e;
        }
        return testCase;
    }

    private static void validateNewTestCaseLocation(TestCaseEntity testCase, FileEntity destinationFolder) throws Exception {
        EntityService.getInstance().validateName(testCase.getName());
        String newTestCaseLocation = destinationFolder.getLocation() + File.separator + testCase.getName();
        PathValidationUtil.validatePathLength(newTestCaseLocation, (FileEntity)testCase);
        File newTestCase = new File(newTestCaseLocation);
        if (newTestCase.exists()) {
            throw new DuplicatedFileNameException(MessageFormat.format(StringConstants.MNG_EXC_EXISTED_TEST_CASE_NAME_INSENSITVE, newTestCaseLocation));
        }
        File newScriptFolder = new File(testCase.getProject().getFolderLocation() + File.separator + GroovyUtil.getScriptPackageRelativePathForTestCase((String)newTestCaseLocation));
        if (newScriptFolder.exists() && newScriptFolder.listFiles().length > 0) {
            throw new DuplicatedFileNameException(MessageFormat.format(StringConstants.MNG_EXC_EXISTED_SCRIPT_FOLDER_NAME, newScriptFolder.getAbsolutePath()));
        }
    }

    private static boolean isGroovyScriptFolder(String folderLocation) throws Exception {
        File newScriptFolder = new File(folderLocation);
        return newScriptFolder.exists() && GroovyUtil.isContainsGroovyScript((File)newScriptFolder);
    }

    private static void copyTestCaseFolder(FolderEntity srcFolderEntity, FolderEntity destFolderEntity, List<TestCaseEntity> pastedTestCases) throws Exception {
        for (Object childObject : srcFolderEntity.getChildrenEntities()) {
            if (childObject instanceof TestCaseEntity) {
                TestCaseEntity pastedTestCase = TestCaseFileServiceManager.copyTestCase((TestCaseEntity)childObject, destFolderEntity);
                pastedTestCases.add(pastedTestCase);
                continue;
            }
            if (!(childObject instanceof FolderEntity)) continue;
            FolderEntity folderEntity = (FolderEntity)childObject;
            FolderEntity newFolderEntity = folderEntity.clone();
            newFolderEntity.setProject(destFolderEntity.getProject());
            newFolderEntity.setParentFolder(destFolderEntity);
            PathValidationUtil.validatePathLength((FileEntity)newFolderEntity);
            EntityService.getInstance().saveEntity((FileEntity)newFolderEntity);
            TestCaseFileServiceManager.copyTestCaseFolder(folderEntity, newFolderEntity, pastedTestCases);
        }
    }

    public static FolderEntity copyTestCaseFolder(FolderEntity folder, FolderEntity destinationFolder) throws Exception {
        if (folder != null && destinationFolder != null) {
            FolderEntity newFolder = folder.clone();
            File fFolder = new File(destinationFolder.getLocation() + File.separator + folder.getName());
            if (fFolder.exists()) {
                String name = EntityService.getInstance().getAvailableName(destinationFolder.getLocation(), folder.getName() + " - Copy", false);
                newFolder.setName(name);
            }
            newFolder.setProject(destinationFolder.getProject());
            newFolder.setParentFolder(destinationFolder);
            PathValidationUtil.validatePathLength((FileEntity)newFolder);
            EntityService.getInstance().saveEntity((FileEntity)newFolder);
            ArrayList<TestCaseEntity> pastedTestCases = new ArrayList<TestCaseEntity>();
            TestCaseFileServiceManager.copyTestCaseFolder(folder, newFolder, pastedTestCases);
            GroovyUtil.getGroovyProject((ProjectEntity)destinationFolder.getProject()).refreshLocal(2, null);
            return newFolder;
        }
        return null;
    }

    public static TestCaseEntity renameTestCase(TestCaseEntity testCase, String newName) throws Exception {
        TestCaseFileServiceManager.validateNewName(testCase, newName);
        String originalName = testCase.getName();
        String oldRelativeTcId = testCase.getRelativePathForUI().replace(File.separator, "/");
        TestCaseEntity oldTestCase = testCase.clone();
        String oldTestCaseLocation = testCase.getLocation();
        try {
            testCase.setName(newName);
            PathValidationUtil.validatePathLength((FileEntity)testCase);
            ProjectEntity project = testCase.getProject();
            TestCaseFileServiceManager.refactorReferencingTestSuites(project, testCase, oldTestCaseLocation);
            if (EntityService.getInstance().getEntityCache().contains((FileEntity)testCase)) {
                EntityService.getInstance().getEntityCache().remove((FileEntity)testCase, true);
            }
            EntityService.getInstance().saveEntity((FileEntity)testCase);
            String newRelativeTcId = testCase.getRelativePathForUI().replace(File.separator, "/");
            TestArtifactScriptRefactor.createForTestCaseEntity((String)oldRelativeTcId).updateReferenceForProject(newRelativeTcId, project);
            String newScriptFolderPath = project.getFolderLocation() + File.separator + GroovyUtil.getScriptPackageRelativePathForTestCase((TestCaseEntity)testCase);
            GroovyUtil.moveScriptFolder((TestCaseEntity)oldTestCase, (String)newScriptFolderPath);
            IFolder newScriptFolder = GroovyUtil.getGroovyProject((ProjectEntity)project).getFolder(GroovyUtil.getScriptPackageRelativePathForTestCase((String)newRelativeTcId));
            if (newScriptFolder.exists()) {
                newScriptFolder.refreshLocal(2, null);
            }
            return testCase;
        }
        catch (Exception e) {
            String newTestCaseLocation = testCase.getLocation();
            testCase.setName(originalName);
            TestCaseFileServiceManager.refactorReferencingTestSuites(testCase.getProject(), testCase, newTestCaseLocation);
            throw e;
        }
    }

    private static void validateNewName(TestCaseEntity testCase, String newName) throws Exception {
        EntityService.getInstance().validateName(newName);
        String newTestCaseLocation = testCase.getParentFolder().getLocation() + File.separator + newName + TestCaseEntity.getTestCaseFileExtension();
        File newTestCase = new File(newTestCaseLocation);
        if (newTestCase.exists()) {
            throw new DuplicatedFileNameException(MessageFormat.format(StringConstants.MNG_EXC_EXISTED_TEST_CASE_NAME_INSENSITVE, newName));
        }
        TestCaseEntity cloneTestCase = testCase.clone();
        cloneTestCase.setName(newName);
        String newScriptFolderLocation = testCase.getProject().getFolderLocation() + File.separator + GroovyUtil.getScriptPackageRelativePathForTestCase((TestCaseEntity)cloneTestCase);
        if (TestCaseFileServiceManager.isGroovyScriptFolder(newScriptFolderLocation)) {
            throw new DuplicatedFileNameException(MessageFormat.format(StringConstants.MNG_EXC_EXISTED_SCRIPT_FOLDER_NAME, newScriptFolderLocation));
        }
    }

    public static void deleteTestCase(TestCaseEntity testCase) throws Exception {
        if (testCase == null) {
            throw new NoEntityException("");
        }
        EntityFileServiceManager.delete((FileEntity)testCase);
        FolderEntity testCaseRootFolder = FolderFileServiceManager.loadAllTestCaseDescendants(FolderFileServiceManager.getTestCaseRoot(testCase.getProject()));
        GroovyUtil.updateTestCaseDeleted((TestCaseEntity)testCase, (FolderEntity)testCaseRootFolder);
        FolderFileServiceManager.refreshFolder(testCase.getParentFolder());
    }

    public static void deleteTestCaseFolder(FolderEntity folderEntity) throws Exception {
        if (folderEntity != null) {
            FolderEntity testCaseRootFolder = FolderFileServiceManager.loadAllTestCaseDescendants(FolderFileServiceManager.getTestCaseRoot(folderEntity.getProject()));
            TestCaseFileServiceManager.deleteTestCaseAndFolderRecursively(folderEntity, testCaseRootFolder);
            FolderFileServiceManager.refreshFolder(folderEntity.getParentFolder());
        }
    }

    private static void deleteTestCaseAndFolderRecursively(FolderEntity folder, FolderEntity testCaseRootFolder) throws Exception {
        for (TestCaseEntity childTestCase : FolderFileServiceManager.getChildTestCasesOfFolder(folder)) {
            EntityFileServiceManager.delete((FileEntity)childTestCase);
            GroovyUtil.updateTestCaseDeleted((TestCaseEntity)childTestCase, (FolderEntity)testCaseRootFolder);
        }
        for (FolderEntity childFolder : FolderFileServiceManager.getChildFoldersOfFolder(folder)) {
            TestCaseFileServiceManager.deleteTestCaseAndFolderRecursively(childFolder, testCaseRootFolder);
        }
        EntityFileServiceManager.delete((FileEntity)folder);
        GroovyUtil.updateTestCaseFolderDeleted((FolderEntity)folder, (FolderEntity)testCaseRootFolder);
    }

    public static TestCaseEntity getTestCaseByName(FolderEntity parentFolder, String testCaseName) throws Exception {
        List<TestCaseEntity> testCases = FolderFileServiceManager.getChildTestCasesOfFolder(parentFolder);
        for (TestCaseEntity testCase : testCases) {
            if (!testCase.getName().equals(testCaseName)) continue;
            return testCase;
        }
        return null;
    }

    public static TestCaseEntity getByGUID(String guid, ProjectEntity project) throws Exception {
        File testCaseFolder;
        File projectFolder = new File(project.getFolderLocation());
        if (projectFolder.exists() && projectFolder.isDirectory() && (testCaseFolder = new File(FileServiceConstant.getTestCaseRootFolderLocation(projectFolder.getAbsolutePath()))).exists() && testCaseFolder.isDirectory()) {
            return TestCaseFileServiceManager.getByGUID(testCaseFolder.getAbsolutePath(), guid, project);
        }
        return null;
    }

    private static TestCaseEntity getByGUID(String testCaseFolder, String guid, ProjectEntity project) throws Exception {
        File folder = new File(testCaseFolder);
        if (folder.exists() && folder.isDirectory()) {
            File[] fileArray = folder.listFiles(EntityFileServiceManager.fileFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                TestCaseEntity result;
                File file = fileArray[n2];
                if (file.isFile() && file.getName().toLowerCase().endsWith(TestCaseEntity.getTestCaseFileExtension().toLowerCase())) {
                    TestCaseEntity testCase = TestCaseFileServiceManager.getTestCase(file.getAbsolutePath());
                    if (testCase.getTestCaseGuid().equals(guid)) {
                        return testCase;
                    }
                } else if (file.isDirectory() && (result = TestCaseFileServiceManager.getByGUID(file.getAbsolutePath(), guid, project)) != null) {
                    return result;
                }
                ++n2;
            }
        }
        return null;
    }

    public static void updateReferencesTestCaseFolder(String oldFolderLocation, FolderEntity folder, List<TestSuiteEntity> testSuiteEntities) throws Exception {
        String oldFolderDisplayId = oldFolderLocation.replace(File.separator, "/") + "/";
        String folderDisplayId = folder.getRelativePath().replace(File.separator, "/") + "/";
        for (TestSuiteEntity testSuite : testSuiteEntities) {
            boolean save = false;
            for (TestSuiteTestCaseLink testCaseLink : testSuite.getTestSuiteTestCaseLinks()) {
                if (!testCaseLink.getTestCaseId().startsWith(oldFolderDisplayId)) continue;
                testCaseLink.setTestCaseId(StringUtils.replaceOnce((String)testCaseLink.getTestCaseId(), (String)oldFolderDisplayId, (String)folderDisplayId));
                save = true;
            }
            if (!save) continue;
            TestSuiteFileServiceManager.updateTestSuite(testSuite);
        }
        FolderFileServiceManager.refreshFolderScriptReferences(oldFolderDisplayId, folder);
    }

    public static TestCaseEntity getTestCaseByScriptFileName(String scriptFileName, ProjectEntity projectEntity) throws Exception {
        FolderEntity testCaseRootFolder = FolderFileServiceManager.getTestCaseRoot(projectEntity);
        for (TestCaseEntity testCaseEntity : FolderFileServiceManager.getDescendantTestCasesOfFolder(testCaseRootFolder)) {
            if (!scriptFileName.equals(GroovyUtil.getScriptNameForTestCase((TestCaseEntity)testCaseEntity))) continue;
            return testCaseEntity;
        }
        return null;
    }

    public static TestCaseEntity getTestCaseByScriptFilePath(String scriptFilePath, ProjectEntity projectEntity) throws Exception {
        String testCaseId = GroovyUtil.getTestCaseIdByScriptPath((String)scriptFilePath, (ProjectEntity)projectEntity);
        if (testCaseId == null || testCaseId.isEmpty()) {
            return null;
        }
        return TestCaseFileServiceManager.getTestCaseByDisplayId(testCaseId, projectEntity);
    }

    public static TestCaseEntity getTestCaseByDisplayId(String testCaseDisplayId, ProjectEntity projectEntity) throws Exception {
        String projectLocation = projectEntity.getFolderLocation();
        String testCasePk = projectLocation + File.separator + testCaseDisplayId + TestCaseEntity.getTestCaseFileExtension();
        return TestCaseFileServiceManager.getTestCase(testCasePk);
    }

    public static List<TestSuiteEntity> getTestCaseReferences(TestCaseEntity testCase) throws Exception {
        ArrayList<TestSuiteEntity> testCaseReferences = new ArrayList<TestSuiteEntity>();
        String testCaseId = testCase.getRelativePathForUI().replace(File.separator, "/");
        FileServiceDataProviderSetting dataProviderSetting = new FileServiceDataProviderSetting();
        List<TestSuiteEntity> allTestSuites = FolderFileServiceManager.getDescendantTestSuitesOfFolder(FolderFileServiceManager.getTestSuiteRoot(testCase.getProject()));
        for (TestSuiteEntity testSuite : allTestSuites) {
            if (dataProviderSetting.getTestSuiteDataProvider().getTestCaseLink(testSuite, testCaseId).isEmpty()) continue;
            testCaseReferences.add(testSuite);
        }
        return testCaseReferences;
    }

    public static List<TestCaseEntity> getAll(ProjectEntity project) throws DALException {
        try {
            List<TestCaseEntity> allTestCases = EntityFileServiceManager.getDescendants(FolderFileServiceManager.getTestCaseRoot(project), TestCaseEntity.class);
            return allTestCases;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }
}

