/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.client;

import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import net.lightbody.bmp.BrowserMobProxy;
import net.lightbody.bmp.proxy.dns.AdvancedHostResolver;
import net.lightbody.bmp.proxy.dns.ChainedHostResolver;
import net.lightbody.bmp.proxy.dns.DnsJavaResolver;
import net.lightbody.bmp.proxy.dns.NativeCacheManipulatingResolver;
import net.lightbody.bmp.proxy.dns.NativeResolver;
import org.openqa.selenium.Proxy;

public class ClientUtil {
    public static AdvancedHostResolver createNativeCacheManipulatingResolver() {
        return new NativeCacheManipulatingResolver();
    }

    public static AdvancedHostResolver createNativeResolver() {
        return new NativeResolver();
    }

    public static AdvancedHostResolver createDnsJavaResolver() {
        return new DnsJavaResolver();
    }

    public static AdvancedHostResolver createDnsJavaWithNativeFallbackResolver() {
        return new ChainedHostResolver((Collection<? extends AdvancedHostResolver>)ImmutableList.of((Object)new DnsJavaResolver(), (Object)new NativeCacheManipulatingResolver()));
    }

    public static Proxy createSeleniumProxy(BrowserMobProxy browserMobProxy) {
        return ClientUtil.createSeleniumProxy(browserMobProxy, ClientUtil.getConnectableAddress());
    }

    public static Proxy createSeleniumProxy(BrowserMobProxy browserMobProxy, InetAddress connectableAddress) {
        return ClientUtil.createSeleniumProxy(new InetSocketAddress(connectableAddress, browserMobProxy.getPort()));
    }

    public static Proxy createSeleniumProxy(InetSocketAddress connectableAddressAndPort) {
        Proxy proxy = new Proxy();
        proxy.setProxyType(Proxy.ProxyType.MANUAL);
        String proxyStr = String.format("%s:%d", connectableAddressAndPort.getHostString(), connectableAddressAndPort.getPort());
        proxy.setHttpProxy(proxyStr);
        proxy.setSslProxy(proxyStr);
        return proxy;
    }

    public static InetAddress getConnectableAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Could not resolve localhost", e);
        }
    }
}

