/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.execution.testsuite;

import com.kms.katalon.composer.webui.execution.testsuite.RemoteExecutionDriverEntry;
import com.kms.katalon.composer.webui.execution.testsuite.RemoteIntegrationProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class RemoteExecutionIntegrationCollector {
    private List<RemoteIntegrationProvider> executionEntries = new ArrayList<RemoteIntegrationProvider>();
    private static RemoteExecutionIntegrationCollector instance;

    private RemoteExecutionIntegrationCollector() {
    }

    public static RemoteExecutionIntegrationCollector getInstance() {
        if (instance == null) {
            instance = new RemoteExecutionIntegrationCollector();
        }
        return instance;
    }

    public void addNewProvider(RemoteIntegrationProvider executionEntry) {
        this.executionEntries.add(executionEntry);
    }

    public List<RemoteExecutionDriverEntry> getSortedExecutionEntries(String groupName) {
        return this.executionEntries.stream().sorted(new Comparator<RemoteIntegrationProvider>(){

            @Override
            public int compare(RemoteIntegrationProvider entryA, RemoteIntegrationProvider entryB) {
                return entryA.getPreferedOrder() - entryB.getPreferedOrder();
            }
        }).map(provider -> provider.getExecutionEntry(groupName)).filter(entry -> entry != null).collect(Collectors.toList());
    }
}

