/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.inference;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.classgen.asm.MopWriter;
import org.codehaus.groovy.classgen.asm.OptimizingStatementWriter;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

public class STCTypeLookup
implements ITypeLookup {
    private static final boolean isEnabled = CompilerUtils.getActiveGroovyBundle().getVersion().getMajor() >= 2;

    public TypeLookupResult lookupType(Expression expr, VariableScope scope, ClassNode objectExpressionType) {
        if (isEnabled) {
            boolean isGroovy = false;
            boolean isSpread = false;
            Expression declaration = expr;
            ClassNode declaringType = objectExpressionType;
            TypeLookupResult.TypeConfidence confidence = TypeLookupResult.TypeConfidence.INFERRED;
            Object inferredType = expr.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
            if (inferredType == null && expr instanceof VariableExpression) {
                inferredType = expr.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
            }
            if (inferredType instanceof ClassNode) {
                MethodNode methodTarget;
                if (expr instanceof ClassExpression) {
                    declaration = expr.getType();
                } else if (expr instanceof FieldExpression) {
                    declaration = ((FieldExpression)expr).getField();
                    assert (((FieldNode)declaration).getDeclaringClass().equals((Object)declaringType));
                } else if (expr instanceof VariableExpression) {
                    VariableExpression vexp = (VariableExpression)expr;
                    if (vexp.isThisExpression() || vexp.isSuperExpression()) {
                        declaration = (ClassNode)inferredType;
                    } else {
                        MethodNode methodTarget2 = STCTypeLookup.getAstMethodTarget((Expression)vexp);
                        if (methodTarget2 != null) {
                            declaration = methodTarget2;
                            declaringType = methodTarget2.getDeclaringClass();
                        } else {
                            Variable accessedVariable = vexp.getAccessedVariable();
                            if (accessedVariable instanceof AnnotatedNode && (vexp.getEnd() <= 0 || !(accessedVariable instanceof Parameter) || ((Parameter)accessedVariable).getEnd() >= 1)) {
                                declaration = (AnnotatedNode)accessedVariable;
                                declaringType = ((AnnotatedNode)declaration).getDeclaringClass();
                                if (VariableScope.isPlainClosure((ClassNode)((ClassNode)inferredType))) {
                                    VariableScope.VariableInfo info = scope.lookupName(accessedVariable.getName());
                                    if (info != null && VariableScope.isParameterizedClosure((ClassNode)info.type)) {
                                        inferredType = info.type;
                                    }
                                } else if (GroovyUtils.isAnonymous((ClassNode)((ClassNode)inferredType))) {
                                    ClassNode type = (ClassNode)inferredType;
                                    type = type.getUnresolvedSuperClass(false) != VariableScope.OBJECT_CLASS_NODE ? type.getUnresolvedSuperClass(false) : type.getUnresolvedInterfaces()[0];
                                    inferredType = type;
                                }
                            } else {
                                confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                            }
                        }
                    }
                } else if (expr instanceof MethodCall && (methodTarget = STCTypeLookup.getAstMethodTarget(expr)) != null) {
                    declaration = methodTarget;
                    declaringType = methodTarget.getDeclaringClass();
                }
            } else if (expr instanceof ConstantExpression) {
                List methods;
                ASTNode enclosingNode = scope.getEnclosingNode();
                MethodNode methodTarget = null;
                if (enclosingNode instanceof PropertyExpression && ((PropertyExpression)enclosingNode).getProperty() == expr) {
                    isSpread = ((PropertyExpression)enclosingNode).isSpreadSafe();
                    methodTarget = STCTypeLookup.getAstMethodTarget((Expression)((PropertyExpression)enclosingNode));
                    if (methodTarget instanceof MethodNode && methodTarget.isSynthetic()) {
                        declaringType = methodTarget.getOriginal().getDeclaringClass();
                        inferredType = enclosingNode.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                        declaration = declaringType.getProperty(expr.getText());
                        if (declaration != null) {
                            methodTarget = null;
                            if (isSpread) {
                                inferredType = ((PropertyNode)declaration).getType();
                            }
                        }
                    }
                } else if (enclosingNode instanceof MethodCallExpression && ((MethodCallExpression)enclosingNode).getMethod() == expr) {
                    isSpread = ((MethodCallExpression)enclosingNode).isSpreadSafe();
                    methodTarget = STCTypeLookup.getAstMethodTarget((Expression)((MethodCallExpression)enclosingNode));
                    if (methodTarget == null) {
                        methodTarget = STCTypeLookup.getMopMethodTarget((MethodCallExpression)enclosingNode);
                    }
                    if (methodTarget == null) {
                        methodTarget = ((MethodCallExpression)enclosingNode).getMethodTarget();
                    }
                } else if (enclosingNode instanceof MethodPointerExpression && ((MethodPointerExpression)enclosingNode).getMethodName() == expr && (methods = (List)enclosingNode.getNodeMetaData(MethodNode.class)) != null) {
                    methodTarget = (ASTNode)methods.get(0);
                    if (methods.size() > 1) {
                        confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                    }
                }
                if (methodTarget instanceof ExtensionMethodNode) {
                    methodTarget = ((ExtensionMethodNode)methodTarget).getExtensionMethodNode();
                    isGroovy = true;
                }
                if (methodTarget instanceof MethodNode) {
                    declaration = methodTarget.getOriginal();
                    declaringType = ((MethodNode)declaration).getDeclaringClass();
                    if (!isSpread && !(enclosingNode instanceof MethodPointerExpression)) {
                        inferredType = enclosingNode.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                    }
                    if (inferredType == null) {
                        inferredType = methodTarget.getReturnType();
                    }
                }
            }
            if (inferredType instanceof ClassNode) {
                if (declaringType != null) {
                    declaringType = declaringType.getPlainNodeReference();
                }
                if (confidence.isAtLeast(TypeLookupResult.TypeConfidence.INFERRED) && STCTypeLookup.isCompoundAssignTarget(expr, scope) && declaration instanceof MethodNode) {
                    confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                }
                TypeLookupResult result = new TypeLookupResult((ClassNode)inferredType, declaringType, (ASTNode)declaration, confidence, scope);
                result.isGroovy = isGroovy;
                return result;
            }
        }
        return null;
    }

    public TypeLookupResult lookupType(FieldNode node, VariableScope scope) {
        Object inferredType;
        if (isEnabled && (inferredType = node.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE)) instanceof ClassNode) {
            return new TypeLookupResult((ClassNode)inferredType, node.getDeclaringClass(), (ASTNode)node, TypeLookupResult.TypeConfidence.INFERRED, scope);
        }
        return null;
    }

    public TypeLookupResult lookupType(MethodNode node, VariableScope scope) {
        Object inferredType;
        if (isEnabled && (inferredType = node.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE)) instanceof ClassNode) {
            return new TypeLookupResult((ClassNode)inferredType, node.getDeclaringClass(), (ASTNode)node, TypeLookupResult.TypeConfidence.INFERRED, scope);
        }
        return null;
    }

    public TypeLookupResult lookupType(Parameter param, VariableScope scope) {
        Object inferredType;
        if (isEnabled && (inferredType = param.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE)) instanceof ClassNode) {
            return new TypeLookupResult((ClassNode)inferredType, scope.getEnclosingTypeDeclaration(), (ASTNode)param, TypeLookupResult.TypeConfidence.INFERRED, scope);
        }
        return null;
    }

    private static MethodNode getAstMethodTarget(Expression expr) {
        MethodNode node = null;
        OptimizingStatementWriter.StatementMeta meta = (OptimizingStatementWriter.StatementMeta)expr.getNodeMetaData(OptimizingStatementWriter.StatementMeta.class);
        if (meta != null) {
            node = (MethodNode)ReflectionUtils.getPrivateField(OptimizingStatementWriter.StatementMeta.class, (String)"target", (Object)meta);
        }
        if (node == null) {
            node = (MethodNode)expr.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        }
        return node;
    }

    private static MethodNode getMopMethodTarget(MethodCallExpression call) {
        Matcher m;
        if (call.isImplicitThis() && MopWriter.isMopMethod((String)call.getMethodAsString()) && call.getObjectExpression().getNodeMetaData((Object)"OriginalExpression") != null && (m = Pattern.compile("super\\$(\\d+)\\$(.+)").matcher(call.getMethodAsString())).matches()) {
            int dist = Integer.parseInt(m.group(1));
            ArrayList<ClassNode> types = new ArrayList<ClassNode>();
            ClassNode next = call.getMethodTarget().getDeclaringClass();
            while (next != null) {
                types.add(next);
                next = next.getSuperClass();
            }
            String name = m.group(2);
            ClassNode type = (ClassNode)types.get(types.size() - dist);
            return type.getMethod(name, call.getMethodTarget().getParameters());
        }
        return null;
    }

    private static boolean isCompoundAssignTarget(Expression expr, VariableScope scope) {
        boolean isAssignTarget;
        boolean bl = isAssignTarget = scope.getWormhole().get("lhs") == expr || expr.getNodeMetaData((Object)"rhsType") != null;
        return isAssignTarget && scope.getEnclosingAssignmentOperator().filter(op -> op.getType() != 100).isPresent();
    }
}

