/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.views;

import com.kms.katalon.composer.components.impl.dialogs.CommonNewEntityDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testdata.constants.ComposerTestdataMessageConstants;
import com.kms.katalon.composer.testdata.constants.StringConstants;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NewTestDataDialog
extends CommonNewEntityDialog<DataFileEntity> {
    private String dataSource = DataFileEntity.DataFileDriverType.stringValues()[0];
    private Combo cbDataSourceType;

    public NewTestDataDialog(Shell parentShell, FolderEntity parentFolder, String suggestedName) {
        super(parentShell, parentFolder, suggestedName);
        this.setDialogTitle(StringConstants.VIEW_TITLE_TEST_DATA);
        this.setDialogMsg(ComposerTestdataMessageConstants.VIEW_MSG_CREATE_NEW_TEST_DATA);
    }

    protected Control createEntityCustomControl(Composite parent, int column, int span) {
        this.createDataSourceTypeControl(parent, column);
        return super.createEntityCustomControl(parent, column, span);
    }

    private Control createDataSourceTypeControl(Composite parent, int column) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(column, false));
        Label labelDataSourceType = new Label(parent, 0);
        labelDataSourceType.setText(ComposerTestdataMessageConstants.VIEW_LBL_DATA_TYPE);
        this.cbDataSourceType = new Combo(parent, 8);
        this.cbDataSourceType.setLayoutData((Object)new GridData(768));
        this.cbDataSourceType.setItems(DataFileEntity.DataFileDriverType.stringValues());
        this.cbDataSourceType.select(0);
        this.cbDataSourceType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewTestDataDialog.this.setDataSource(((Combo)e.getSource()).getText());
            }
        });
        return parent;
    }

    private void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    protected void createEntity() {
        try {
            this.entity = TestDataController.getInstance().newTestDataWithoutSave(this.parentFolder, this.getName());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void setEntityProperties() {
        super.setEntityProperties();
        ((DataFileEntity)this.entity).setDriver(DataFileEntity.DataFileDriverType.fromValue((String)this.dataSource));
        ((DataFileEntity)this.entity).setContainsHeaders(true);
    }
}

